/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.loaderv2.types.NiftyControlsType;
import de.lessvoid.nifty.loaderv2.types.NiftyStylesType;
import de.lessvoid.nifty.loaderv2.types.NiftyType;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.xml.lwxs.Schema;
import de.lessvoid.xml.xpp3.XmlParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class NiftyLoader {
    @Nonnull
    private static final Logger log = Logger.getLogger(NiftyLoader.class.getName());
    @Nonnull
    private final Map<String, Schema> schemes = new HashMap<String, Schema>();
    @Nonnull
    private final TimeProvider timeProvider;
    @Nonnull
    private final Nifty nifty;
    @Nonnull
    private final XmlPullParserFactory parserFactory;

    public NiftyLoader(@Nonnull Nifty nifty, @Nonnull TimeProvider timeProvider) {
        try {
            this.parserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Failure to load the XmlPullParser, something is badly wrong!", e);
        }
        this.parserFactory.setValidating(false);
        this.parserFactory.setNamespaceAware(true);
        this.nifty = nifty;
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public NiftyType loadNiftyXml(@Nonnull String schemaId, @Nonnull @WillClose InputStream inputStreamXml) throws Exception {
        try {
            long start = this.timeProvider.getMsTime();
            log.fine("loading new nifty xml file with schemaId [" + schemaId + "]");
            XmlParser parser = new XmlParser(this.parserFactory.newPullParser());
            parser.read(inputStreamXml);
            NiftyType niftyType = (NiftyType)this.getSchema(schemaId).loadXml(parser);
            niftyType.loadStyles(this, this.nifty);
            niftyType.loadControls(this);
            long end = this.timeProvider.getMsTime();
            log.fine("loaded nifty xml file with schemaId [" + schemaId + "] took [" + (end - start) + " ms]");
            NiftyType niftyType2 = niftyType;
            return niftyType2;
        }
        finally {
            NiftyLoader.closeSilently(inputStreamXml);
        }
    }

    @Deprecated
    public boolean validateNiftyXml(@Nonnull @WillClose InputStream inputStreamXml) throws Exception {
        return this.validateNiftyXml("nifty.xsd", inputStreamXml);
    }

    public boolean validateNiftyXml(@Nonnull String schemaId, @Nonnull @WillClose InputStream inputStreamXml) throws Exception {
        long start = this.timeProvider.getMsTime();
        this.validate(schemaId, inputStreamXml);
        long end = this.timeProvider.getMsTime();
        log.fine("validating nifty xml took [" + (end - start) + " ms]");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(@Nonnull String schemaId, @Nonnull @WillClose InputStream inputStreamXml) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            Document document = parser.parse(inputStreamXml);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream schemaStream = this.nifty.getResourceAsStream(schemaId);
            try {
                StreamSource schemaFile = new StreamSource(schemaStream);
                javax.xml.validation.Schema schema = factory.newSchema(schemaFile);
                Validator validator = schema.newValidator();
                validator.validate(new DOMSource(document));
            }
            finally {
                NiftyLoader.closeSilently(schemaStream);
            }
        }
        finally {
            NiftyLoader.closeSilently(inputStreamXml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStyleFile(@Nonnull String schemaId, @Nonnull String styleFilename, @Nonnull NiftyType niftyType, @Nonnull Nifty nifty) throws Exception {
        log.fine("loading new nifty style xml file [" + styleFilename + "] with schemaId [" + schemaId + "]");
        XmlParser parser = new XmlParser(this.parserFactory.newPullParser());
        InputStream stream = null;
        try {
            stream = nifty.getResourceAsStream(styleFilename);
            if (stream == null) {
                throw new IOException("Failed to load style. Resource \"" + styleFilename + "\" not found");
            }
            parser.read(stream);
            NiftyStylesType niftyStylesType = (NiftyStylesType)this.getSchema(schemaId).loadXml(parser);
            niftyStylesType.loadStyles(this, niftyType, nifty, log);
        }
        finally {
            NiftyLoader.closeSilently(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadControlFile(@Nonnull String schemaId, @Nonnull String controlFilename, @Nonnull NiftyType niftyType) throws Exception {
        log.fine("loading new nifty controls xml file [" + controlFilename + "] with schemaId [" + schemaId + "]");
        XmlParser parser = new XmlParser(this.parserFactory.newPullParser());
        InputStream stream = null;
        try {
            stream = this.nifty.getResourceAsStream(controlFilename);
            if (stream == null) {
                throw new IOException("Failed to load control. Resource \"" + controlFilename + "\" not found");
            }
            parser.read(stream);
            NiftyControlsType niftyControlsType = (NiftyControlsType)this.getSchema(schemaId).loadXml(parser);
            niftyControlsType.loadControls(this, niftyType);
        }
        catch (Throwable throwable) {
            NiftyLoader.closeSilently(stream);
            throw throwable;
        }
        NiftyLoader.closeSilently(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSchema(@Nonnull String schemaId, @Nonnull @WillClose InputStream inputStreamSchema) throws Exception {
        try {
            Schema niftyXmlSchema = new Schema(this.parserFactory, this.nifty.getResourceLoader());
            XmlParser parser = new XmlParser(this.parserFactory.newPullParser());
            parser.read(inputStreamSchema);
            parser.nextTag();
            parser.required("nxs", niftyXmlSchema);
            this.schemes.put(schemaId, niftyXmlSchema);
        }
        finally {
            NiftyLoader.closeSilently(inputStreamSchema);
        }
    }

    @Nonnull
    private Schema getSchema(@Nonnull String schemaId) throws Exception {
        Schema niftyXmlSchema = this.schemes.get(schemaId);
        if (niftyXmlSchema == null) {
            throw new Exception("unknown schemaId [" + schemaId + "]");
        }
        return niftyXmlSchema;
    }

    private static void closeSilently(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

