/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements.render;

import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ElementRenderer;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PanelRenderer
implements ElementRenderer {
    @Nullable
    private Color backgroundColor;
    @Nullable
    private Color debugColor;

    @Override
    public void render(@Nonnull Element element, @Nonnull NiftyRenderEngine r) {
        if (element.getNifty().isDebugOptionPanelColors()) {
            r.saveStates();
            r.setColor(this.getDebugColor());
            r.renderQuad(element.getX(), element.getY(), element.getWidth(), element.getHeight());
            r.restoreStates();
            return;
        }
        if (this.backgroundColor != null) {
            r.saveStates();
            if (!r.isColorChanged()) {
                if (r.isColorAlphaChanged()) {
                    r.setColorIgnoreAlpha(this.backgroundColor);
                } else {
                    r.setColor(this.backgroundColor);
                }
            }
            r.renderQuad(element.getX(), element.getY(), element.getWidth(), element.getHeight());
            r.restoreStates();
        }
    }

    @Nonnull
    private Color getDebugColor() {
        if (this.debugColor != null) {
            return this.debugColor;
        }
        Random rnd = new Random();
        this.debugColor = new Color(rnd.nextFloat(), rnd.nextFloat(), rnd.nextFloat(), 0.5f);
        return this.debugColor;
    }

    public void setBackgroundColor(@Nullable Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Nullable
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

