/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements.events;

import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import javax.annotation.Nonnull;

public class NiftyMouseEvent
implements NiftyEvent {
    private final Element element;
    private final int mouseX;
    private final int mouseY;
    private final int mouseWheel;
    private final boolean button0Down;
    private final boolean button1Down;
    private final boolean button2Down;
    private final boolean button0InitialDown;
    private final boolean button1InitialDown;
    private final boolean button2InitialDown;
    private final boolean button0Release;
    private final boolean button1Release;
    private final boolean button2Release;

    public NiftyMouseEvent(Element element, @Nonnull NiftyMouseInputEvent source) {
        this.element = element;
        this.mouseX = source.getMouseX();
        this.mouseY = source.getMouseY();
        this.mouseWheel = source.getMouseWheel();
        this.button0Down = source.isButton0Down();
        this.button1Down = source.isButton1Down();
        this.button2Down = source.isButton2Down();
        this.button0InitialDown = source.isButton0InitialDown();
        this.button1InitialDown = source.isButton1InitialDown();
        this.button2InitialDown = source.isButton2InitialDown();
        this.button0Release = source.isButton0Release();
        this.button1Release = source.isButton1Release();
        this.button2Release = source.isButton2Release();
    }

    public Element getElement() {
        return this.element;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public int getMouseWheel() {
        return this.mouseWheel;
    }

    public boolean isButton0Down() {
        return this.button0Down;
    }

    public boolean isButton1Down() {
        return this.button1Down;
    }

    public boolean isButton2Down() {
        return this.button2Down;
    }

    public boolean isAnyButtonDown() {
        return this.button0Down || this.button1Down || this.button2Down;
    }

    public boolean isButton0InitialDown() {
        return this.button0InitialDown;
    }

    public boolean isButton1InitialDown() {
        return this.button1InitialDown;
    }

    public boolean isButton2InitialDown() {
        return this.button2InitialDown;
    }

    public boolean isButton0Release() {
        return this.button0Release;
    }

    public boolean isButton1Release() {
        return this.button1Release;
    }

    public boolean isButton2Release() {
        return this.button2Release;
    }

    @Nonnull
    public String toString() {
        return "mouseX = " + this.mouseX + ", mouseY = " + this.mouseY + ", button0Down = " + this.button0Down + ", button1Down = " + this.button1Down + ", button2Down = " + this.button2Down + ", button0InitialDown = " + this.button0InitialDown + ", button1InitialDown = " + this.button1InitialDown + ", button2InitialDown = " + this.button2InitialDown + ", button0Release = " + this.button0Release + ", button1Release = " + this.button1Release + ", button2Release = " + this.button2Release;
    }
}

