/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyMethodInvoker;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.MouseClickMethods;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ElementInteractionClickHandler {
    private static final Logger logger = Logger.getLogger(ElementInteractionClickHandler.class.getName());
    private static final long REPEATED_CLICK_START_TIME_MS = 100L;
    private static final long REPEATED_CLICK_TIME_MS = 100L;
    private static final int CLICK_COUNT_RECORD_TIME_MS = 500;
    private final Nifty nifty;
    private final Element element;
    private final MouseClickMethods mouseMethods;
    private boolean isMouseDown;
    private boolean onClickRepeatEnabled;
    private int lastMouseX;
    private int lastMouseY;
    private long deltaTimeMs;
    private long mouseDownTimeMs;
    private long lastClickTimeMs;
    private long lastRepeatStartTimeMs;
    private int clickCounter;

    public ElementInteractionClickHandler(Nifty nifty, Element element, MouseClickMethods mouseMethods) {
        this.nifty = nifty;
        this.element = element;
        this.mouseMethods = mouseMethods;
        this.clickCounter = 1;
        this.setMouseDown(false, 0L);
    }

    public MouseClickMethods getMouseMethods() {
        return this.mouseMethods;
    }

    public void setOnClickRepeatEnabled(boolean onClickRepeatEnabled) {
        this.onClickRepeatEnabled = onClickRepeatEnabled;
    }

    public boolean isOnClickRepeatEnabled() {
        return this.onClickRepeatEnabled;
    }

    public boolean process(@Nonnull NiftyMouseInputEvent mouseEvent, boolean isButtonDown, boolean isInitialButtonDown, boolean isButtonRelease, long eventTimeMs, boolean mouseInside, boolean canHandleInteraction, boolean hasMouseAccess, String onClickAlternateKey) {
        long pastTimeMs;
        long repeatTimeMs;
        long deltaTimeMs;
        if (this.onClickRepeatEnabled && mouseInside && this.isMouseDown && isButtonDown && (deltaTimeMs = eventTimeMs - this.mouseDownTimeMs) > 100L && (repeatTimeMs = (pastTimeMs = deltaTimeMs - 100L) - this.lastRepeatStartTimeMs) > 100L) {
            this.lastRepeatStartTimeMs = pastTimeMs;
            if (this.onClickMouse(this.element.getId(), mouseEvent, canHandleInteraction, onClickAlternateKey)) {
                return true;
            }
        }
        boolean processed = false;
        if (mouseInside && !this.isMouseDown) {
            if (isButtonDown && isInitialButtonDown) {
                this.deltaTimeMs += eventTimeMs - this.lastClickTimeMs;
                this.setMouseDown(true, eventTimeMs);
                if (this.deltaTimeMs > (long)this.calculateMulticlickThresholdTimeMs()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("eventTimeMs: " + eventTimeMs + ", lastClickTimeMs: " + this.lastClickTimeMs + ", deltaTimeMs: " + this.deltaTimeMs + " => INITIAL CLICK");
                    }
                    this.lastClickTimeMs = eventTimeMs;
                    this.deltaTimeMs = 0L;
                    this.clickCounter = 1;
                    this.onInitialClick();
                    this.onClickMouse(this.element.getId(), mouseEvent, canHandleInteraction, onClickAlternateKey);
                } else {
                    ++this.clickCounter;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("eventTimeMs: " + eventTimeMs + ", lastClickTimeMs: " + this.lastClickTimeMs + ", deltaTimeMs: " + this.deltaTimeMs + " => MULTI CLICK: " + this.clickCounter);
                    }
                    this.onMultiClickMouse(this.element.getId(), mouseEvent, canHandleInteraction, onClickAlternateKey);
                }
                processed = true;
            }
        } else if (!isButtonDown && this.isMouseDown) {
            this.setMouseDown(false, eventTimeMs);
        }
        if (isButtonRelease && (mouseInside || hasMouseAccess)) {
            this.onMouseRelease(mouseEvent);
            processed = true;
        }
        if (this.isMouseDown) {
            this.onClickMouseMove(mouseEvent);
            processed = true;
        }
        return processed;
    }

    private void setMouseDown(boolean newMouseDown, long eventTimeMs) {
        this.mouseDownTimeMs = eventTimeMs;
        this.lastRepeatStartTimeMs = 0L;
        this.isMouseDown = newMouseDown;
    }

    public void resetMouseDown() {
        this.isMouseDown = false;
    }

    private void onInitialClick() {
        this.mouseMethods.onInitialClick();
    }

    private boolean onClickMouse(String elementId, @Nonnull NiftyMouseInputEvent inputEvent, boolean canHandleInteraction, String onClickAlternateKey) {
        if (!canHandleInteraction) {
            return false;
        }
        this.lastMouseX = inputEvent.getMouseX();
        this.lastMouseY = inputEvent.getMouseY();
        return this.mouseMethods.onClick(this.nifty, onClickAlternateKey, inputEvent);
    }

    private boolean onMultiClickMouse(String elementId, @Nonnull NiftyMouseInputEvent inputEvent, boolean canHandleInteraction, String onClickAlternateKey) {
        if (!canHandleInteraction) {
            return false;
        }
        this.lastMouseX = inputEvent.getMouseX();
        this.lastMouseY = inputEvent.getMouseY();
        return this.mouseMethods.onMultiClick(this.nifty, onClickAlternateKey, inputEvent, this.clickCounter);
    }

    private boolean onClickMouseMove(@Nonnull NiftyMouseInputEvent inputEvent) {
        if (this.lastMouseX == inputEvent.getMouseX() && this.lastMouseY == inputEvent.getMouseY()) {
            return false;
        }
        this.lastMouseX = inputEvent.getMouseX();
        this.lastMouseY = inputEvent.getMouseY();
        return this.mouseMethods.onClickMouseMove(this.nifty, inputEvent);
    }

    private boolean onMouseRelease(@Nonnull NiftyMouseInputEvent mouseEvent) {
        return this.mouseMethods.onRelease(this.nifty, mouseEvent);
    }

    public void clickAndReleaseMouse(@Nonnull Nifty nifty) {
        this.element.startEffectWithoutChildren(EffectEventId.onClick);
        this.mouseMethods.clickAndRelease(nifty);
    }

    public void setOnClickMethod(NiftyMethodInvoker onClickMethod) {
        this.mouseMethods.setOnClickMethod(onClickMethod);
    }

    public void setOnMultiClickMethod(NiftyMethodInvoker onMultiClickMethod) {
        this.mouseMethods.setMultiClickMethod(onMultiClickMethod);
    }

    public void setOnClickMouseMoveMethod(NiftyMethodInvoker onClickMouseMoveMethod) {
        this.mouseMethods.setOnClickMouseMoveMethod(onClickMouseMoveMethod);
    }

    public void setOnReleaseMethod(NiftyMethodInvoker onReleaseMethod) {
        this.mouseMethods.setOnReleaseMethod(onReleaseMethod);
    }

    private int calculateMulticlickThresholdTimeMs() {
        Properties globalProperties = this.nifty.getGlobalProperties();
        if (globalProperties == null) {
            return 500;
        }
        String threshold = globalProperties.getProperty("MULTI_CLICK_TIME");
        try {
            return Integer.parseInt(threshold);
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid value for global property \"MULTI_CLICK_TIME\": " + threshold + " (ms). Falling back to default value of " + 500 + " (ms).");
            return 500;
        }
    }
}

