/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RenderQuad
implements EffectImpl {
    @Nonnull
    private final Color currentColor = new Color("#000f");
    @Nonnull
    private final Color tempColor = new Color("#000f");
    private Color startColor;
    private Color endColor;
    private SizeValue width;

    @Override
    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.startColor = new Color(parameter.getProperty("startColor", "#0000"));
        this.endColor = new Color(parameter.getProperty("endColor", "#ffff"));
        this.width = new SizeValue(parameter.getProperty("width"));
    }

    @Override
    public void execute(@Nonnull Element element, float normalizedTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        r.saveStates();
        this.currentColor.linear(this.startColor, this.endColor, normalizedTime);
        if (falloff == null) {
            r.setColor(this.currentColor);
        } else {
            this.tempColor.multiply(this.currentColor, falloff.getFalloffValue());
            r.setColor(this.tempColor);
        }
        int size = this.width.getValueAsInt(element.getParent().getWidth());
        if (size == -1) {
            r.renderQuad(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        } else {
            r.renderQuad(element.getX() + element.getWidth() / 2 - size / 2, element.getY(), size, element.getHeight());
        }
        r.restoreStates();
    }

    @Override
    public void deactivate() {
    }
}

