/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dynamic.attributes;

import de.lessvoid.nifty.loaderv2.types.EffectType;
import de.lessvoid.nifty.loaderv2.types.EffectValueType;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ControlEffectAttributes {
    @Nonnull
    protected Attributes attributes = new Attributes();
    @Nonnull
    protected List<EffectValueType> effectValues = new ArrayList<EffectValueType>();

    public ControlEffectAttributes() {
    }

    public ControlEffectAttributes(@Nonnull Attributes attributes, @Nonnull List<EffectValueType> effectValues) {
        this.attributes = new Attributes(attributes);
        this.effectValues = new ArrayList<EffectValueType>(effectValues);
        Collections.copy(this.effectValues, effectValues);
    }

    public void setAttribute(@Nonnull String name, @Nonnull String value) {
        this.attributes.set(name, value);
    }

    public void setInherit(@Nonnull String inherit) {
        this.attributes.set("inherit", inherit);
    }

    public void setPost(@Nonnull String post) {
        this.attributes.set("post", post);
    }

    public void setOverlay(@Nonnull String overlay) {
        this.attributes.set("overlay", overlay);
    }

    public void setAlternateEnable(@Nonnull String alternateEnable) {
        this.attributes.set("alternateEnable", alternateEnable);
    }

    public void setAlternateDisable(@Nonnull String alternateDisable) {
        this.attributes.set("alternateDisable", alternateDisable);
    }

    public void setCustomKey(@Nonnull String customKey) {
        this.attributes.set("customKey", customKey);
    }

    public void setNeverStopRendering(@Nonnull String neverStopRendering) {
        this.attributes.set("neverStopRendering", neverStopRendering);
    }

    public void setName(@Nonnull String name) {
        this.attributes.set("name", name);
    }

    public void setStartDelay(@Nonnull String value) {
        this.attributes.set("startDelay", value);
    }

    public void setLength(@Nonnull String value) {
        this.attributes.set("length", value);
    }

    public void setOneShot(@Nonnull String value) {
        this.attributes.set("oneShot", value);
    }

    public void setTimeType(@Nonnull String value) {
        this.attributes.set("timeType", value);
    }

    public void setOnStartEffectCallback(@Nonnull String value) {
        this.attributes.set("onStartEffect", value);
    }

    public void setOnEndEffectCallback(@Nonnull String value) {
        this.attributes.set("onEndEffect", value);
    }

    public void addEffectValues(EffectValueType value) {
        this.effectValues.add(value);
    }

    @Nonnull
    public EffectType create() {
        EffectType effectType = new EffectType(this.attributes);
        for (int i = 0; i < this.effectValues.size(); ++i) {
            effectType.addValue(this.effectValues.get(i));
        }
        return effectType;
    }
}

