/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dynamic.attributes;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.controls.StandardControl;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectOnHoverAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectsAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlInteractAttributes;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.loaderv2.types.AttributesType;
import de.lessvoid.nifty.loaderv2.types.ControlType;
import de.lessvoid.nifty.loaderv2.types.EffectsType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.ImageType;
import de.lessvoid.nifty.loaderv2.types.InteractType;
import de.lessvoid.nifty.loaderv2.types.LayerType;
import de.lessvoid.nifty.loaderv2.types.PanelType;
import de.lessvoid.nifty.loaderv2.types.PopupType;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.loaderv2.types.TextType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ControlAttributes {
    @Nonnull
    private final Attributes attributes;
    @Nullable
    private ControlInteractAttributes interact;
    @Nullable
    private ControlEffectsAttributes effects;
    private boolean isAutoId = false;

    public ControlAttributes() {
        this.attributes = new Attributes();
    }

    public ControlAttributes(@Nonnull ElementType type) {
        this.attributes = new Attributes(type.getAttributes());
        InteractType interactType = type.getInteract();
        this.interact = new ControlInteractAttributes(interactType);
        EffectsType effectsType = type.getEffects();
        this.effects = new ControlEffectsAttributes(effectsType);
    }

    @Nonnull
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Nonnull
    protected ControlInteractAttributes getInteract() {
        if (this.interact == null) {
            this.interact = new ControlInteractAttributes();
        }
        return this.interact;
    }

    @Nonnull
    protected ControlEffectsAttributes getEffects() {
        if (this.effects == null) {
            this.effects = new ControlEffectsAttributes();
        }
        return this.effects;
    }

    public void setInteract(@Nullable ControlInteractAttributes controlInteract) {
        this.interact = controlInteract;
    }

    public void setEffects(@Nullable ControlEffectsAttributes controlEffects) {
        this.effects = controlEffects;
    }

    public void set(@Nonnull String key, @Nonnull String value) {
        this.attributes.set(key, value);
    }

    @Nullable
    public String get(@Nonnull String key) {
        return this.attributes.get(key);
    }

    public void setId(@Nonnull String id) {
        this.isAutoId = false;
        this.set("id", id);
    }

    @Nullable
    public String getId() {
        return this.get("id");
    }

    public void setAutoId() {
        this.setAutoId(NiftyIdCreator.generate());
    }

    public void setAutoId(@Nonnull String id) {
        this.isAutoId = true;
        this.set("id", id);
    }

    public boolean isAutoId() {
        return this.isAutoId;
    }

    public void setName(@Nonnull String name) {
        this.set("name", name);
    }

    public void setHeight(@Nonnull String height) {
        this.set("height", height);
    }

    public void setWidth(@Nonnull String width) {
        this.set("width", width);
    }

    public void setX(@Nonnull String x) {
        this.set("x", x);
    }

    public void setY(@Nonnull String y) {
        this.set("y", y);
    }

    public void setAlign(@Nonnull String align) {
        this.set("align", align);
    }

    public void setVAlign(@Nonnull String valign) {
        this.set("valign", valign);
    }

    public void setPadding(@Nonnull String padding) {
        this.set("padding", padding);
    }

    public void setPaddingLeft(@Nonnull String paddingLeft) {
        this.set("paddingLeft", paddingLeft);
    }

    public void setPaddingRight(@Nonnull String paddingRight) {
        this.set("paddingRight", paddingRight);
    }

    public void setPaddingTop(@Nonnull String paddingTop) {
        this.set("paddingTop", paddingTop);
    }

    public void setPaddingBottom(@Nonnull String paddingBottom) {
        this.set("paddingBottom", paddingBottom);
    }

    public void setMargin(@Nonnull String margin) {
        this.set("margin", margin);
    }

    public void setMarginLeft(@Nonnull String marginLeft) {
        this.set("marginLeft", marginLeft);
    }

    public void setMarginRight(@Nonnull String marginRight) {
        this.set("marginRight", marginRight);
    }

    public void setMarginTop(@Nonnull String marginTop) {
        this.set("marginTop", marginTop);
    }

    public void setMarginBottom(@Nonnull String marginBottom) {
        this.set("marginBottom", marginBottom);
    }

    public void setChildClip(@Nonnull String childClip) {
        this.set("childClip", childClip);
    }

    public void setRenderOrder(int renderOrder) {
        this.set("renderOrder", String.valueOf(renderOrder));
    }

    public void setVisible(@Nonnull String visible) {
        this.set("visible", visible);
    }

    public void setVisibleToMouse(@Nonnull String visibleToMouse) {
        this.set("visibleToMouse", visibleToMouse);
    }

    public void setChildLayout(@Nonnull String childLayout) {
        this.set("childLayout", childLayout);
    }

    public void setFocusable(@Nonnull String focusable) {
        this.set("focusable", focusable);
    }

    public void setFocusableInsertBeforeElementId(@Nonnull String focusableInsertBeforeElementId) {
        this.set("focusableInsertBeforeElementId", focusableInsertBeforeElementId);
    }

    public void setFont(@Nonnull String font) {
        this.set("font", font);
    }

    public void setTextHAlign(@Nonnull String textHAlign) {
        this.set("textHAlign", textHAlign);
    }

    public void setTextVAlign(@Nonnull String textVAlign) {
        this.set("textVAlign", textVAlign);
    }

    public void setColor(@Nonnull String color) {
        this.set("color", color);
    }

    public void setSelectionColor(@Nonnull String selectionColor) {
        this.set("selectionColor", selectionColor);
    }

    public void setText(@Nonnull String text) {
        this.set("text", text);
    }

    public void setBackgroundColor(@Nonnull String backgroundColor) {
        this.set("backgroundColor", backgroundColor);
    }

    public void setBackgroundImage(@Nonnull String backgroundImage) {
        this.set("backgroundImage", backgroundImage);
    }

    public void setImageMode(@Nonnull String imageMode) {
        this.set("imageMode", imageMode);
    }

    public void setFilename(@Nonnull String filename) {
        this.set("filename", filename);
    }

    public void setInset(@Nonnull String inset) {
        this.set("inset", inset);
    }

    public void setController(@Nonnull String controller) {
        this.set("controller", controller);
    }

    public void setInputMapping(@Nonnull String inputMapping) {
        this.set("inputMapping", inputMapping);
    }

    public void setStyle(@Nonnull String style) {
        this.set("style", style);
    }

    public void setInteractAttribute(@Nonnull String name, @Nonnull String value) {
        this.getInteract().setAttribute(name, value);
    }

    public void setInteractOnClick(@Nonnull String onClick) {
        this.getInteract().setOnClick(onClick);
    }

    public void setIneractOnMultiClick(@Nonnull String onClick) {
        this.getInteract().setOnMultiClick(onClick);
    }

    public void setInteractOnRelease(@Nonnull String onRelease) {
        this.getInteract().setOnRelease(onRelease);
    }

    public void setInteractOnMouseOver(@Nonnull String onMouseOver) {
        this.getInteract().setOnMouseOver(onMouseOver);
    }

    public void setInteractOnClickRepeat(@Nonnull String onClickRepeat) {
        this.getInteract().setOnClickRepeat(onClickRepeat);
    }

    public void setInteractOnClickMouseMove(@Nonnull String onClickMouseMove) {
        this.getInteract().setOnClickMouseMove(onClickMouseMove);
    }

    public void setInteractOnClickAlternateKey(@Nonnull String onClickAlternateKey) {
        this.getInteract().setOnClickAlternateKey(onClickAlternateKey);
    }

    public void setEffectsAttribute(@Nonnull String name, @Nonnull String value) {
        this.getEffects().setAttribute(name, value);
    }

    public void setEffectsOverlay(@Nonnull String overlay) {
        this.getEffects().setOverlay(overlay);
    }

    public void addEffects(@Nonnull EffectEventId eventId, @Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addEffectAttribute(eventId, effectParam);
    }

    public void addEffectsOnStartScreen(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnStartScreen(effectParam);
    }

    public void addEffectsOnEndScreen(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnEndScreen(effectParam);
    }

    public void addEffectsOnHover(@Nonnull ControlEffectOnHoverAttributes effectParam) {
        this.getEffects().addOnHover(effectParam);
    }

    public void addEffectsOnStartHover(@Nonnull ControlEffectOnHoverAttributes effectParam) {
        this.getEffects().addOnStartHover(effectParam);
    }

    public void addEffectsOnEndHover(@Nonnull ControlEffectOnHoverAttributes effectParam) {
        this.getEffects().addOnEndHover(effectParam);
    }

    public void addEffectsOnClick(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnClick(effectParam);
    }

    public void addEffectsOnFocus(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnFocus(effectParam);
    }

    public void addEffectsOnLostFocus(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnLostFocus(effectParam);
    }

    public void addEffectsOnGetFocus(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnGetFocus(effectParam);
    }

    public void addEffectsOnActive(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnActive(effectParam);
    }

    public void addEffectsOnShow(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnShow(effectParam);
    }

    public void addEffectsOnHide(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnHide(effectParam);
    }

    public void addEffectsOnCustom(@Nonnull ControlEffectAttributes effectParam) {
        this.getEffects().addOnCustom(effectParam);
    }

    @Nonnull
    protected Element createControlInternal(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent) {
        ControlType controlType = new ControlType(this.attributes);
        return this.buildControl(nifty, screen, parent, controlType, new LayoutPart());
    }

    @Nonnull
    protected Element createText(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent) {
        TextType textType = new TextType(this.attributes);
        return this.buildControl(nifty, screen, parent, textType, new LayoutPart());
    }

    @Nonnull
    protected Element createPanel(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent) {
        PanelType panelType = new PanelType(this.attributes);
        return this.buildControl(nifty, screen, parent, panelType, new LayoutPart());
    }

    protected void registerPopup(@Nonnull Nifty nifty) {
        PopupType popupType = new PopupType(this.attributes);
        popupType.translateSpecialValues(nifty, null);
        nifty.registerPopup(popupType);
    }

    @Nonnull
    protected Element createLayer(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent) {
        LayerType layerType = new LayerType(this.attributes);
        return this.buildControl(nifty, screen, parent, layerType, nifty.getRootLayerFactory().createRootLayerLayoutPart(nifty));
    }

    @Nonnull
    protected Element createImage(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent) {
        ImageType imageType = new ImageType(this.attributes);
        return this.buildControl(nifty, screen, parent, imageType, new LayoutPart());
    }

    @Nonnull
    private Element buildControl(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent, @Nonnull ElementType elementType, @Nonnull LayoutPart layoutPart) {
        if (this.effects != null) {
            elementType.setEffect(this.effects.create());
        }
        if (this.interact != null) {
            elementType.setInteract(this.interact.create());
        }
        elementType.prepare(nifty, screen, parent.getElementType());
        elementType.connectParentControls(parent);
        Element element = elementType.create(parent, nifty, screen, layoutPart);
        parent.layoutElements();
        return element;
    }

    @Nonnull
    protected StandardControl getStandardControl() {
        return new StandardControl(){

            @Override
            @Nonnull
            public Element createControl(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent) {
                return ControlAttributes.this.createControlInternal(nifty, screen, parent);
            }
        };
    }

    public void refreshAttributes(@Nonnull Attributes attrib) {
        attrib.refreshFromAttributes(this.attributes);
    }

    public void refreshEffects(@Nonnull EffectsType effects) {
        if (this.effects != null) {
            effects.refreshFromAttributes(this.effects);
        }
    }

    @Nullable
    public ElementType createType() {
        return null;
    }

    public void connect(@Nonnull ElementType e) {
        if (this.effects != null) {
            e.setEffect(this.effects.create());
        }
        if (this.interact != null) {
            e.setInteract(this.interact.create());
        }
    }

    @Nonnull
    public StyleType createStyleType(@Nonnull Attributes styleAttributes) {
        StyleType styleType = new StyleType(styleAttributes);
        styleType.setAttributes(new AttributesType(this.attributes));
        if (this.effects != null) {
            styleType.setEffect(this.effects.create());
        }
        if (this.interact != null) {
            styleType.setInteract(this.interact.create());
        }
        return styleType;
    }
}

