/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.Screen;
import javax.annotation.Nonnull;

public class MenuItemControl
extends AbstractController {
    private Screen screen;
    private FocusHandler focusHandler;

    @Override
    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screenParam, @Nonnull Element newElement, @Nonnull Parameters properties) {
        this.bind(newElement);
        this.screen = screenParam;
    }

    @Override
    public void onStartScreen() {
        this.focusHandler = this.screen.getFocusHandler();
    }

    @Override
    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        Element element = this.getElement();
        if (element == null) {
            return false;
        }
        if (inputEvent == NiftyStandardInputEvent.NextInputElement) {
            if (this.focusHandler != null) {
                Element nextElement = this.focusHandler.getNext(element);
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyStandardInputEvent.PrevInputElement) {
            if (this.focusHandler != null) {
                Element prevElement = this.focusHandler.getPrev(element);
                prevElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyStandardInputEvent.MoveCursorDown) {
            Element nextElement;
            if (this.focusHandler != null && (nextElement = this.focusHandler.getNext(element)).getParent().equals(element.getParent())) {
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyStandardInputEvent.MoveCursorUp) {
            Element prevElement;
            if (this.focusHandler != null && (prevElement = this.focusHandler.getPrev(element)).getParent().equals(element.getParent())) {
                prevElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyStandardInputEvent.Activate) {
            element.onClickAndReleasePrimaryMouseButton();
            return true;
        }
        return false;
    }

    @Override
    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
    }
}

