/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.HoverEffectBuilder;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectsAttributes;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class StyleBuilder {
    @Nonnull
    private final Attributes styleAttributes = new Attributes();
    @Nonnull
    private final ControlAttributes attributes = new ControlAttributes();
    @Nonnull
    private final Collection<EffectBuilder> onStartScreen = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onEndScreen = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<HoverEffectBuilder> onHover = new ArrayList<HoverEffectBuilder>();
    @Nonnull
    private final Collection<HoverEffectBuilder> onStartHover = new ArrayList<HoverEffectBuilder>();
    @Nonnull
    private final Collection<HoverEffectBuilder> onEndHover = new ArrayList<HoverEffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onClick = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onFocus = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onLostFocus = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onGetFocus = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onActive = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onCustom = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onShow = new ArrayList<EffectBuilder>();
    @Nonnull
    private final Collection<EffectBuilder> onHide = new ArrayList<EffectBuilder>();

    public StyleBuilder id(@Nonnull String id) {
        this.styleAttributes.set("id", id);
        return this;
    }

    public StyleBuilder base(@Nonnull String baseStyle) {
        this.styleAttributes.set("base", baseStyle);
        return this;
    }

    public StyleBuilder name(@Nonnull String name) {
        this.attributes.setName(name);
        return this;
    }

    public StyleBuilder backgroundColor(@Nonnull String backgroundColor) {
        this.attributes.setBackgroundColor(backgroundColor);
        return this;
    }

    public StyleBuilder backgroundColor(@Nonnull Color backgroundColor) {
        this.attributes.setBackgroundColor(backgroundColor.getColorString());
        return this;
    }

    public StyleBuilder color(@Nonnull String color) {
        this.attributes.setColor(color);
        return this;
    }

    public StyleBuilder color(@Nonnull Color color) {
        this.attributes.setColor(color.getColorString());
        return this;
    }

    public StyleBuilder selectionColor(@Nonnull String color) {
        this.attributes.setSelectionColor(color);
        return this;
    }

    public StyleBuilder selectionColor(@Nonnull Color color) {
        this.attributes.setSelectionColor(color.getColorString());
        return this;
    }

    public StyleBuilder text(@Nonnull String text) {
        this.attributes.setText(text);
        return this;
    }

    public StyleBuilder backgroundImage(@Nonnull String backgroundImage) {
        this.attributes.setBackgroundImage(backgroundImage);
        return this;
    }

    public StyleBuilder imageMode(@Nonnull String imageMode) {
        this.attributes.setImageMode(imageMode);
        return this;
    }

    public StyleBuilder inset(@Nonnull String inset) {
        this.attributes.setInset(inset);
        return this;
    }

    public StyleBuilder inputMapping(@Nonnull String inputMapping) {
        this.attributes.setInputMapping(inputMapping);
        return this;
    }

    public StyleBuilder style(@Nonnull String style) {
        this.attributes.setStyle(style);
        return this;
    }

    public StyleBuilder childLayout(@Nonnull ChildLayoutType childLayout) {
        this.attributes.setChildLayout(childLayout.getLayout());
        return this;
    }

    public StyleBuilder childLayoutVertical() {
        return this.childLayout(ChildLayoutType.Vertical);
    }

    public StyleBuilder childLayoutHorizontal() {
        return this.childLayout(ChildLayoutType.Horizontal);
    }

    public StyleBuilder childLayoutCenter() {
        return this.childLayout(ChildLayoutType.Center);
    }

    public StyleBuilder childLayoutAbsolute() {
        return this.childLayout(ChildLayoutType.Absolute);
    }

    public StyleBuilder childLayoutOverlay() {
        return this.childLayout(ChildLayoutType.Overlay);
    }

    public StyleBuilder height(@Nonnull String height) {
        this.attributes.setHeight(height);
        return this;
    }

    public StyleBuilder width(@Nonnull String width) {
        this.attributes.setWidth(width);
        return this;
    }

    public StyleBuilder x(@Nonnull String x) {
        this.attributes.setX(x);
        return this;
    }

    public StyleBuilder y(@Nonnull String y) {
        this.attributes.setY(y);
        return this;
    }

    public StyleBuilder childClip(boolean childClip) {
        this.attributes.setChildClip(String.valueOf(childClip));
        return this;
    }

    public StyleBuilder renderOrder(int renderOrder) {
        this.attributes.setRenderOrder(renderOrder);
        return this;
    }

    public StyleBuilder visible(boolean visible) {
        this.attributes.setVisible(String.valueOf(visible));
        return this;
    }

    public StyleBuilder focusable(boolean focusable) {
        this.attributes.setFocusable(String.valueOf(focusable));
        return this;
    }

    public StyleBuilder textHAlign(@Nonnull Align align) {
        this.attributes.set("textHAlign", align.getLayout());
        return this;
    }

    public StyleBuilder textHAlignLeft() {
        return this.textHAlign(Align.Left);
    }

    public StyleBuilder textHAlignRight() {
        return this.textHAlign(Align.Right);
    }

    public StyleBuilder textHAlignCenter() {
        return this.textHAlign(Align.Center);
    }

    public StyleBuilder textVAlign(@Nonnull VAlign valign) {
        this.attributes.set("textVAlign", valign.getLayout());
        return this;
    }

    public StyleBuilder textVAlignTop() {
        return this.textVAlign(VAlign.Top);
    }

    public StyleBuilder textVAlignBottom() {
        return this.textVAlign(VAlign.Bottom);
    }

    public StyleBuilder textVAlignCenter() {
        return this.textVAlign(VAlign.Center);
    }

    public StyleBuilder align(@Nonnull Align align) {
        this.attributes.setAlign(align.getLayout());
        return this;
    }

    public StyleBuilder alignLeft() {
        return this.align(Align.Left);
    }

    public StyleBuilder alignRight() {
        return this.align(Align.Right);
    }

    public StyleBuilder alignCenter() {
        return this.align(Align.Center);
    }

    public StyleBuilder valign(@Nonnull VAlign valign) {
        this.attributes.setVAlign(valign.getLayout());
        return this;
    }

    public StyleBuilder valignTop() {
        return this.valign(VAlign.Top);
    }

    public StyleBuilder valignBottom() {
        return this.valign(VAlign.Bottom);
    }

    public StyleBuilder valignCenter() {
        return this.valign(VAlign.Center);
    }

    public StyleBuilder visibleToMouse(boolean visibleToMouse) {
        this.attributes.setVisibleToMouse(String.valueOf(visibleToMouse));
        return this;
    }

    public StyleBuilder visibleToMouse() {
        return this.visibleToMouse(true);
    }

    public StyleBuilder invisibleToMouse() {
        return this.visibleToMouse(false);
    }

    public StyleBuilder font(@Nonnull String font) {
        this.attributes.setFont(font);
        return this;
    }

    public StyleBuilder filename(@Nonnull String filename) {
        this.attributes.setFilename(filename);
        return this;
    }

    public StyleBuilder padding(@Nonnull String padding) {
        this.attributes.setPadding(padding);
        return this;
    }

    public StyleBuilder paddingLeft(@Nonnull String padding) {
        this.attributes.setPaddingLeft(padding);
        return this;
    }

    public StyleBuilder paddingRight(@Nonnull String padding) {
        this.attributes.setPaddingRight(padding);
        return this;
    }

    public StyleBuilder paddingTop(@Nonnull String padding) {
        this.attributes.setPaddingTop(padding);
        return this;
    }

    public StyleBuilder paddingBottom(@Nonnull String padding) {
        this.attributes.setPaddingBottom(padding);
        return this;
    }

    public StyleBuilder margin(@Nonnull String margin) {
        this.attributes.setMargin(margin);
        return this;
    }

    public StyleBuilder marginLeft(@Nonnull String margin) {
        this.attributes.setMarginLeft(margin);
        return this;
    }

    public StyleBuilder marginRight(@Nonnull String margin) {
        this.attributes.setMarginRight(margin);
        return this;
    }

    public StyleBuilder marginTop(@Nonnull String margin) {
        this.attributes.setMarginTop(margin);
        return this;
    }

    public StyleBuilder marginBottom(@Nonnull String margin) {
        this.attributes.setMarginBottom(margin);
        return this;
    }

    public StyleBuilder set(@Nonnull String key, @Nonnull String value) {
        this.attributes.set(key, value);
        return this;
    }

    public StyleBuilder onStartScreenEffect(EffectBuilder onStartScreenEffect) {
        this.onStartScreen.add(onStartScreenEffect);
        return this;
    }

    public StyleBuilder onEndScreenEffect(EffectBuilder onEndScreenEffect) {
        this.onEndScreen.add(onEndScreenEffect);
        return this;
    }

    public StyleBuilder onHoverEffect(HoverEffectBuilder onHoverEffect) {
        this.onHover.add(onHoverEffect);
        return this;
    }

    public StyleBuilder onStartHoverEffect(HoverEffectBuilder onStartHoverEffect) {
        this.onStartHover.add(onStartHoverEffect);
        return this;
    }

    public StyleBuilder onEndHoverEffect(HoverEffectBuilder onEndHoverEffect) {
        this.onEndHover.add(onEndHoverEffect);
        return this;
    }

    public StyleBuilder onClickEffect(EffectBuilder onClickEffect) {
        this.onClick.add(onClickEffect);
        return this;
    }

    public StyleBuilder onFocusEffect(EffectBuilder onFocusEffect) {
        this.onFocus.add(onFocusEffect);
        return this;
    }

    public StyleBuilder onLostFocusEffect(EffectBuilder onLostFocusEffect) {
        this.onLostFocus.add(onLostFocusEffect);
        return this;
    }

    public StyleBuilder onGetFocusEffect(EffectBuilder onGetFocusEffect) {
        this.onGetFocus.add(onGetFocusEffect);
        return this;
    }

    public StyleBuilder onActiveEffect(EffectBuilder onActiveEffect) {
        this.onActive.add(onActiveEffect);
        return this;
    }

    public StyleBuilder onShowEffect(EffectBuilder onShowEffect) {
        this.onShow.add(onShowEffect);
        return this;
    }

    public StyleBuilder onHideEffect(EffectBuilder onHideEffect) {
        this.onHide.add(onHideEffect);
        return this;
    }

    public StyleBuilder onCustomEffect(EffectBuilder onCustomEffect) {
        this.onCustom.add(onCustomEffect);
        return this;
    }

    public StyleBuilder interactOnClick(@Nonnull String method) {
        this.attributes.setInteractOnClick(method);
        return this;
    }

    public StyleBuilder interactOnMultiClick(@Nonnull String method) {
        this.attributes.setIneractOnMultiClick(method);
        return this;
    }

    public StyleBuilder interactOnRelease(@Nonnull String onRelease) {
        this.attributes.setInteractOnRelease(onRelease);
        return this;
    }

    public StyleBuilder interactOnMouseOver(@Nonnull String onMouseOver) {
        this.attributes.setInteractOnMouseOver(onMouseOver);
        return this;
    }

    public StyleBuilder interactOnClickRepeat(@Nonnull String onClickRepeat) {
        this.attributes.setInteractOnClickRepeat(onClickRepeat);
        return this;
    }

    public StyleBuilder interactOnClickMouseMove(@Nonnull String onClickMouseMove) {
        this.attributes.setInteractOnClickMouseMove(onClickMouseMove);
        return this;
    }

    public StyleBuilder interactOnClickAlternateKey(@Nonnull String onClickAlternateKey) {
        this.attributes.setInteractOnClickAlternateKey(onClickAlternateKey);
        return this;
    }

    @Nonnull
    public String percentage(int percentage) {
        return Integer.toString(percentage) + "%";
    }

    @Nonnull
    public String pixels(int px) {
        return Integer.toString(px) + "px";
    }

    private void connectAttributes() {
        this.attributes.setEffects(this.createEffects());
        for (EffectBuilder effectBuilder : this.onStartScreen) {
            this.attributes.addEffectsOnStartScreen(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onEndScreen) {
            this.attributes.addEffectsOnEndScreen(effectBuilder.getAttributes());
        }
        for (HoverEffectBuilder hoverEffectBuilder : this.onHover) {
            this.attributes.addEffectsOnHover(hoverEffectBuilder.getAttributes());
        }
        for (HoverEffectBuilder hoverEffectBuilder : this.onStartHover) {
            this.attributes.addEffectsOnStartHover(hoverEffectBuilder.getAttributes());
        }
        for (HoverEffectBuilder hoverEffectBuilder : this.onEndHover) {
            this.attributes.addEffectsOnEndHover(hoverEffectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onClick) {
            this.attributes.addEffectsOnClick(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onFocus) {
            this.attributes.addEffectsOnFocus(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onLostFocus) {
            this.attributes.addEffectsOnLostFocus(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onGetFocus) {
            this.attributes.addEffectsOnGetFocus(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onActive) {
            this.attributes.addEffectsOnActive(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onCustom) {
            this.attributes.addEffectsOnCustom(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onShow) {
            this.attributes.addEffectsOnShow(effectBuilder.getAttributes());
        }
        for (EffectBuilder effectBuilder : this.onHide) {
            this.attributes.addEffectsOnHide(effectBuilder.getAttributes());
        }
    }

    @Nonnull
    private ControlEffectsAttributes createEffects() {
        return new ControlEffectsAttributes();
    }

    public void build(@Nonnull Nifty nifty) {
        this.connectAttributes();
        StyleType style = this.attributes.createStyleType(this.styleAttributes);
        nifty.registerStyle(style);
    }

    public static enum VAlign {
        Top("top"),
        Bottom("bottom"),
        Center("center");

        private final String valign;

        private VAlign(String valign) {
            this.valign = valign;
        }

        public String getLayout() {
            return this.valign;
        }
    }

    public static enum Align {
        Left("left"),
        Right("right"),
        Center("center");

        private final String align;

        private Align(String align) {
            this.align = align;
        }

        public String getLayout() {
            return this.align;
        }
    }

    public static enum ChildLayoutType {
        Vertical("vertical"),
        Horizontal("horizontal"),
        Center("center"),
        Absolute("absolute"),
        AbsoluteInside("absolute-inside"),
        Overlay("overlay");

        private final String layout;

        private ChildLayoutType(String layout) {
            this.layout = layout;
        }

        public String getLayout() {
            return this.layout;
        }
    }
}

