/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.HoverEffectBuilder;
import de.lessvoid.nifty.builder.ImageBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.builder.TextBuilder;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectsAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlInteractAttributes;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.EnumStorage;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.nifty.tools.factories.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ElementBuilder {
    @Nonnull
    private final ControlAttributes attributes;
    @Nonnull
    private final ControlInteractAttributes interactAttributes;
    @Nonnull
    protected final List<ElementBuilder> elementBuilders = new ArrayList<ElementBuilder>();
    @Nonnull
    private final EnumStorage<EffectEventId, Collection<EffectBuilder>> effectBuilders;
    @Nullable
    private Controller controller;

    protected ElementBuilder(@Nonnull ControlAttributes attributes) {
        this.interactAttributes = new ControlInteractAttributes();
        this.effectBuilders = new EnumStorage(EffectEventId.class, CollectionFactory.getArrayListInstance());
        this.attributes = attributes;
        attributes.setInteract(this.interactAttributes);
    }

    public void id(@Nonnull String id) {
        this.attributes.setId(id);
    }

    @Nullable
    public String getId() {
        return this.attributes.getId();
    }

    public boolean isAutoId() {
        return this.attributes.isAutoId();
    }

    public ElementBuilder name(@Nonnull String name) {
        this.attributes.setName(name);
        return this;
    }

    public ElementBuilder backgroundColor(@Nonnull String backgroundColor) {
        this.attributes.setBackgroundColor(backgroundColor);
        return this;
    }

    public ElementBuilder backgroundColor(@Nonnull Color backgroundColor) {
        this.attributes.setBackgroundColor(backgroundColor.getColorString());
        return this;
    }

    public ElementBuilder controller(@Nonnull Controller controller) {
        this.attributes.set("controller", controller.getClass().getName());
        this.controller = controller;
        return this;
    }

    public ElementBuilder controller(@Nonnull String controllerClass) {
        this.attributes.set("controller", controllerClass);
        return this;
    }

    public ElementBuilder color(@Nonnull String color) {
        this.attributes.setColor(color);
        return this;
    }

    public ElementBuilder color(@Nonnull Color color) {
        this.attributes.setColor(color.getColorString());
        return this;
    }

    public ElementBuilder selectionColor(@Nonnull String color) {
        this.attributes.setSelectionColor(color);
        return this;
    }

    public ElementBuilder selectionColor(@Nonnull Color color) {
        this.attributes.setSelectionColor(color.getColorString());
        return this;
    }

    public ElementBuilder text(@Nonnull String text) {
        this.attributes.setText(text);
        return this;
    }

    public ElementBuilder backgroundImage(@Nonnull String backgroundImage) {
        this.attributes.setBackgroundImage(backgroundImage);
        return this;
    }

    public ElementBuilder imageMode(@Nonnull String imageMode) {
        this.attributes.setImageMode(imageMode);
        return this;
    }

    public ElementBuilder inset(@Nonnull String inset) {
        this.attributes.setInset(inset);
        return this;
    }

    public ElementBuilder inputMapping(@Nonnull String inputMapping) {
        this.attributes.setInputMapping(inputMapping);
        return this;
    }

    public ElementBuilder style(@Nonnull String style) {
        this.attributes.setStyle(style);
        return this;
    }

    public ElementBuilder childLayout(@Nonnull ChildLayoutType childLayout) {
        this.attributes.setChildLayout(childLayout.getLayout());
        return this;
    }

    public ElementBuilder childLayoutVertical() {
        return this.childLayout(ChildLayoutType.Vertical);
    }

    public ElementBuilder childLayoutHorizontal() {
        return this.childLayout(ChildLayoutType.Horizontal);
    }

    public ElementBuilder childLayoutCenter() {
        return this.childLayout(ChildLayoutType.Center);
    }

    public ElementBuilder childLayoutAbsolute() {
        return this.childLayout(ChildLayoutType.Absolute);
    }

    public ElementBuilder childLayoutAbsoluteInside() {
        return this.childLayout(ChildLayoutType.AbsoluteInside);
    }

    public ElementBuilder childLayoutOverlay() {
        return this.childLayout(ChildLayoutType.Overlay);
    }

    public ElementBuilder height(@Nonnull String height) {
        this.attributes.setHeight(height);
        return this;
    }

    public ElementBuilder width(@Nonnull String width) {
        this.attributes.setWidth(width);
        return this;
    }

    public ElementBuilder height(@Nonnull SizeValue height) {
        this.attributes.setHeight(height.getValueAsString());
        return this;
    }

    public ElementBuilder width(@Nonnull SizeValue width) {
        this.attributes.setWidth(width.getValueAsString());
        return this;
    }

    public ElementBuilder x(@Nonnull String x) {
        this.attributes.setX(x);
        return this;
    }

    public ElementBuilder y(@Nonnull String y) {
        this.attributes.setY(y);
        return this;
    }

    public ElementBuilder x(@Nonnull SizeValue x) {
        this.attributes.setX(x.getValueAsString());
        return this;
    }

    public ElementBuilder y(@Nonnull SizeValue y) {
        this.attributes.setY(y.getValueAsString());
        return this;
    }

    public ElementBuilder childClip(boolean childClip) {
        this.attributes.setChildClip(String.valueOf(childClip));
        return this;
    }

    public ElementBuilder renderOrder(int renderOrder) {
        this.attributes.setRenderOrder(renderOrder);
        return this;
    }

    public ElementBuilder visible(boolean visible) {
        this.attributes.setVisible(String.valueOf(visible));
        return this;
    }

    public ElementBuilder focusable(boolean focusable) {
        this.attributes.setFocusable(String.valueOf(focusable));
        return this;
    }

    public ElementBuilder focusableInsertBeforeElementId(@Nonnull String focusableInsertBeforeElementId) {
        this.attributes.setFocusableInsertBeforeElementId(focusableInsertBeforeElementId);
        return this;
    }

    public ElementBuilder textHAlign(@Nonnull Align align) {
        this.attributes.set("textHAlign", align.getLayout());
        return this;
    }

    public ElementBuilder textHAlignLeft() {
        return this.textHAlign(Align.Left);
    }

    public ElementBuilder textHAlignRight() {
        return this.textHAlign(Align.Right);
    }

    public ElementBuilder textHAlignCenter() {
        return this.textHAlign(Align.Center);
    }

    public ElementBuilder textVAlign(@Nonnull VAlign valign) {
        this.attributes.set("textVAlign", valign.getLayout());
        return this;
    }

    public ElementBuilder textVAlignTop() {
        return this.textVAlign(VAlign.Top);
    }

    public ElementBuilder textVAlignBottom() {
        return this.textVAlign(VAlign.Bottom);
    }

    public ElementBuilder textVAlignCenter() {
        return this.textVAlign(VAlign.Center);
    }

    public ElementBuilder align(@Nonnull Align align) {
        this.attributes.setAlign(align.getLayout());
        return this;
    }

    public ElementBuilder alignLeft() {
        return this.align(Align.Left);
    }

    public ElementBuilder alignRight() {
        return this.align(Align.Right);
    }

    public ElementBuilder alignCenter() {
        return this.align(Align.Center);
    }

    public ElementBuilder valign(@Nonnull VAlign valign) {
        this.attributes.setVAlign(valign.getLayout());
        return this;
    }

    public ElementBuilder valignTop() {
        return this.valign(VAlign.Top);
    }

    public ElementBuilder valignBottom() {
        return this.valign(VAlign.Bottom);
    }

    public ElementBuilder valignCenter() {
        return this.valign(VAlign.Center);
    }

    public ElementBuilder visibleToMouse(boolean visibleToMouse) {
        this.attributes.setVisibleToMouse(String.valueOf(visibleToMouse));
        return this;
    }

    public ElementBuilder visibleToMouse() {
        return this.visibleToMouse(true);
    }

    public ElementBuilder invisibleToMouse() {
        return this.visibleToMouse(false);
    }

    public ElementBuilder font(@Nonnull String font) {
        this.attributes.setFont(font);
        return this;
    }

    public ElementBuilder filename(@Nonnull String filename) {
        this.attributes.setFilename(filename);
        return this;
    }

    public ElementBuilder padding(@Nonnull String padding) {
        this.attributes.setPadding(padding);
        return this;
    }

    public ElementBuilder paddingLeft(@Nonnull String padding) {
        this.attributes.setPaddingLeft(padding);
        return this;
    }

    public ElementBuilder paddingRight(@Nonnull String padding) {
        this.attributes.setPaddingRight(padding);
        return this;
    }

    public ElementBuilder paddingTop(@Nonnull String padding) {
        this.attributes.setPaddingTop(padding);
        return this;
    }

    public ElementBuilder paddingBottom(@Nonnull String padding) {
        this.attributes.setPaddingBottom(padding);
        return this;
    }

    public ElementBuilder margin(@Nonnull String margin) {
        this.attributes.setMargin(margin);
        return this;
    }

    public ElementBuilder marginLeft(@Nonnull String margin) {
        this.attributes.setMarginLeft(margin);
        return this;
    }

    public ElementBuilder marginRight(@Nonnull String margin) {
        this.attributes.setMarginRight(margin);
        return this;
    }

    public ElementBuilder marginTop(@Nonnull String margin) {
        this.attributes.setMarginTop(margin);
        return this;
    }

    public ElementBuilder marginBottom(@Nonnull String margin) {
        this.attributes.setMarginBottom(margin);
        return this;
    }

    public ElementBuilder set(@Nonnull String key, @Nonnull String value) {
        this.attributes.set(key, value);
        return this;
    }

    @Nullable
    public String get(@Nonnull String key) {
        return this.attributes.get(key);
    }

    public ElementBuilder panel(@Nonnull PanelBuilder panelBuilder) {
        this.elementBuilders.add(panelBuilder);
        return this;
    }

    public ElementBuilder text(@Nonnull TextBuilder textBuilder) {
        this.elementBuilders.add(textBuilder);
        return this;
    }

    public ElementBuilder image(@Nonnull ImageBuilder imageBuilder) {
        this.elementBuilders.add(imageBuilder);
        return this;
    }

    public ElementBuilder control(@Nonnull ControlBuilder controlBuilder) {
        this.elementBuilders.add(controlBuilder);
        return this;
    }

    public ElementBuilder onEffect(@Nonnull EffectEventId eventId, @Nonnull EffectBuilder builder) {
        this.effectBuilders.get(eventId).add(builder);
        return this;
    }

    public ElementBuilder onStartScreenEffect(@Nonnull EffectBuilder onStartScreenEffect) {
        return this.onEffect(EffectEventId.onStartScreen, onStartScreenEffect);
    }

    public ElementBuilder onEndScreenEffect(@Nonnull EffectBuilder onEndScreenEffect) {
        return this.onEffect(EffectEventId.onEndScreen, onEndScreenEffect);
    }

    public ElementBuilder onHoverEffect(@Nonnull HoverEffectBuilder onHoverEffect) {
        return this.onEffect(EffectEventId.onHover, onHoverEffect);
    }

    public ElementBuilder onStartHoverEffect(@Nonnull HoverEffectBuilder onStartHoverEffect) {
        return this.onEffect(EffectEventId.onStartHover, onStartHoverEffect);
    }

    public ElementBuilder onEndHoverEffect(@Nonnull HoverEffectBuilder onEndHoverEffect) {
        return this.onEffect(EffectEventId.onEndHover, onEndHoverEffect);
    }

    public ElementBuilder onClickEffect(@Nonnull EffectBuilder onClickEffect) {
        return this.onEffect(EffectEventId.onClick, onClickEffect);
    }

    public ElementBuilder onFocusEffect(@Nonnull EffectBuilder onFocusEffect) {
        return this.onEffect(EffectEventId.onFocus, onFocusEffect);
    }

    public ElementBuilder onLostFocusEffect(@Nonnull EffectBuilder onLostFocusEffect) {
        return this.onEffect(EffectEventId.onLostFocus, onLostFocusEffect);
    }

    public ElementBuilder onGetFocusEffect(@Nonnull EffectBuilder onGetFocusEffect) {
        return this.onEffect(EffectEventId.onGetFocus, onGetFocusEffect);
    }

    public ElementBuilder onActiveEffect(@Nonnull EffectBuilder onActiveEffect) {
        return this.onEffect(EffectEventId.onActive, onActiveEffect);
    }

    public ElementBuilder onShowEffect(@Nonnull EffectBuilder onShowEffect) {
        return this.onEffect(EffectEventId.onShow, onShowEffect);
    }

    public ElementBuilder onHideEffect(@Nonnull EffectBuilder onHideEffect) {
        return this.onEffect(EffectEventId.onHide, onHideEffect);
    }

    public ElementBuilder onCustomEffect(@Nonnull EffectBuilder onCustomEffect) {
        return this.onEffect(EffectEventId.onCustom, onCustomEffect);
    }

    public ElementBuilder interactOnClick(@Nonnull String onClick) {
        this.interactAttributes.setOnClick(onClick);
        return this;
    }

    public ElementBuilder interactOnClickRepeat(@Nonnull String onClickRepeat) {
        this.interactAttributes.setOnClickRepeat(onClickRepeat);
        return this;
    }

    public ElementBuilder interactOnRelease(@Nonnull String onRelease) {
        this.interactAttributes.setOnRelease(onRelease);
        return this;
    }

    public ElementBuilder interactOnClickMouseMove(@Nonnull String onClickMouseMove) {
        this.interactAttributes.setOnClickMouseMove(onClickMouseMove);
        return this;
    }

    public ElementBuilder interactOnMultiClick(@Nonnull String onMultiClick) {
        this.interactAttributes.setOnMultiClick(onMultiClick);
        return this;
    }

    public ElementBuilder interactOnPrimaryClick(@Nonnull String onPrimaryClick) {
        this.interactAttributes.setOnPrimaryClick(onPrimaryClick);
        return this;
    }

    public ElementBuilder interactOnPrimaryClickRepeat(@Nonnull String onPrimaryClickRepeat) {
        this.interactAttributes.setOnPrimaryClickRepeat(onPrimaryClickRepeat);
        return this;
    }

    public ElementBuilder interactOnPrimaryRelease(@Nonnull String onPrimaryRelease) {
        this.interactAttributes.setOnPrimaryRelease(onPrimaryRelease);
        return this;
    }

    public ElementBuilder interactOnPrimaryClickMouseMove(@Nonnull String onPrimaryClickMouseMove) {
        this.interactAttributes.setOnPrimaryClickMouseMove(onPrimaryClickMouseMove);
        return this;
    }

    public ElementBuilder interactOnPrimaryMultiClick(@Nonnull String onPrimaryMultiClick) {
        this.interactAttributes.setOnPrimaryMultiClick(onPrimaryMultiClick);
        return this;
    }

    public ElementBuilder interactOnSecondaryClick(@Nonnull String onSecondaryClick) {
        this.interactAttributes.setOnSecondaryClick(onSecondaryClick);
        return this;
    }

    public ElementBuilder interactOnSecondaryClickRepeat(@Nonnull String onSecondaryClickRepeat) {
        this.interactAttributes.setOnSecondaryClickRepeat(onSecondaryClickRepeat);
        return this;
    }

    public ElementBuilder interactOnSecondaryRelease(@Nonnull String onSecondaryRelease) {
        this.interactAttributes.setOnSecondaryRelease(onSecondaryRelease);
        return this;
    }

    public ElementBuilder interactOnSecondaryClickMouseMove(@Nonnull String onSecondaryClickMouseMove) {
        this.interactAttributes.setOnSecondaryClickMouseMove(onSecondaryClickMouseMove);
        return this;
    }

    public ElementBuilder interactOnSecondaryMultiClick(@Nonnull String onSecondaryMultiClick) {
        this.interactAttributes.setOnSecondaryMultiClick(onSecondaryMultiClick);
        return this;
    }

    public ElementBuilder interactOnTertiaryClick(@Nonnull String onTertiaryClick) {
        this.interactAttributes.setOnTertiaryClick(onTertiaryClick);
        return this;
    }

    public ElementBuilder interactOnTertiaryClickRepeat(@Nonnull String onTertiaryClickRepeat) {
        this.interactAttributes.setOnTertiaryClickRepeat(onTertiaryClickRepeat);
        return this;
    }

    public ElementBuilder interactOnTertiaryRelease(@Nonnull String onTertiaryRelease) {
        this.interactAttributes.setOnTertiaryRelease(onTertiaryRelease);
        return this;
    }

    public ElementBuilder interactOnTertiaryClickMouseMove(@Nonnull String onTertiaryClickMouseMove) {
        this.interactAttributes.setOnTertiaryClickMouseMove(onTertiaryClickMouseMove);
        return this;
    }

    public ElementBuilder interactOnTertiaryMultiClick(@Nonnull String onTertiaryMultiClick) {
        this.interactAttributes.setOnTertiaryMultiClick(onTertiaryMultiClick);
        return this;
    }

    public ElementBuilder interactOnMouseOver(@Nonnull String onMouseOver) {
        this.interactAttributes.setOnMouseOver(onMouseOver);
        return this;
    }

    public ElementBuilder interactOnMouseWheel(@Nonnull String onMouseWheel) {
        this.interactAttributes.setOnMouseWheel(onMouseWheel);
        return this;
    }

    public ElementBuilder interactOnClickAlternateKey(@Nonnull String onClickAlternateKey) {
        this.interactAttributes.setOnClickAlternateKey(onClickAlternateKey);
        return this;
    }

    public List<ElementBuilder> getElementBuilders() {
        return Collections.unmodifiableList(this.elementBuilders);
    }

    public Element build(@Nonnull Element parent) {
        ElementType type = this.buildElementType();
        Element result = parent.getNifty().createElementFromType(parent.getScreen(), parent, type);
        parent.layoutElements();
        return result;
    }

    @Nonnull
    public Element build(@Nonnull Element parent, int index) {
        Screen screen = parent.getScreen();
        ElementType type = this.buildElementType();
        Element result = parent.getNifty().createElementFromType(screen, parent, type, index);
        screen.layoutLayers();
        return result;
    }

    @Nonnull
    public Element build(@Nonnull Element parent, @Nullable Element before) {
        List<Element> parentList = parent.getChildren();
        int index = parentList.size();
        for (int i = 0; i < parentList.size(); ++i) {
            if (!parentList.get(i).equals(before)) continue;
            index = i;
            break;
        }
        return this.build(parent, index);
    }

    @Deprecated
    public Element build(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent) {
        return this.build(parent);
    }

    @Deprecated
    @Nonnull
    public Element build(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent, int index) {
        return this.build(parent, index);
    }

    @Deprecated
    @Nonnull
    public Element build(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element parent, @Nullable Element before) {
        return this.build(parent, before);
    }

    @Nullable
    public ElementType buildElementType() {
        this.connectAttributes();
        ElementType thisType = this.attributes.createType();
        if (thisType == null) {
            return null;
        }
        if (this.attributes.isAutoId()) {
            thisType.getAttributes().remove("id");
        }
        this.attributes.connect(thisType);
        thisType.attachController(this.controller);
        for (int i = 0; i < this.elementBuilders.size(); ++i) {
            ElementType newType = this.elementBuilders.get(i).buildElementType();
            if (newType == null) continue;
            thisType.addElementType(newType);
        }
        return thisType;
    }

    private void connectAttributes() {
        this.attributes.setEffects(this.createEffects());
        for (EffectEventId eventId : EffectEventId.values()) {
            if (!this.effectBuilders.isSet(eventId)) continue;
            Collection<EffectBuilder> builders = this.effectBuilders.get(eventId);
            for (EffectBuilder builder : builders) {
                this.attributes.addEffects(eventId, builder.getAttributes());
            }
        }
    }

    @Nonnull
    private ControlEffectsAttributes createEffects() {
        return new ControlEffectsAttributes();
    }

    public static enum VAlign {
        Top("top"),
        Bottom("bottom"),
        Center("center");

        @Nonnull
        private final String valign;

        private VAlign(String valign) {
            this.valign = valign;
        }

        @Nonnull
        public String getLayout() {
            return this.valign;
        }
    }

    public static enum Align {
        Left("left"),
        Right("right"),
        Center("center");

        @Nonnull
        private final String align;

        private Align(String align) {
            this.align = align;
        }

        @Nonnull
        public String getLayout() {
            return this.align;
        }
    }

    public static enum ChildLayoutType {
        Vertical("vertical"),
        Horizontal("horizontal"),
        Center("center"),
        Absolute("absolute"),
        AbsoluteInside("absolute-inside"),
        Overlay("overlay");

        @Nonnull
        private final String layout;

        private ChildLayoutType(String layout) {
            this.layout = layout;
        }

        @Nonnull
        public String getLayout() {
            return this.layout;
        }
    }
}

