/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyDelayedMethodInvoke;
import de.lessvoid.xml.tools.MethodResolver;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NiftyMethodInvoker
implements NiftyDelayedMethodInvoke {
    private static final Logger log = Logger.getLogger(NiftyMethodInvoker.class.getName());
    @Nullable
    private final Object[] target;
    @Nullable
    private final String methodWithName;
    private final Nifty nifty;

    public NiftyMethodInvoker(Nifty nifty) {
        this.nifty = nifty;
        this.methodWithName = null;
        this.target = null;
    }

    public NiftyMethodInvoker(Nifty nifty, @Nullable String methodParam, Object ... targetParam) {
        this.nifty = nifty;
        this.methodWithName = methodParam;
        if (targetParam.length == 0) {
            this.target = null;
        } else {
            this.target = new Object[targetParam.length];
            System.arraycopy(targetParam, 0, this.target, 0, targetParam.length);
            log.fine("target objects for [" + this.methodWithName + "]");
            for (Object o : this.target) {
                log.fine(o.toString());
            }
        }
    }

    public boolean invoke(Object ... invokeParametersParam) {
        if (this.target == null || this.target.length == 0 || this.methodWithName == null) {
            return false;
        }
        this.nifty.delayedMethodInvoke(this, invokeParametersParam);
        return true;
    }

    @Override
    public void performInvoke(Object ... invokeParametersParam) {
        if (this.target == null || this.methodWithName == null) {
            return;
        }
        for (Object object : this.target) {
            if (object != null) {
                Method method = MethodResolver.findMethod(object.getClass(), this.methodWithName);
                if (method != null) {
                    Object methodResult;
                    Object[] invokeParameters = MethodResolver.extractParameters(this.methodWithName);
                    if (invokeParameters.length > 0) {
                        if (this.getMethodParameterCount(method) == invokeParameters.length) {
                            log.fine("invoking method '" + this.methodWithName + "' with (" + this.debugParaString(invokeParameters) + ")");
                            methodResult = this.callMethod(object, method, invokeParameters);
                        } else {
                            log.fine("invoking method '" + this.methodWithName + "' (note: given invokeParameters have been ignored)");
                            methodResult = this.callMethod(object, method, new Object[0]);
                        }
                    } else if (invokeParametersParam.length > 0) {
                        if (this.getMethodParameterCount(method) == invokeParametersParam.length) {
                            log.fine("invoking method '" + this.methodWithName + "' with the actual parameters (" + this.debugParaString(invokeParametersParam) + ")");
                            methodResult = this.callMethod(object, method, invokeParametersParam);
                        } else {
                            log.fine("invoking method '" + this.methodWithName + "' without parameters (invokeParametersParam mismatch)");
                            methodResult = this.callMethod(object, method, new Object[0]);
                        }
                    } else {
                        log.fine("invoking method '" + this.methodWithName + "' without parameters");
                        methodResult = this.callMethod(object, method, new Object[0]);
                    }
                    if (methodResult == null || !methodResult.getClass().equals(Boolean.class) || !((Boolean)methodResult).booleanValue()) continue;
                    log.fine("method invoke for '" + this.methodWithName + "' returns true. by definition this means we're not calling any other targets for this method.");
                    return;
                }
                log.fine("method [" + this.methodWithName + "] not found at object class [" + object.getClass() + "]");
                continue;
            }
            log.warning("target object is null");
        }
    }

    @Nullable
    private Object callMethod(@Nonnull Object targetObject, @Nonnull Method method, Object ... invokeParameters) {
        try {
            log.fine("method: " + method + "on targetObject: " + targetObject + ", parameters: " + Arrays.toString(invokeParameters));
            log.fine(method.getName());
            for (Object o : invokeParameters) {
                log.fine("parameter: " + o);
            }
            return method.invoke(targetObject, invokeParameters);
        }
        catch (RuntimeException e) {
            if (this.nifty.isNiftyMethodInvokerDebugEnabled()) {
                throw e;
            }
            log.log(Level.WARNING, "RuntimeException in callMethod(" + method + ") for [" + targetObject + "]", e);
            return null;
        }
        catch (Exception e) {
            if (this.nifty.isNiftyMethodInvokerDebugEnabled()) {
                throw new RuntimeException(e);
            }
            log.log(Level.WARNING, "Exception in callMethod(" + method + ") for [" + targetObject + "]", e);
            return null;
        }
    }

    private int getMethodParameterCount(@Nonnull Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length;
    }

    @Nonnull
    private String debugParaString(Object ... invokeParameters) {
        StringBuilder paraStringBuffer = new StringBuilder();
        paraStringBuffer.append(invokeParameters[0]);
        for (int i = 1; i < invokeParameters.length; ++i) {
            paraStringBuffer.append(", ");
            paraStringBuffer.append(invokeParameters[i]);
        }
        return paraStringBuffer.toString();
    }
}

