/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.NiftyEventSubscriber;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventTopicSubscriber;

public class NiftyEventAnnotationProcessor {
    private static final Logger log = Logger.getLogger(NiftyEventAnnotationProcessor.class.getName());

    public static void process(Object obj) {
        NiftyEventAnnotationProcessor.processOrUnprocess(obj, true);
    }

    public static void unprocess(Object obj) {
        NiftyEventAnnotationProcessor.processOrUnprocess(obj, false);
    }

    private static void processOrUnprocess(@Nullable Object obj, boolean add) {
        if (obj == null) {
            return;
        }
        Class<?> cl = obj.getClass();
        Object[] methods = cl.getMethods();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking for EventBus annotations for class " + cl + ", methods:" + Arrays.toString(methods));
        }
        for (Object method : methods) {
            NiftyEventSubscriber niftyEventSubscriber = ((Method)method).getAnnotation(NiftyEventSubscriber.class);
            if (niftyEventSubscriber == null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Found NiftyEventSubscriber:" + niftyEventSubscriber + " on method:" + method);
            }
            NiftyEventAnnotationProcessor.process(niftyEventSubscriber, obj, (Method)method, add);
        }
    }

    private static void process(@Nonnull NiftyEventSubscriber annotation, Object obj, @Nonnull Method method, boolean add) {
        String id = annotation.id();
        String pattern = annotation.pattern();
        NiftyEventAnnotationProcessor.ensureNotNull(id, pattern);
        NiftyEventAnnotationProcessor.ensureMethodParamCount(method.getParameterTypes());
        EventService eventService = NiftyEventAnnotationProcessor.getEventService();
        Class<?> eventClass = method.getParameterTypes()[1];
        if (NiftyEventAnnotationProcessor.isSet(id)) {
            NiftyEventAnnotationProcessor.idProcess(obj, method, add, id, eventClass, eventService);
        } else {
            NiftyEventAnnotationProcessor.patternProcess(obj, method, add, pattern, eventClass, eventService);
        }
    }

    private static boolean isSet(@Nullable String value) {
        return value != null && value.length() > 0;
    }

    private static void ensureNotNull(String id, String pattern) {
        if (!NiftyEventAnnotationProcessor.isSet(id) && !NiftyEventAnnotationProcessor.isSet(pattern)) {
            throw new IllegalArgumentException("id or pattern must have a value for NiftyEventSubscriber annotation");
        }
    }

    private static void ensureMethodParamCount(@Nullable Class<?>[] params) {
        if (params == null || params.length != 2 || !String.class.equals(params[0]) || params[1].isPrimitive()) {
            throw new IllegalArgumentException("The subscriptionMethod must have the two parameters, the first one must be a String and the second a non-primitive (Object or derivative).");
        }
    }

    private static void patternProcess(Object obj, Method method, boolean add, @Nonnull String topicPattern, Class<?> eventClass, @Nonnull EventService eventService) {
        Pattern pattern = Pattern.compile(topicPattern);
        Subscriber subscriber = new Subscriber(obj, method, eventClass);
        StringBuilder sb = new StringBuilder(" [{0}] -> [{1}]");
        if (add) {
            sb.insert(0, "-> subscribe");
            if (!eventService.subscribeStrongly(pattern, (EventTopicSubscriber)subscriber)) {
                sb.insert(2, " failed to");
            }
            log.log(Level.FINE, sb.toString(), new Object[]{pattern, subscriber});
        } else {
            sb.insert(0, "<- unsubscribe");
            if (!eventService.unsubscribe(pattern, (EventTopicSubscriber)subscriber)) {
                sb.insert(2, " failed to");
            }
            log.log(Level.FINE, sb.toString(), new Object[]{pattern, subscriber});
        }
    }

    private static void idProcess(Object obj, Method method, boolean add, String id, Class<?> eventClass, @Nonnull EventService eventService) {
        Subscriber subscriber = new Subscriber(obj, method, eventClass);
        StringBuilder sb = new StringBuilder(" [{0}] -> [{1}]");
        if (add) {
            sb.insert(0, "-> subscribe");
            if (!eventService.subscribeStrongly(id, (EventTopicSubscriber)subscriber)) {
                sb.insert(2, " failed to");
            }
            log.log(Level.FINE, sb.toString(), new Object[]{id, subscriber});
        } else {
            sb.insert(0, "<- unsubscribe");
            if (!eventService.unsubscribe(id, (EventTopicSubscriber)subscriber)) {
                sb.insert(2, " failed to");
            }
            log.log(Level.FINE, sb.toString(), new Object[]{id, subscriber});
        }
    }

    private static EventService getEventService() {
        return EventServiceLocator.getEventService("NiftyEventBus");
    }

    private static class Subscriber
    implements EventTopicSubscriber<Object> {
        private final Object obj;
        private final Method method;
        private final Class<?> eventClass;

        private Subscriber(Object obj, Method method, Class<?> eventClass) {
            this.obj = obj;
            this.method = method;
            this.eventClass = eventClass;
        }

        @Override
        public void onEvent(String topic, Object data) {
            if (this.eventClass.isInstance(data)) {
                try {
                    this.method.invoke(this.obj, topic, this.eventClass.cast(data));
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "failed to invoke method [" + this.method + "] with Exception [" + e.getMessage() + "][" + e.getCause() + "]", e);
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.eventClass == null ? 0 : this.eventClass.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subscriber other = (Subscriber)obj;
            if (this.eventClass == null ? other.eventClass != null : !this.eventClass.equals(other.eventClass)) {
                return false;
            }
            if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
                return false;
            }
            return !(this.obj == null ? other.obj != null : !this.obj.equals(other.obj));
        }
    }
}

