/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.test;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.input.mapping.DefaultInputMapping;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChatPanelController
implements Controller,
KeyInputHandler {
    @Nonnull
    private static final Logger log = Logger.getLogger(ChatPanelController.class.getName());
    @Nonnull
    private Nifty nifty;
    @Nonnull
    private Screen screen;
    @Nonnull
    private Element element;
    @Nullable
    private TextField chatsend;
    @Nullable
    public Element chatField;

    public void bind(@Nonnull Nifty niftyParam, @Nonnull Screen screenParam, @Nonnull Element newElement, @Nonnull Parameters properties) {
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.element = newElement;
        this.chatField = this.screen.findElementById("chatfield");
        if (this.chatField == null) {
            log.warning("Failed to locate chat field. Looked for: chatfield");
        } else {
            log.info("Setup chat field: " + this.chatField.getId());
        }
    }

    public void init(@Nonnull Parameters parameter) {
    }

    public void onStartScreen() {
        this.chatsend = (TextField)this.screen.findNiftyControl("chatsend", TextField.class);
        this.screen.addKeyboardInputHandler((NiftyInputMapping)new DefaultInputMapping(), (KeyInputHandler)this);
        if (this.chatsend == null) {
            log.warning("Failed to locate text field containing the text to send. Looked for: chatsend");
        }
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return true;
    }

    public void onEndScreen() {
    }

    public void removePanel() {
        this.nifty.removeElement(this.screen, this.element);
    }

    public boolean keyEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (this.chatsend == null) {
            return false;
        }
        if (inputEvent == NiftyStandardInputEvent.Activate) {
            String message = this.chatsend.getRealText();
            if (message.length() >= 1000) {
                return false;
            }
            this.chatsend.setText((CharSequence)"");
            return true;
        }
        return false;
    }
}

