/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.helloworld;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TextTyping
implements EffectImpl {
    private int effectLength;
    private float startSize;
    private float endSize;
    private float stepTime;
    @Nonnull
    private String originalText = "";
    @Nullable
    private TextRenderer textRenderer;

    public void activate(@Nonnull Nifty nifty, @Nonnull Element element, @Nonnull EffectProperties parameter) {
        this.textRenderer = (TextRenderer)element.getRenderer(TextRenderer.class);
        this.originalText = this.textRenderer == null ? "" : this.textRenderer.getOriginalText();
        this.effectLength = Integer.valueOf(parameter.getProperty("length", "1000"));
        this.startSize = Float.valueOf(parameter.getProperty("startSize", "5.0")).floatValue();
        this.endSize = Float.valueOf(parameter.getProperty("endSize", "1.0")).floatValue();
        this.stepTime = this.effectLength / this.originalText.length();
        this.updateText(null);
    }

    public void execute(@Nonnull Element element, float effectTime, @Nullable Falloff falloff, @Nonnull NiftyRenderEngine r) {
        int currentIndex = (int)((float)this.originalText.length() * effectTime);
        String currentText = this.originalText.substring(0, currentIndex);
        if (currentIndex < this.originalText.length()) {
            String nextChar = this.originalText.substring(currentIndex, currentIndex + 1);
            int textWidth = this.textRenderer.getFont().getWidth(currentText);
            float currentTime = effectTime * (float)this.effectLength;
            float normalizedStepTime = currentTime % this.stepTime / this.stepTime;
            float charSize = this.startSize + normalizedStepTime * (this.endSize - this.startSize);
            r.saveStates();
            r.setFont(this.textRenderer.getFont());
            r.setRenderTextSize(charSize);
            TextRenderer textRenderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (textRenderer != null) {
                String text = textRenderer.getWrappedText();
                RenderFont font = textRenderer.getFont();
                float originalWidth = font.getWidth(text, 1.0f);
                float sizedWidth = font.getWidth(text, charSize);
                float originalHeight = font.getHeight();
                float sizedHeight = (float)font.getHeight() * charSize;
                r.moveTo(-(sizedWidth - originalWidth) / 2.0f, -(sizedHeight - originalHeight) / 2.0f);
            }
            r.renderText(nextChar, element.getX() + textWidth, element.getY(), -1, -1, Color.WHITE);
            r.restoreStates();
        }
        this.updateText(currentText);
    }

    public void deactivate() {
    }

    private void updateText(@Nullable String currentText) {
        if (this.textRenderer != null) {
            this.textRenderer.setText(currentText);
        }
    }
}

