/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.scrollpanel;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.controls.ScrollPanel;
import de.lessvoid.nifty.controls.ScrollPanelChangedEvent;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.TextFieldChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScrollPanelDialogController
implements Controller {
    private Screen screen;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters parameter) {
        this.screen = screen;
    }

    public void init(@Nonnull Parameters parameter) {
        ScrollPanel scrollPanel = this.getScrollPanel();
        scrollPanel.setUp(10.0f, 10.0f, 100.0f, 100.0f, ScrollPanel.AutoScroll.OFF);
        this.getScrollPanelXPosTextField().setText((CharSequence)String.valueOf((int)scrollPanel.getHorizontalPos()));
        this.getScrollPanelYPosTextField().setText((CharSequence)String.valueOf((int)scrollPanel.getVerticalPos()));
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        return false;
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="scrollPanel")
    public void onScrollPanelChange(String id, @Nonnull ScrollPanelChangedEvent event) {
        this.getScrollPanelXPosTextField().setText((CharSequence)String.valueOf((int)event.getX()));
        this.getScrollPanelYPosTextField().setText((CharSequence)String.valueOf((int)event.getY()));
    }

    @NiftyEventSubscriber(id="scrollpanelXPos")
    public void onScrollpanelXPosChanged(String id, @Nonnull TextFieldChangedEvent event) {
        try {
            float f = Float.valueOf(event.getText()).floatValue();
            ScrollPanel scrollPanel = this.getScrollPanel();
            scrollPanel.setHorizontalPos(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @NiftyEventSubscriber(id="scrollpanelYPos")
    public void onScrollpanelYPosChanged(String id, @Nonnull TextFieldChangedEvent event) {
        try {
            float f = Float.valueOf(event.getText()).floatValue();
            ScrollPanel scrollPanel = this.getScrollPanel();
            scrollPanel.setVerticalPos(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Nullable
    private ScrollPanel getScrollPanel() {
        return (ScrollPanel)this.screen.findNiftyControl("scrollPanel", ScrollPanel.class);
    }

    @Nullable
    private TextField getScrollPanelYPosTextField() {
        return (TextField)this.screen.findNiftyControl("scrollpanelYPos", TextField.class);
    }

    @Nullable
    private TextField getScrollPanelXPosTextField() {
        return (TextField)this.screen.findNiftyControl("scrollpanelXPos", TextField.class);
    }
}

