/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.controls.listbox.ListBoxSelectionMode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

class ListBoxSelectionModeMulti<T>
implements ListBoxSelectionMode<T> {
    @Nonnull
    private final List<T> selection = new ArrayList<T>();
    private boolean requiresSelection = false;

    ListBoxSelectionModeMulti() {
    }

    @Override
    public void clear() {
        this.selection.clear();
    }

    @Override
    @Nonnull
    public List<T> getSelection() {
        return new ArrayList<T>(this.selection);
    }

    @Override
    public void remove(@Nonnull T item) {
        if (this.requiresSelection && this.selection.size() < 2) {
            return;
        }
        if (this.isPartOfSelection(item)) {
            this.removeFromSelection(item);
        }
    }

    @Override
    public void removeForced(@Nonnull T item) {
        if (this.isPartOfSelection(item)) {
            this.removeFromSelection(item);
        }
    }

    @Override
    public void add(@Nonnull T item) {
        this.selection.add(item);
    }

    @Override
    public void enableRequiresSelection(boolean enabled) {
        this.requiresSelection = enabled;
    }

    @Override
    public boolean requiresAutoSelection() {
        return this.requiresSelection && this.selection.isEmpty();
    }

    private boolean isPartOfSelection(T item) {
        return this.selection.contains(item);
    }

    private void removeFromSelection(T item) {
        this.selection.remove(item);
    }
}

