/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.imageselect;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.ImageSelect;
import de.lessvoid.nifty.controls.ImageSelectSelectionChangedEvent;
import de.lessvoid.nifty.controls.NextPrevHelper;
import de.lessvoid.nifty.controls.Parameters;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.impl.Move;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
public class ImageSelectControl
extends AbstractController
implements ImageSelect {
    @Nonnull
    private static final Logger log = Logger.getLogger(ImageSelectControl.class.getName());
    @Nullable
    private Nifty nifty;
    @Nonnull
    private final List<NiftyImage> images = new ArrayList<NiftyImage>();
    private int currentImageIndex;
    @Nonnull
    private NextPrevHelper nextPrevHelper;
    @Nullable
    private Element backButtonElement;
    @Nullable
    private Element forwardButtonElement;
    @Nullable
    private Element imageElement;
    @Nullable
    private Element imageElement2;
    @Nullable
    private Element backElement;
    @Nullable
    private Element forwardElement;
    private boolean block = false;

    public void bind(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nonnull Element element, @Nonnull Parameters properties) {
        List moveEffects;
        String parameterImageWidth;
        super.bind(element);
        this.nifty = nifty;
        this.createImages(nifty, screen, properties.get("imageList"));
        this.currentImageIndex = 0;
        this.nextPrevHelper = new NextPrevHelper(element, screen.getFocusHandler());
        this.backButtonElement = element.findElementById("#back-button");
        this.forwardButtonElement = element.findElementById("#forward-button");
        this.imageElement = element.findElementById("#image");
        this.imageElement2 = element.findElementById("#image-2");
        this.backElement = element.findElementById("#back");
        this.forwardElement = element.findElementById("#forward");
        if (this.backButtonElement == null) {
            log.severe("Failed to locate back-button element. Looked for: #back-button");
        }
        if (this.forwardButtonElement == null) {
            log.severe("Failed to locate forward-button element. Looked for: #forward-button");
        }
        if (this.imageElement == null) {
            log.severe("Failed to locate image element. Looked for: #image");
        }
        if (this.imageElement2 == null) {
            log.severe("Failed to locate image element 2. Looked for: #image-2");
        }
        if (this.backElement == null) {
            log.severe("Failed to locate back element. Looked for: #back");
        }
        if (this.forwardElement == null) {
            log.severe("Failed to locate back element. Looked for: #forward");
        }
        int imageWidth = (parameterImageWidth = properties.get("imageWidth")) == null ? 0 : new SizeValue(parameterImageWidth).getValueAsInt(1.0f);
        if (this.imageElement != null) {
            moveEffects = this.imageElement.getEffects(EffectEventId.onCustom, Move.class);
            for (Effect e : moveEffects) {
                if ("back".equals(e.getCustomKey())) {
                    e.getParameters().put((Object)"offsetX", (Object)String.valueOf(-imageWidth - 1));
                    continue;
                }
                if (!"forward".equals(e.getCustomKey())) continue;
                e.getParameters().put((Object)"offsetX", (Object)String.valueOf(imageWidth + 1));
            }
        }
        if (this.imageElement2 != null) {
            moveEffects = this.imageElement2.getEffects(EffectEventId.onCustom, Move.class);
            for (Effect e : moveEffects) {
                if ("back".equals(e.getCustomKey())) {
                    e.getParameters().put((Object)"offsetX", (Object)String.valueOf(imageWidth));
                    continue;
                }
                if (!"forward".equals(e.getCustomKey())) continue;
                e.getParameters().put((Object)"offsetX", (Object)String.valueOf(-imageWidth));
            }
        }
        this.updateVisuals();
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (NiftyStandardInputEvent.MoveCursorLeft == inputEvent) {
            this.backClick();
        } else if (NiftyStandardInputEvent.MoveCursorRight == inputEvent) {
            this.forwardClick();
        } else {
            if (this.nextPrevHelper.handleNextPrev(inputEvent)) {
                return true;
            }
            if (inputEvent == NiftyStandardInputEvent.Activate) {
                Element element = this.getElement();
                if (element != null) {
                    element.onClickAndReleasePrimaryMouseButton();
                }
                return true;
            }
        }
        return false;
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
        if (this.backButtonElement != null && this.forwardButtonElement != null) {
            if (getFocus) {
                this.backButtonElement.startEffect(EffectEventId.onCustom);
                this.forwardButtonElement.startEffect(EffectEventId.onCustom);
            } else {
                this.backButtonElement.stopEffect(EffectEventId.onCustom);
                this.forwardButtonElement.stopEffect(EffectEventId.onCustom);
            }
        }
    }

    @Override
    public void backClick() {
        if (this.block) {
            return;
        }
        if (this.imageElement == null || this.imageElement2 == null) {
            return;
        }
        ImageRenderer imageRenderer = (ImageRenderer)this.imageElement.getRenderer(ImageRenderer.class);
        ImageRenderer imageRenderer2 = (ImageRenderer)this.imageElement2.getRenderer(ImageRenderer.class);
        if (imageRenderer == null || imageRenderer2 == null) {
            return;
        }
        if (this.currentImageIndex > 0) {
            this.block = true;
            imageRenderer2.setImage(imageRenderer.getImage());
            this.imageElement2.setConstraintWidth(SizeValue.px((int)this.imageElement.getWidth()));
            this.imageElement2.setConstraintHeight(SizeValue.px((int)this.imageElement.getHeight()));
            this.imageElement2.layoutElements();
            this.imageElement2.show();
            this.imageElement.hide();
            --this.currentImageIndex;
            this.imageIndexChanged();
            this.updateVisuals();
            this.imageElement.stopEffect(EffectEventId.onCustom);
            this.imageElement.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    ImageSelectControl.this.block = false;
                }
            }, "back");
            this.imageElement.show();
            this.imageElement2.stopEffect(EffectEventId.onCustom);
            this.imageElement2.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    ImageSelectControl.this.imageElement2.hide();
                }
            }, "back");
        }
    }

    @Override
    public void forwardClick() {
        if (this.block) {
            return;
        }
        if (this.imageElement == null || this.imageElement2 == null) {
            return;
        }
        ImageRenderer imageRenderer = (ImageRenderer)this.imageElement.getRenderer(ImageRenderer.class);
        ImageRenderer imageRenderer2 = (ImageRenderer)this.imageElement2.getRenderer(ImageRenderer.class);
        if (imageRenderer == null || imageRenderer2 == null) {
            return;
        }
        if (this.currentImageIndex < this.images.size() - 1) {
            this.block = true;
            imageRenderer2.setImage(imageRenderer.getImage());
            this.imageElement2.setConstraintWidth(SizeValue.px((int)this.imageElement.getWidth()));
            this.imageElement2.setConstraintHeight(SizeValue.px((int)this.imageElement.getHeight()));
            this.imageElement2.layoutElements();
            this.imageElement2.show();
            this.imageElement.hide();
            ++this.currentImageIndex;
            this.imageIndexChanged();
            this.updateVisuals();
            this.imageElement.stopEffect(EffectEventId.onCustom);
            this.imageElement.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    ImageSelectControl.this.block = false;
                }
            }, "forward");
            this.imageElement.show();
            this.imageElement2.stopEffect(EffectEventId.onCustom);
            this.imageElement2.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    ImageSelectControl.this.imageElement2.hide();
                }
            }, "forward");
        }
    }

    @Override
    public void addImage(@Nonnull NiftyImage image) {
        this.images.add(image);
        this.updateVisuals();
    }

    @Override
    public int getSelectedImageIndex() {
        return this.currentImageIndex;
    }

    @Override
    public void setSelectedImageIndex(int imageIndex) {
        if (imageIndex < 0 || imageIndex > this.images.size()) {
            return;
        }
        this.currentImageIndex = imageIndex;
        this.updateVisuals();
        this.imageIndexChanged();
    }

    @Override
    public void removeImage(@Nonnull NiftyImage image) {
        this.images.remove(image);
        this.updateVisuals();
    }

    @Override
    public int getImageCount() {
        return this.images.size();
    }

    private void updateVisuals() {
        if (this.images.isEmpty()) {
            return;
        }
        if (this.imageElement != null) {
            ImageRenderer imageRenderer = (ImageRenderer)this.imageElement.getRenderer(ImageRenderer.class);
            NiftyImage currentImage = this.images.get(this.currentImageIndex);
            if (imageRenderer != null) {
                imageRenderer.setImage(currentImage);
            }
            this.imageElement.setConstraintWidth(SizeValue.px((int)currentImage.getWidth()));
            this.imageElement.setConstraintHeight(SizeValue.px((int)currentImage.getHeight()));
            this.imageElement.layoutElements();
        }
        if (this.backElement != null && this.backButtonElement != null) {
            if (this.currentImageIndex == 0) {
                this.backElement.hide();
                this.backButtonElement.disable();
            } else {
                this.backElement.show();
                this.backButtonElement.enable();
            }
        }
        if (this.forwardElement != null && this.forwardButtonElement != null) {
            if (this.currentImageIndex == this.images.size() - 1) {
                this.forwardElement.hide();
                this.forwardButtonElement.disable();
            } else {
                this.forwardElement.show();
                this.forwardButtonElement.enable();
            }
        }
    }

    private void createImages(@Nonnull Nifty nifty, @Nonnull Screen screen, @Nullable String param) {
        if (param == null) {
            return;
        }
        String property = nifty.specialValuesReplace(param);
        NiftyRenderEngine renderEngine = nifty.getRenderEngine();
        this.images.clear();
        if (property.length() > 0) {
            String[] imageStrings;
            for (String imageString : imageStrings = property.split(",")) {
                this.images.add(renderEngine.createImage(screen, imageString, false));
            }
        }
    }

    private void imageIndexChanged() {
        String id;
        if (this.nifty != null && (id = this.getId()) != null) {
            this.nifty.publishEvent(id, (NiftyEvent)new ImageSelectSelectionChangedEvent(this, this.currentImageIndex));
        }
    }
}

