/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.chatcontrol;

import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.chatcontrol.ChatEntryModelClass;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ChatBoxViewConverter
implements ListBox.ListBoxViewConverter<ChatEntryModelClass> {
    @Nonnull
    private static final Logger log = Logger.getLogger(ChatBoxViewConverter.class.getName());
    @Nonnull
    private static final String CHAT_LINE_ICON = "#chat-line-icon";
    @Nonnull
    private static final String CHAT_LINE_TEXT = "#chat-line-text";

    @Override
    public final void display(@Nonnull Element listBoxItem, @Nonnull ChatEntryModelClass item) {
        Element text = listBoxItem.findElementById(CHAT_LINE_TEXT);
        if (text == null) {
            log.severe("Failed to locate text part of chat line! Can't display entry.");
            return;
        }
        Element icon = listBoxItem.findElementById(CHAT_LINE_ICON);
        if (icon == null) {
            log.severe("Failed to locate icon part of chat line! Can't display entry.");
            return;
        }
        TextRenderer textRenderer = (TextRenderer)text.getRenderer(TextRenderer.class);
        if (textRenderer == null) {
            log.severe("Text entry of the chat line does not contain the required text renderer.");
            return;
        }
        ImageRenderer iconRenderer = (ImageRenderer)icon.getRenderer(ImageRenderer.class);
        if (iconRenderer == null) {
            log.severe("Icon entry of the chat line does not contain the required image renderer.");
            return;
        }
        if (item.getStyle() != null && !item.getStyle().equals("")) {
            text.setStyle(item.getStyle());
        } else {
            text.setStyle("default");
        }
        textRenderer.setText(item.toString());
        iconRenderer.setImage(item.getIcon());
    }

    @Override
    public final int getWidth(@Nonnull Element listBoxItem, @Nonnull ChatEntryModelClass item) {
        Element text = listBoxItem.findElementById(CHAT_LINE_TEXT);
        if (text == null) {
            log.severe("Failed to locate text part of chat line! Can't display entry.");
            return 0;
        }
        TextRenderer textRenderer = (TextRenderer)text.getRenderer(TextRenderer.class);
        if (textRenderer == null) {
            log.severe("Text entry of the chat line does not contain the required text renderer.");
            return 0;
        }
        return (textRenderer.getFont() == null ? 0 : textRenderer.getFont().getWidth(item.getLabel())) + (item.getIcon() == null ? 0 : item.getIcon().getWidth());
    }
}

