/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleCommandSplitter;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyStandardInputEvent;
import de.lessvoid.nifty.screen.KeyInputHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConsoleCommands
implements KeyInputHandler {
    private boolean commandCompletion = false;
    @Nonnull
    private final ConsoleCommandSplitter splitter = new ConsoleCommandSplitter();
    @Nonnull
    private final Map<String, ConsoleCommand> commands = new TreeMap<String, ConsoleCommand>();
    @Nonnull
    private final List<String> commandHistory = new ArrayList<String>();
    private int commandHistoryLastCommand = -1;
    @Nonnull
    private final Nifty nifty;
    @Nonnull
    private final Console console;
    @Nullable
    private final TextField textfield;

    public ConsoleCommands(@Nonnull Nifty nifty, @Nonnull Console console) {
        Element textFieldElement;
        this.nifty = nifty;
        this.console = console;
        this.textfield = console.getTextField();
        if (this.textfield != null && (textFieldElement = this.textfield.getElement()) != null) {
            textFieldElement.addPreInputHandler((KeyInputHandler)this);
        }
    }

    public void enableCommandCompletion(boolean enabled) {
        this.commandCompletion = enabled;
    }

    public void registerCommand(@Nonnull String commandText, @Nonnull ConsoleCommand command) {
        this.commands.put(commandText, command);
    }

    @Nonnull
    public List<String> getRegisteredCommands() {
        Set<String> var = this.commands.keySet();
        return Collections.unmodifiableList(Arrays.asList(var.toArray(new String[var.size()])));
    }

    public boolean keyEvent(@Nonnull NiftyInputEvent inputEvent) {
        if (!this.commandCompletion || this.textfield == null) {
            return false;
        }
        if (NiftyStandardInputEvent.NextInputElement.equals((Object)inputEvent)) {
            List<String> matches = this.findMatches(this.textfield.getRealText());
            if (matches.size() == 1) {
                this.changeText(matches.get(0));
                return true;
            }
            if (matches.size() > 1) {
                String shortest = this.findShortestMatch(matches);
                if (shortest.length() == this.textfield.getRealText().length()) {
                    StringBuilder buffer = new StringBuilder("\n");
                    for (String match : matches) {
                        buffer.append("\\#cccf#").append(match).append("\n");
                    }
                    this.console.output(buffer.toString());
                }
                this.changeText(shortest);
            }
            return true;
        }
        if (NiftyStandardInputEvent.MoveCursorUp.equals((Object)inputEvent)) {
            if (this.commandHistoryLastCommand > 0) {
                --this.commandHistoryLastCommand;
                this.changeText(this.commandHistory.get(this.commandHistoryLastCommand));
            }
            return true;
        }
        if (NiftyStandardInputEvent.MoveCursorDown.equals((Object)inputEvent)) {
            if (this.commandHistoryLastCommand < this.commandHistory.size() - 1) {
                ++this.commandHistoryLastCommand;
                this.changeText(this.commandHistory.get(this.commandHistoryLastCommand));
            } else {
                this.commandHistoryLastCommand = this.commandHistory.size();
                this.changeText("");
            }
            return true;
        }
        if (NiftyStandardInputEvent.SubmitText.equals((Object)inputEvent)) {
            String text = this.textfield.getRealText();
            this.console.output(text);
            this.textfield.setText("");
            String[] split = this.splitter.split(text);
            if (split.length != 0) {
                String command = split[0];
                for (Map.Entry<String, ConsoleCommand> registeredCommand : this.commands.entrySet()) {
                    String start;
                    String[] s = registeredCommand.getKey().split(" ");
                    if (s.length == 0 || !command.equals(start = s[0])) continue;
                    ConsoleCommand consoleCommand = registeredCommand.getValue();
                    consoleCommand.execute(split);
                    this.addCommandToHistory(text);
                    return true;
                }
            }
            this.console.outputError("Unknown command: " + text);
            String id = this.console.getId();
            if (id != null) {
                this.nifty.publishEvent(id, (NiftyEvent)new ConsoleExecuteCommandEvent(this.console, text));
            }
            this.addCommandToHistory(text);
            return true;
        }
        return false;
    }

    @Nullable
    public ConsoleCommand findCommand(@Nonnull String commandText) {
        ConsoleCommand command = this.commands.get(commandText);
        if (command != null) {
            return command;
        }
        List<String> commandMatches = this.findMatches(commandText);
        if (commandMatches.size() == 1) {
            return this.commands.get(commandMatches.get(0));
        }
        return null;
    }

    private void changeText(@Nonnull String newText) {
        if (this.textfield != null) {
            this.textfield.setText(newText);
            this.textfield.setCursorPosition(this.textfield.getRealText().length());
        }
    }

    private void addCommandToHistory(@Nonnull String text) {
        this.commandHistory.add(text);
        this.commandHistoryLastCommand = this.commandHistory.size();
    }

    @Nonnull
    List<String> findMatches(@Nullable String text) {
        if (text == null || text.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String command : this.commands.keySet()) {
            if (command.equals(text)) {
                result.add(command);
                continue;
            }
            if (!command.startsWith(text)) continue;
            result.add(command);
        }
        return result;
    }

    @Nonnull
    String findShortestMatch(@Nonnull List<String> matches) {
        String longest = "";
        for (String match : matches) {
            if (match.length() <= longest.length()) continue;
            longest = match;
        }
        String lastCheck = longest.substring(0, 1);
        for (int i = 1; i < longest.length(); ++i) {
            String check = longest.substring(0, i);
            for (String match : matches) {
                if (match.startsWith(check)) continue;
                return lastCheck;
            }
            lastCheck = check;
        }
        return lastCheck;
    }

    public static interface ConsoleCommand {
        public void execute(String ... var1);
    }
}

