/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.app.Activity;
import android.content.Context;
import android.graphics.Insets;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowInsets;
import android.view.WindowMetrics;
import android.widget.Toast;
import com.nguyenhoanglam.imagepicker.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/DeviceHelper;", "", "()V", "isMinSdk29", "", "()Z", "isMinSdk30", "isMinSdk33", "checkCameraAvailability", "context", "Landroid/content/Context;", "getScreenHeight", "", "activity", "Landroid/app/Activity;", "imagepicker_release"})
public final class DeviceHelper {
    @NotNull
    public static final DeviceHelper INSTANCE = new DeviceHelper();

    private DeviceHelper() {
    }

    public final boolean isMinSdk29() {
        return Build.VERSION.SDK_INT >= 29;
    }

    private final boolean isMinSdk30() {
        return Build.VERSION.SDK_INT >= 30;
    }

    public final boolean isMinSdk33() {
        return Build.VERSION.SDK_INT >= 33;
    }

    public final boolean checkCameraAvailability(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.getPackageManager().hasSystemFeature("android.hardware.camera.any")) {
            Context appContext = context.getApplicationContext();
            Toast.makeText((Context)appContext, (CharSequence)appContext.getString(R.string.imagepicker_error_no_camera), (int)1).show();
            return false;
        }
        return true;
    }

    public final int getScreenHeight(@NotNull Activity activity) {
        int n;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.isMinSdk30()) {
            WindowMetrics windowMetrics = activity.getWindowManager().getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"activity.windowManager.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            Insets insets = windowMetrics2.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"windowMetrics.windowInse\u2026Insets.Type.systemBars())");
            Insets insets2 = insets;
            n = windowMetrics2.getBounds().height() - insets2.top - insets2.bottom;
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.heightPixels;
        }
        return n;
    }
}

