/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.net.Uri;
import android.provider.MediaStore;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import com.nguyenhoanglam.imagepicker.helper.SelectionState;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJN\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\u00062\u001a\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\u0006JA\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006JF\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0004j\b\u0012\u0004\u0012\u00020\u000f`\u00062\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014JM\u0010\u0016\u001a\u00020\u00172\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\u00062\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00020\u0005\u0018\u0001`\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0005J\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0010\u001a\u00020\u0005\u00a8\u0006\u001f"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/ImageHelper;", "", "()V", "filter", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "images", "bucketId", "", "(Ljava/util/ArrayList;Ljava/lang/Long;)Ljava/util/ArrayList;", "filterExclude", "excludedImages", "filterNot", "findImageIndex", "", "image", "findImageIndexes", "subImages", "folderListFromImages", "", "Lcom/nguyenhoanglam/imagepicker/model/Folder;", "getBucketSelectionState", "Lcom/nguyenhoanglam/imagepicker/helper/SelectionState;", "selectedImages", "(Ljava/util/ArrayList;Ljava/util/ArrayList;Ljava/lang/Long;)Lcom/nguyenhoanglam/imagepicker/helper/SelectionState;", "getImageCollectionUri", "Landroid/net/Uri;", "isGifFormat", "", "singleListFromImage", "imagepicker_release"})
@SourceDebugExtension(value={"SMAP\nImageHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageHelper.kt\ncom/nguyenhoanglam/imagepicker/helper/ImageHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n766#2:122\n857#2,2:123\n766#2:125\n857#2,2:126\n766#2:128\n857#2,2:129\n1747#2,3:131\n1747#2,3:134\n*S KotlinDebug\n*F\n+ 1 ImageHelper.kt\ncom/nguyenhoanglam/imagepicker/helper/ImageHelper\n*L\n46#1:122\n46#1:123,2\n54#1:125\n54#1:126,2\n65#1:128\n65#1:129,2\n102#1:131,3\n103#1:134,3\n*E\n"})
public final class ImageHelper {
    @NotNull
    public static final ImageHelper INSTANCE = new ImageHelper();

    private ImageHelper() {
    }

    @NotNull
    public final ArrayList<Image> singleListFromImage(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(image);
        return images;
    }

    @NotNull
    public final List<Folder> folderListFromImages(@NotNull List<Image> images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        Map folderMap = new LinkedHashMap();
        for (Image image : images) {
            long bucketId = image.getBucketId();
            String bucketName = image.getBucketName();
            Folder folder = (Folder)folderMap.get(bucketId);
            if (folder == null) {
                folder = new Folder(bucketId, bucketName, null, 4, null);
                Long l = bucketId;
                folderMap.put(l, folder);
            }
            folder.getImages().add(image);
        }
        return new ArrayList(folderMap.values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<Image> filter(@Nullable ArrayList<Image> images, @Nullable Long bucketId) {
        void $this$filterTo$iv$iv;
        block6: {
            block5: {
                if (images == null) {
                    return new ArrayList<Image>();
                }
                if (bucketId == null) break block5;
                long l = 0L;
                if (bucketId != l) break block6;
            }
            return new ArrayList<Image>((Collection)images);
        }
        Iterable $this$filter$iv = images;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Image it = (Image)element$iv$iv;
            boolean bl = false;
            Long l = bucketId;
            if (!(l != null && it.getBucketId() == l.longValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (ArrayList)((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<Image> filterNot(@Nullable ArrayList<Image> images, @Nullable Long bucketId) {
        void $this$filterTo$iv$iv;
        block6: {
            block5: {
                if (images == null) {
                    return new ArrayList<Image>();
                }
                if (bucketId == null) break block5;
                long l = 0L;
                if (bucketId != l) break block6;
            }
            return new ArrayList<Image>((Collection)images);
        }
        Iterable $this$filter$iv = images;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Image it = (Image)element$iv$iv;
            boolean bl = false;
            Long l = bucketId;
            if (!(l == null || it.getBucketId() != l.longValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (ArrayList)((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<Image> filterExclude(@Nullable ArrayList<Image> images, @Nullable ArrayList<Image> excludedImages) {
        void $this$filterTo$iv$iv;
        Collection collection = images;
        if (collection == null || collection.isEmpty()) {
            return new ArrayList<Image>();
        }
        collection = excludedImages;
        if (collection == null || collection.isEmpty()) {
            return new ArrayList<Image>((Collection)images);
        }
        Iterable $this$filter$iv = images;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Image it = (Image)element$iv$iv;
            boolean bl = false;
            if (!(INSTANCE.findImageIndex(it, excludedImages) == -1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (ArrayList)((List)destination$iv$iv);
    }

    public final int findImageIndex(@NotNull Image image, @NotNull ArrayList<Image> images) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(images, (String)"images");
        int n = images.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)images.get(i).getUri(), (Object)image.getUri())) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public final ArrayList<Integer> findImageIndexes(@NotNull ArrayList<Image> subImages, @NotNull ArrayList<Image> images) {
        Intrinsics.checkNotNullParameter(subImages, (String)"subImages");
        Intrinsics.checkNotNullParameter(images, (String)"images");
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        block0: for (Image image : subImages) {
            int n = images.size();
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)images.get(i).getUri(), (Object)image.getUri())) continue;
                indexes.add(i);
                continue block0;
            }
        }
        return indexes;
    }

    @NotNull
    public final SelectionState getBucketSelectionState(@Nullable ArrayList<Image> images, @Nullable ArrayList<Image> selectedImages, @Nullable Long bucketId) {
        boolean bl;
        boolean bl2;
        Image it;
        boolean $i$f$any;
        Long l = bucketId;
        long l2 = 0L;
        if (l != null && l == l2) {
            ArrayList<Image> arrayList = images;
            boolean bl3 = arrayList != null ? arrayList.isEmpty() : false;
            if (bl3) {
                return SelectionState.NOT_SELECTED;
            }
            ArrayList<Image> arrayList2 = selectedImages;
            return (arrayList2 != null ? arrayList2.isEmpty() : false) ? SelectionState.NOT_SELECTED : SelectionState.SELECTED;
        }
        ArrayList<Image> arrayList = images;
        if (arrayList != null) {
            boolean bl4;
            block13: {
                Iterable $this$any$iv = arrayList;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Image)element$iv;
                        boolean bl5 = false;
                        Long l3 = bucketId;
                        if (!(l3 != null && it.getBucketId() == l3.longValue())) continue;
                        bl4 = true;
                        break block13;
                    }
                    bl4 = false;
                }
            }
            bl2 = !bl4;
        } else {
            bl2 = false;
        }
        if (bl2) {
            return SelectionState.NOT_SELECTED;
        }
        ArrayList<Image> arrayList3 = selectedImages;
        if (arrayList3 != null) {
            boolean bl6;
            block14: {
                Iterable $this$any$iv = arrayList3;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl6 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Image)element$iv;
                        boolean bl7 = false;
                        Long l4 = bucketId;
                        if (!(l4 != null && it.getBucketId() == l4.longValue())) continue;
                        bl6 = true;
                        break block14;
                    }
                    bl6 = false;
                }
            }
            bl = !bl6;
        } else {
            bl = false;
        }
        return bl ? SelectionState.NOT_SELECTED : SelectionState.SELECTED;
    }

    public final boolean isGifFormat(@NotNull Image image) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String fileName = image.getName();
        if (StringsKt.contains$default((CharSequence)fileName, (CharSequence)".", (boolean)false, (int)2, null)) {
            String string3 = fileName.substring(StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null) + 1, fileName.length());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string2 = "";
        }
        String extension = string2;
        return StringsKt.equals((String)extension, (String)"gif", (boolean)true);
    }

    @NotNull
    public final Uri getImageCollectionUri() {
        Uri uri;
        if (DeviceHelper.INSTANCE.isMinSdk29()) {
            Uri uri2 = MediaStore.Images.Media.getContentUri((String)"external_primary");
            uri = uri2;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"getContentUri(MediaStore.VOLUME_EXTERNAL_PRIMARY)");
        } else {
            Uri uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"EXTERNAL_CONTENT_URI");
        }
        return uri;
    }
}

