/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import androidx.exifinterface.media.ExifInterface;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/ExifHelper;", "", "()V", "rotateBitmap", "Landroid/graphics/Bitmap;", "photoPath", "", "bitmap", "imagepicker_release"})
public final class ExifHelper {
    @NotNull
    public static final ExifHelper INSTANCE = new ExifHelper();

    private ExifHelper() {
    }

    @NotNull
    public final Bitmap rotateBitmap(@Nullable String photoPath, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (photoPath == null) {
            return bitmap;
        }
        try {
            Bitmap bitmap2;
            ExifInterface ei = new ExifInterface(photoPath);
            int orientation = ei.getAttributeInt("Orientation", 0);
            if (orientation == 1) {
                return bitmap;
            }
            Matrix matrix = new Matrix();
            switch (orientation) {
                case 2: {
                    matrix.setScale(-1.0f, 1.0f);
                    break;
                }
                case 3: {
                    matrix.setRotate(180.0f);
                    break;
                }
                case 4: {
                    matrix.setRotate(180.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 5: {
                    matrix.setRotate(90.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 6: {
                    matrix.setRotate(90.0f);
                    break;
                }
                case 7: {
                    matrix.setRotate(-90.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    break;
                }
                case 8: {
                    matrix.setRotate(-90.0f);
                    break;
                }
                default: {
                    return bitmap;
                }
            }
            try {
                Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(bitmap, 0, \u2026map.height, matrix, true)");
                Bitmap orientedBitmap = bitmap3;
                bitmap.recycle();
                bitmap2 = orientedBitmap;
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                bitmap2 = bitmap;
            }
            return bitmap2;
        }
        catch (IOException e) {
            e.printStackTrace();
            return bitmap;
        }
    }
}

