/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.model.CustomColor;
import com.nguyenhoanglam.imagepicker.model.CustomDrawable;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.widget.ImagePickerToolbarKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\"\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0016J\u0006\u0010)\u001a\u00020\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/nguyenhoanglam/imagepicker/widget/ImagePickerToolbar;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backImage", "Landroidx/appcompat/widget/AppCompatImageView;", "cameraImage", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "doneText", "Landroid/widget/TextView;", "selectAllImage", "titleText", "unselectAllImage", "hideSelectAllButton", "", "hideSelectButtons", "hideUnselectAllButton", "init", "setConfig", "setOnBackClickListener", "clickListener", "Landroid/view/View$OnClickListener;", "setOnCameraClickListener", "setOnDoneClickListener", "setOnSelectAllClickListener", "setOnUnselectAllClickListener", "setTitle", "title", "", "showDoneButton", "isShow", "", "showSelectAllButton", "showUnselectAllButton", "imagepicker_release"})
public final class ImagePickerToolbar
extends RelativeLayout {
    @Nullable
    private ImagePickerConfig config;
    private TextView titleText;
    private TextView doneText;
    private AppCompatImageView backImage;
    private AppCompatImageView cameraImage;
    private AppCompatImageView selectAllImage;
    private AppCompatImageView unselectAllImage;

    public ImagePickerToolbar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.init(context);
    }

    public ImagePickerToolbar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.init(context);
    }

    public ImagePickerToolbar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private final void init(Context context) {
        View.inflate((Context)context, (int)R.layout.imagepicker_toolbar, (ViewGroup)((ViewGroup)this));
        if (this.isInEditMode()) {
            return;
        }
        View view = this.findViewById(R.id.text_toolbar_title);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.text_toolbar_title)");
        this.titleText = (TextView)view;
        View view2 = this.findViewById(R.id.text_toolbar_done);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.text_toolbar_done)");
        this.doneText = (TextView)view2;
        View view3 = this.findViewById(R.id.image_toolbar_back);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(R.id.image_toolbar_back)");
        this.backImage = (AppCompatImageView)view3;
        View view4 = this.findViewById(R.id.image_toolbar_camera);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(R.id.image_toolbar_camera)");
        this.cameraImage = (AppCompatImageView)view4;
        View view5 = this.findViewById(R.id.image_toolbar_select_all);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(R.id.image_toolbar_select_all)");
        this.selectAllImage = (AppCompatImageView)view5;
        View view6 = this.findViewById(R.id.image_toolbar_unselect_all);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(R.id.image_toolbar_unselect_all)");
        this.unselectAllImage = (AppCompatImageView)view6;
    }

    public final void setConfig(@NotNull ImagePickerConfig config) {
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        CustomColor customColor = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor);
        this.setBackgroundColor(Color.parseColor((String)customColor.getToolbar()));
        TextView textView2 = this.titleText;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleText");
            textView2 = null;
        }
        TextView $this$setConfig_u24lambda_u240 = textView = textView2;
        boolean bl = false;
        $this$setConfig_u24lambda_u240.setText(config.isFolderMode() ? (CharSequence)config.getFolderTitle() : (CharSequence)config.getImageTitle());
        CustomColor customColor2 = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor2);
        $this$setConfig_u24lambda_u240.setTextColor(Color.parseColor((String)customColor2.getToolbarTitle()));
        TextView textView3 = this.doneText;
        if (textView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneText");
            textView3 = null;
        }
        TextView $this$setConfig_u24lambda_u241 = textView = textView3;
        boolean bl2 = false;
        $this$setConfig_u24lambda_u241.setText((CharSequence)config.getDoneButtonTitle());
        CustomColor customColor3 = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor3);
        $this$setConfig_u24lambda_u241.setTextColor(Color.parseColor((String)customColor3.getDoneButtonTitle()));
        $this$setConfig_u24lambda_u241.setVisibility(config.isAlwaysShowDoneButton() ? 0 : 8);
        AppCompatImageView appCompatImageView = this.backImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backImage");
            appCompatImageView = null;
        }
        CustomDrawable customDrawable = config.getCustomDrawable();
        Intrinsics.checkNotNull((Object)customDrawable);
        int n = customDrawable.getBackIcon();
        CustomColor customColor4 = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor4);
        String string2 = customColor4.getToolbarIcon();
        Intrinsics.checkNotNull((Object)string2);
        ImagePickerToolbarKt.setResourceAndColor(appCompatImageView, n, R.drawable.imagepicker_ic_back, string2);
        AppCompatImageView appCompatImageView2 = this.cameraImage;
        if (appCompatImageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraImage");
            appCompatImageView2 = null;
        }
        TextView $this$setConfig_u24lambda_u242 = textView = appCompatImageView2;
        boolean bl3 = false;
        CustomDrawable customDrawable2 = config.getCustomDrawable();
        Intrinsics.checkNotNull((Object)customDrawable2);
        int n2 = customDrawable2.getCameraIcon();
        CustomColor customColor5 = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor5);
        String string3 = customColor5.getToolbarIcon();
        Intrinsics.checkNotNull((Object)string3);
        ImagePickerToolbarKt.setResourceAndColor((AppCompatImageView)$this$setConfig_u24lambda_u242, n2, R.drawable.imagepicker_ic_camera, string3);
        $this$setConfig_u24lambda_u242.setVisibility(config.isShowCamera() ? 0 : 8);
        AppCompatImageView appCompatImageView3 = this.selectAllImage;
        if (appCompatImageView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectAllImage");
            appCompatImageView3 = null;
        }
        TextView $this$setConfig_u24lambda_u243 = textView = appCompatImageView3;
        boolean bl4 = false;
        CustomDrawable customDrawable3 = config.getCustomDrawable();
        Intrinsics.checkNotNull((Object)customDrawable3);
        int n3 = customDrawable3.getSelectAllIcon();
        CustomColor customColor6 = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor6);
        String string4 = customColor6.getToolbarIcon();
        Intrinsics.checkNotNull((Object)string4);
        ImagePickerToolbarKt.setResourceAndColor((AppCompatImageView)$this$setConfig_u24lambda_u243, n3, R.drawable.imagepicker_ic_select_all, string4);
        $this$setConfig_u24lambda_u243.setVisibility(8);
        AppCompatImageView appCompatImageView4 = this.unselectAllImage;
        if (appCompatImageView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unselectAllImage");
            appCompatImageView4 = null;
        }
        TextView $this$setConfig_u24lambda_u244 = textView = appCompatImageView4;
        boolean bl5 = false;
        CustomDrawable customDrawable4 = config.getCustomDrawable();
        Intrinsics.checkNotNull((Object)customDrawable4);
        int n4 = customDrawable4.getUnselectAllIcon();
        CustomColor customColor7 = config.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor7);
        String string5 = customColor7.getToolbarIcon();
        Intrinsics.checkNotNull((Object)string5);
        ImagePickerToolbarKt.setResourceAndColor((AppCompatImageView)$this$setConfig_u24lambda_u244, n4, R.drawable.imagepicker_ic_unselect_all, string5);
        $this$setConfig_u24lambda_u244.setVisibility(8);
    }

    public final void setTitle(@Nullable String title) {
        TextView textView = this.titleText;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"titleText");
            textView = null;
        }
        textView.setText((CharSequence)title);
    }

    public final void showDoneButton(boolean isShow) {
        TextView textView = this.doneText;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneText");
            textView = null;
        }
        textView.setVisibility(isShow ? 0 : 8);
    }

    public final void showSelectAllButton() {
        AppCompatImageView appCompatImageView = this.selectAllImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectAllImage");
            appCompatImageView = null;
        }
        appCompatImageView.setVisibility(0);
    }

    public final void hideSelectAllButton() {
        AppCompatImageView appCompatImageView = this.selectAllImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectAllImage");
            appCompatImageView = null;
        }
        appCompatImageView.setVisibility(8);
    }

    public final void showUnselectAllButton() {
        AppCompatImageView appCompatImageView = this.unselectAllImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unselectAllImage");
            appCompatImageView = null;
        }
        appCompatImageView.setVisibility(0);
    }

    public final void hideUnselectAllButton() {
        AppCompatImageView appCompatImageView = this.unselectAllImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unselectAllImage");
            appCompatImageView = null;
        }
        appCompatImageView.setVisibility(8);
    }

    public final void hideSelectButtons() {
        AppCompatImageView appCompatImageView = this.selectAllImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectAllImage");
            appCompatImageView = null;
        }
        appCompatImageView.setVisibility(8);
        AppCompatImageView appCompatImageView2 = this.unselectAllImage;
        if (appCompatImageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unselectAllImage");
            appCompatImageView2 = null;
        }
        appCompatImageView2.setVisibility(8);
    }

    public final void setOnBackClickListener(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        AppCompatImageView appCompatImageView = this.backImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backImage");
            appCompatImageView = null;
        }
        appCompatImageView.setOnClickListener(clickListener);
    }

    public final void setOnSelectAllClickListener(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        AppCompatImageView appCompatImageView = this.selectAllImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectAllImage");
            appCompatImageView = null;
        }
        appCompatImageView.setOnClickListener(clickListener);
    }

    public final void setOnUnselectAllClickListener(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        AppCompatImageView appCompatImageView = this.unselectAllImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unselectAllImage");
            appCompatImageView = null;
        }
        appCompatImageView.setOnClickListener(clickListener);
    }

    public final void setOnCameraClickListener(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        AppCompatImageView appCompatImageView = this.cameraImage;
        if (appCompatImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraImage");
            appCompatImageView = null;
        }
        appCompatImageView.setOnClickListener(clickListener);
    }

    public final void setOnDoneClickListener(@NotNull View.OnClickListener clickListener) {
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        TextView textView = this.doneText;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneText");
            textView = null;
        }
        textView.setOnClickListener(clickListener);
    }
}

