/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.view.View;
import android.view.Window;
import android.widget.PopupWindow;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.google.android.material.imageview.ShapeableImageView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.databinding.ImagepickerActivityImagepickerBinding;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import com.nguyenhoanglam.imagepicker.helper.GlideHelper;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.PermissionHelper;
import com.nguyenhoanglam.imagepicker.helper.SelectionState;
import com.nguyenhoanglam.imagepicker.helper.ToastHelper;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.listener.OnImagePreviewListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener;
import com.nguyenhoanglam.imagepicker.model.CustomColor;
import com.nguyenhoanglam.imagepicker.model.CustomDrawable;
import com.nguyenhoanglam.imagepicker.model.CustomMessage;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.model.Result;
import com.nguyenhoanglam.imagepicker.model.StatusBarContent;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.BaseFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.FolderFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModel;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModelFactory;
import com.nguyenhoanglam.imagepicker.widget.ImagePickerToolbar;
import com.nguyenhoanglam.imagepicker.widget.SnackBarView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002JO\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u001a\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\"\u0018\u00010!j\n\u0012\u0004\u0012\u00020\"\u0018\u0001`#2\u001a\u0010$\u001a\u0016\u0012\u0004\u0012\u00020\"\u0018\u00010!j\n\u0012\u0004\u0012\u00020\"\u0018\u0001`#H\u0002\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u00020\u001bH\u0002J \u0010(\u001a\u00020\u001b2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#H\u0002J\n\u0010)\u001a\u0004\u0018\u00010*H\u0002J\b\u0010+\u001a\u00020\u001bH\u0002J\b\u0010,\u001a\u00020\u001bH\u0002J\b\u0010-\u001a\u00020\u001bH\u0002J\b\u0010.\u001a\u00020/H\u0002J\u0012\u00100\u001a\u00020\u001b2\b\u00101\u001a\u0004\u0018\u000102H\u0014J\b\u00103\u001a\u00020\u001bH\u0002J\u0010\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u001bH\u0016J+\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\u0006\u0010>\u001a\u00020?H\u0016\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u00020\u001bH\u0014J \u0010B\u001a\u00020\u001b2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#H\u0016J\u0010\u0010C\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\"H\u0016J\u0010\u0010E\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\"H\u0016J\b\u0010F\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/nguyenhoanglam/imagepicker/listener/OnFolderClickListener;", "Lcom/nguyenhoanglam/imagepicker/listener/OnImageSelectListener;", "Lcom/nguyenhoanglam/imagepicker/listener/OnImagePreviewListener;", "()V", "backClickListener", "Landroid/view/View$OnClickListener;", "binding", "Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerActivityImagepickerBinding;", "cameraClickListener", "cameraModule", "Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraModule;", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "doneClickListener", "popupWindow", "Landroid/widget/PopupWindow;", "resultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "selectAllClickListener", "unselectAllClickListener", "viewModel", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "captureImage", "", "captureImageWithPermission", "configSelectAllButtons", "bucketId", "", "images", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "selectedImages", "(Ljava/lang/Long;Ljava/util/ArrayList;Ljava/util/ArrayList;)V", "fetchData", "fetchDataWithPermission", "finishPickImages", "getCurrentFragment", "Landroidx/fragment/app/Fragment;", "handleBackPress", "handleSelectAllImages", "handleUnselectAllImages", "isFolderFragment", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDone", "onFolderClick", "folder", "Lcom/nguyenhoanglam/imagepicker/model/Folder;", "onHideImagePreview", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "onSelectedImagesChanged", "onShowImagePreview", "image", "onSingleModeImageSelected", "setupViews", "imagepicker_release"})
@SourceDebugExtension(value={"SMAP\nImagePickerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePickerActivity.kt\ncom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerActivity\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,467:1\n37#2,2:468\n*S KotlinDebug\n*F\n+ 1 ImagePickerActivity.kt\ncom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerActivity\n*L\n366#1:468,2\n*E\n"})
public final class ImagePickerActivity
extends AppCompatActivity
implements OnFolderClickListener,
OnImageSelectListener,
OnImagePreviewListener {
    private ImagepickerActivityImagepickerBinding binding;
    private ImagePickerConfig config;
    private ImagePickerViewModel viewModel;
    @NotNull
    private final CameraModule cameraModule = new CameraModule();
    @NotNull
    private final View.OnClickListener backClickListener = arg_0 -> ImagePickerActivity.backClickListener$lambda$0(this, arg_0);
    @NotNull
    private final View.OnClickListener cameraClickListener = arg_0 -> ImagePickerActivity.cameraClickListener$lambda$1(this, arg_0);
    @NotNull
    private final View.OnClickListener selectAllClickListener = arg_0 -> ImagePickerActivity.selectAllClickListener$lambda$2(this, arg_0);
    @NotNull
    private final View.OnClickListener unselectAllClickListener = arg_0 -> ImagePickerActivity.unselectAllClickListener$lambda$3(this, arg_0);
    @NotNull
    private final View.OnClickListener doneClickListener = arg_0 -> ImagePickerActivity.doneClickListener$lambda$4(this, arg_0);
    @Nullable
    private PopupWindow popupWindow;
    @NotNull
    private final ActivityResultLauncher<Intent> resultLauncher;

    public ImagePickerActivity() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> ImagePickerActivity.resultLauncher$lambda$5(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026)\n            }\n        }");
        this.resultLauncher = activityResultLauncher;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ImagePickerViewModel imagePickerViewModel;
        ImagePickerConfig imagePickerConfig;
        ImagePickerConfig imagePickerConfig2;
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null) {
            this.finish();
            return;
        }
        if (DeviceHelper.INSTANCE.isMinSdk33()) {
            Object object = this.getIntent().getParcelableExtra("ImagePickerConfig", ImagePickerConfig.class);
            Intrinsics.checkNotNull((Object)object);
            imagePickerConfig2 = (ImagePickerConfig)object;
        } else {
            Parcelable parcelable = this.getIntent().getParcelableExtra("ImagePickerConfig");
            Intrinsics.checkNotNull((Object)parcelable);
            imagePickerConfig2 = (ImagePickerConfig)parcelable;
        }
        if ((imagePickerConfig = (this.config = imagePickerConfig2)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        imagePickerConfig.initDefaultValues((Context)this);
        Window window = this.getWindow();
        ImagePickerConfig imagePickerConfig3 = this.config;
        if (imagePickerConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig3 = null;
        }
        CustomColor customColor = imagePickerConfig3.getCustomColor();
        Intrinsics.checkNotNull((Object)customColor);
        window.setStatusBarColor(Color.parseColor((String)customColor.getStatusBar()));
        WindowCompat.setDecorFitsSystemWindows((Window)this.getWindow(), (boolean)false);
        WindowInsetsControllerCompat windowInsetsControllerCompat = new WindowInsetsControllerCompat(this.getWindow(), this.getWindow().getDecorView());
        ImagePickerConfig imagePickerConfig4 = this.config;
        if (imagePickerConfig4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig4 = null;
        }
        windowInsetsControllerCompat.setAppearanceLightStatusBars(imagePickerConfig4.getStatusBarContentMode() == StatusBarContent.DARK);
        ImagePickerConfig imagePickerConfig5 = this.config;
        if (imagePickerConfig5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig5 = null;
        }
        boolean bl = imagePickerConfig5.isImageTransitionEnabled();
        ImagePickerConfig imagePickerConfig6 = this.config;
        if (imagePickerConfig6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig6 = null;
        }
        CustomDrawable customDrawable = imagePickerConfig6.getCustomDrawable();
        Intrinsics.checkNotNull((Object)customDrawable);
        int n = customDrawable.getLoadingImagePlaceholder();
        ImagePickerConfig imagePickerConfig7 = this.config;
        if (imagePickerConfig7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig7 = null;
        }
        CustomDrawable customDrawable2 = imagePickerConfig7.getCustomDrawable();
        Intrinsics.checkNotNull((Object)customDrawable2);
        GlideHelper.Companion.setConfig(bl, n, customDrawable2.getErrorImagePlaceholder());
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = ImagepickerActivityImagepickerBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)imagepickerActivityImagepickerBinding, (String)"inflate(layoutInflater)");
        this.binding = imagepickerActivityImagepickerBinding;
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding2 = this.binding;
        if (imagepickerActivityImagepickerBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding2 = null;
        }
        this.setContentView((View)imagepickerActivityImagepickerBinding2.getRoot());
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)this;
        Application application = this.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"this.application");
        this.viewModel = (ImagePickerViewModel)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new ImagePickerViewModelFactory(application)).get(ImagePickerViewModel.class);
        ImagePickerViewModel imagePickerViewModel2 = this.viewModel;
        if (imagePickerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel2 = null;
        }
        ImagePickerViewModel $this$onCreate_u24lambda_u246 = imagePickerViewModel = imagePickerViewModel2;
        boolean bl2 = false;
        ImagePickerConfig imagePickerConfig8 = this.config;
        if (imagePickerConfig8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig8 = null;
        }
        $this$onCreate_u24lambda_u246.setConfig(imagePickerConfig8);
        Function1 function1 = (Function1)new Function1<Result, Unit>(this){
            final /* synthetic */ ImagePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Result it) {
                Fragment fragment = ImagePickerActivity.access$getCurrentFragment(this.this$0);
                if (fragment != null && fragment instanceof ImageFragment) {
                    Long l = ((ImageFragment)fragment).getBucketId();
                    ArrayList<Image> arrayList = it.getImages();
                    ImagePickerViewModel imagePickerViewModel = ImagePickerActivity.access$getViewModel$p(this.this$0);
                    if (imagePickerViewModel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        imagePickerViewModel = null;
                    }
                    ImagePickerActivity.access$configSelectAllButtons(this.this$0, l, arrayList, (ArrayList)imagePickerViewModel.getSelectedImages().getValue());
                }
            }
        };
        $this$onCreate_u24lambda_u246.getResult().observe((LifecycleOwner)this, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
        function1 = (Function1)new Function1<ArrayList<Image>, Unit>(this){
            final /* synthetic */ ImagePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            public final void invoke(ArrayList<Image> it) {
                v0 = ImagePickerActivity.access$getBinding$p(this.this$0);
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    v0 = null;
                }
                v1 = v0.toolbar;
                v2 = ImagePickerActivity.access$getConfig$p(this.this$0);
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    v2 = null;
                }
                if (v2.isAlwaysShowDoneButton()) ** GOTO lbl-1000
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                if (((Collection)it).isEmpty() == false) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                v1.showDoneButton(v3);
                fragment = ImagePickerActivity.access$getCurrentFragment(this.this$0);
                if (fragment != null && fragment instanceof ImageFragment) {
                    v4 = ((ImageFragment)fragment).getBucketId();
                    v5 = ImagePickerActivity.access$getViewModel$p(this.this$0);
                    if (v5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        v5 = null;
                    }
                    v6 = (Result)v5.getResult().getValue();
                    ImagePickerActivity.access$configSelectAllButtons(this.this$0, v4, v6 != null ? v6.getImages() : null, it);
                }
            }
        };
        $this$onCreate_u24lambda_u246.getSelectedImages().observe((LifecycleOwner)this, new /* invalid duplicate definition of identical inner class */);
        this.setupViews();
        this.getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, new OnBackPressedCallback(this){
            final /* synthetic */ ImagePickerActivity this$0;
            {
                this.this$0 = $receiver;
                super(true);
            }

            public void handleOnBackPressed() {
                ImagePickerActivity.access$handleBackPress(this.this$0);
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.fetchDataWithPermission();
    }

    private final void setupViews() {
        BaseFragment baseFragment;
        ImagePickerToolbar imagePickerToolbar;
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
        if (imagepickerActivityImagepickerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding = null;
        }
        ImagePickerToolbar $this$setupViews_u24lambda_u247 = imagePickerToolbar = imagepickerActivityImagepickerBinding.toolbar;
        boolean bl = false;
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        $this$setupViews_u24lambda_u247.setConfig(imagePickerConfig);
        $this$setupViews_u24lambda_u247.setOnBackClickListener(this.backClickListener);
        $this$setupViews_u24lambda_u247.setOnCameraClickListener(this.cameraClickListener);
        $this$setupViews_u24lambda_u247.setOnSelectAllClickListener(this.selectAllClickListener);
        $this$setupViews_u24lambda_u247.setOnUnselectAllClickListener(this.unselectAllClickListener);
        $this$setupViews_u24lambda_u247.setOnDoneClickListener(this.doneClickListener);
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding2 = this.binding;
        if (imagepickerActivityImagepickerBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding2 = null;
        }
        SnackBarView snackBarView = imagepickerActivityImagepickerBinding2.snackbar;
        ImagePickerConfig imagePickerConfig2 = this.config;
        if (imagePickerConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig2 = null;
        }
        snackBarView.config(imagePickerConfig2);
        ImagePickerConfig imagePickerConfig3 = this.config;
        if (imagePickerConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig3 = null;
        }
        if (imagePickerConfig3.isFolderMode()) {
            ImagePickerConfig imagePickerConfig4 = this.config;
            if (imagePickerConfig4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig4 = null;
            }
            baseFragment = FolderFragment.Companion.newInstance(imagePickerConfig4.getFolderGridCount());
        } else {
            ImagePickerConfig imagePickerConfig5 = this.config;
            if (imagePickerConfig5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig5 = null;
            }
            baseFragment = ImageFragment.Companion.newInstance(imagePickerConfig5.getImageGridCount());
        }
        BaseFragment initialFragment = baseFragment;
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragmentContainer, (Fragment)initialFragment).commit();
    }

    private final Fragment getCurrentFragment() {
        return this.getSupportFragmentManager().findFragmentById(R.id.fragmentContainer);
    }

    private final boolean isFolderFragment() {
        Fragment fragment = this.getCurrentFragment();
        return fragment != null && fragment instanceof FolderFragment;
    }

    private final void handleBackPress() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            this.getSupportFragmentManager().popBackStackImmediate();
            if (this.isFolderFragment()) {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
                if (imagepickerActivityImagepickerBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding = null;
                }
                ImagePickerToolbar imagePickerToolbar = imagepickerActivityImagepickerBinding.toolbar;
                ImagePickerConfig imagePickerConfig = this.config;
                if (imagePickerConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    imagePickerConfig = null;
                }
                imagePickerToolbar.setTitle(imagePickerConfig.getFolderTitle());
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding2 = this.binding;
                if (imagepickerActivityImagepickerBinding2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding2 = null;
                }
                imagepickerActivityImagepickerBinding2.toolbar.hideSelectButtons();
            }
        } else {
            ImagePickerConfig imagePickerConfig = this.config;
            if (imagePickerConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig = null;
            }
            this.finishPickImages(imagePickerConfig.getSelectedImages());
        }
    }

    private final void fetchDataWithPermission() {
        String readPermission = DeviceHelper.INSTANCE.isMinSdk33() ? "android.permission.READ_MEDIA_IMAGES" : "android.permission.READ_EXTERNAL_STORAGE";
        switch (WhenMappings.$EnumSwitchMapping$0[PermissionHelper.INSTANCE.checkPermission((Activity)this, readPermission).ordinal()]) {
            case 1: {
                this.fetchData();
                break;
            }
            case 2: {
                String[] stringArray = new String[]{readPermission};
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1000);
                break;
            }
            case 3: {
                String[] stringArray = new String[]{readPermission};
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1000);
                break;
            }
            default: {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
                if (imagepickerActivityImagepickerBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding = null;
                }
                SnackBarView snackBarView = imagepickerActivityImagepickerBinding.snackbar;
                ImagePickerConfig imagePickerConfig = this.config;
                if (imagePickerConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    imagePickerConfig = null;
                }
                CustomMessage customMessage = imagePickerConfig.getCustomMessage();
                snackBarView.show(customMessage != null ? customMessage.getNoPhotoAccessPermission() : null, arg_0 -> ImagePickerActivity.fetchDataWithPermission$lambda$8(this, arg_0));
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        switch (requestCode) {
            case 1000: {
                if (PermissionHelper.INSTANCE.hasGranted(grantResults)) {
                    this.fetchData();
                    break;
                }
                this.finish();
                break;
            }
            case 1001: 
            case 1002: {
                if (!PermissionHelper.INSTANCE.hasGranted(grantResults)) break;
                this.captureImage();
                break;
            }
            default: {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    private final void fetchData() {
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        imagePickerViewModel.fetchImages();
    }

    private final void onDone() {
        ArrayList selectedImages;
        ArrayList arrayList;
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        if ((arrayList = (selectedImages = (ArrayList)imagePickerViewModel.getSelectedImages().getValue())) == null) {
            arrayList = new ArrayList();
        }
        this.finishPickImages(arrayList);
    }

    private final void handleSelectAllImages() {
        Fragment fragment = this.getCurrentFragment();
        if (fragment != null && fragment instanceof ImageFragment) {
            ((ImageFragment)fragment).selectAllImages();
        }
    }

    private final void handleUnselectAllImages() {
        Fragment fragment = this.getCurrentFragment();
        if (fragment != null && fragment instanceof ImageFragment) {
            ((ImageFragment)fragment).unselectAllImages();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void configSelectAllButtons(Long bucketId, ArrayList<Image> images, ArrayList<Image> selectedImages) {
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding;
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        if (imagePickerConfig.isSingleSelectMode()) {
            return;
        }
        SelectionState state = ImageHelper.INSTANCE.getBucketSelectionState(images, selectedImages, bucketId);
        if (WhenMappings.$EnumSwitchMapping$1[state.ordinal()] == 1) {
            ImagePickerConfig imagePickerConfig2 = this.config;
            if (imagePickerConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig2 = null;
            }
            if (imagePickerConfig2.isUnselectAllEnabled()) {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding2 = this.binding;
                if (imagepickerActivityImagepickerBinding2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding2 = null;
                }
                imagepickerActivityImagepickerBinding2.toolbar.hideSelectAllButton();
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding3 = this.binding;
                if (imagepickerActivityImagepickerBinding3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding3 = null;
                }
                imagepickerActivityImagepickerBinding3.toolbar.showUnselectAllButton();
                return;
            }
            ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding4 = this.binding;
            if (imagepickerActivityImagepickerBinding4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                imagepickerActivityImagepickerBinding4 = null;
            }
            imagepickerActivityImagepickerBinding4.toolbar.hideSelectButtons();
            return;
        }
        int imagesByBucketCount = ImageHelper.INSTANCE.filter(images, bucketId).size();
        ArrayList<Image> arrayList = selectedImages;
        int selectedImagesCount = arrayList != null ? arrayList.size() : 0;
        ImagePickerConfig imagePickerConfig3 = this.config;
        if (imagePickerConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig3 = null;
        }
        if (imagePickerConfig3.isSelectAllEnabled()) {
            ImagePickerConfig imagePickerConfig4 = this.config;
            if (imagePickerConfig4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig4 = null;
            }
            if (imagePickerConfig4.getLimitSize() >= selectedImagesCount + imagesByBucketCount) {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding5 = this.binding;
                if (imagepickerActivityImagepickerBinding5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding5 = null;
                }
                imagepickerActivityImagepickerBinding5.toolbar.showSelectAllButton();
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding6 = this.binding;
                if (imagepickerActivityImagepickerBinding6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding6 = null;
                }
                imagepickerActivityImagepickerBinding6.toolbar.hideUnselectAllButton();
                return;
            }
        }
        if ((imagepickerActivityImagepickerBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding = null;
        }
        imagepickerActivityImagepickerBinding.toolbar.hideSelectButtons();
    }

    private final void captureImageWithPermission() {
        boolean isCameraPermissionDeclared = PermissionHelper.INSTANCE.isPermissionDeclared((Context)this, "android.permission.CAMERA");
        if (DeviceHelper.INSTANCE.isMinSdk29()) {
            if (isCameraPermissionDeclared) {
                String cameraPermission = "android.permission.CAMERA";
                switch (WhenMappings.$EnumSwitchMapping$0[PermissionHelper.INSTANCE.checkPermission((Activity)this, cameraPermission).ordinal()]) {
                    case 1: {
                        this.captureImage();
                        break;
                    }
                    case 2: {
                        String[] stringArray = new String[]{cameraPermission};
                        PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1002);
                        break;
                    }
                    case 3: {
                        String[] stringArray = new String[]{cameraPermission};
                        PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1002);
                        break;
                    }
                    default: {
                        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
                        if (imagepickerActivityImagepickerBinding == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                            imagepickerActivityImagepickerBinding = null;
                        }
                        SnackBarView snackBarView = imagepickerActivityImagepickerBinding.snackbar;
                        ImagePickerConfig imagePickerConfig = this.config;
                        if (imagePickerConfig == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            imagePickerConfig = null;
                        }
                        CustomMessage customMessage = imagePickerConfig.getCustomMessage();
                        Intrinsics.checkNotNull((Object)customMessage);
                        snackBarView.show(customMessage.getNoCameraPermission(), arg_0 -> ImagePickerActivity.captureImageWithPermission$lambda$9(this, arg_0));
                        break;
                    }
                }
            } else {
                this.captureImage();
            }
        } else if (isCameraPermissionDeclared) {
            String[] stringArray = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
            PermissionHelper.STATUS[] statuses = PermissionHelper.INSTANCE.checkPermissions((Activity)this, stringArray);
            if (statuses[0] == PermissionHelper.STATUS.GRANTED && statuses[1] == PermissionHelper.STATUS.GRANTED) {
                this.captureImage();
            } else if (statuses[0] == PermissionHelper.STATUS.DISABLED && statuses[1] == PermissionHelper.STATUS.DISABLED) {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
                if (imagepickerActivityImagepickerBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding = null;
                }
                SnackBarView snackBarView = imagepickerActivityImagepickerBinding.snackbar;
                ImagePickerConfig imagePickerConfig = this.config;
                if (imagePickerConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    imagePickerConfig = null;
                }
                CustomMessage customMessage = imagePickerConfig.getCustomMessage();
                snackBarView.show(customMessage != null ? customMessage.getNoCameraPermission() : null, arg_0 -> ImagePickerActivity.captureImageWithPermission$lambda$10(this, arg_0));
            } else if (statuses[0] == PermissionHelper.STATUS.DISABLED) {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
                if (imagepickerActivityImagepickerBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding = null;
                }
                SnackBarView snackBarView = imagepickerActivityImagepickerBinding.snackbar;
                ImagePickerConfig imagePickerConfig = this.config;
                if (imagePickerConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    imagePickerConfig = null;
                }
                CustomMessage customMessage = imagePickerConfig.getCustomMessage();
                snackBarView.show(customMessage != null ? customMessage.getNoCameraPermission() : null, arg_0 -> ImagePickerActivity.captureImageWithPermission$lambda$11(this, arg_0));
            } else if (statuses[1] == PermissionHelper.STATUS.DISABLED) {
                ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
                if (imagepickerActivityImagepickerBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    imagepickerActivityImagepickerBinding = null;
                }
                SnackBarView snackBarView = imagepickerActivityImagepickerBinding.snackbar;
                ImagePickerConfig imagePickerConfig = this.config;
                if (imagePickerConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    imagePickerConfig = null;
                }
                CustomMessage customMessage = imagePickerConfig.getCustomMessage();
                snackBarView.show(customMessage != null ? customMessage.getNoPhotoAccessPermission() : null, arg_0 -> ImagePickerActivity.captureImageWithPermission$lambda$12(this, arg_0));
            } else {
                ArrayList<String> requestPermissions = new ArrayList<String>();
                int n = statuses.length;
                for (int i = 0; i < n; ++i) {
                    int index = i;
                    PermissionHelper.STATUS value = statuses[i];
                    if (value != PermissionHelper.STATUS.NOT_GRANTED && value != PermissionHelper.STATUS.DENIED) continue;
                    requestPermissions.add(index == 0 ? "android.permission.CAMERA" : "android.permission.WRITE_EXTERNAL_STORAGE");
                }
                Collection $this$toTypedArray$iv = requestPermissions;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, thisCollection$iv.toArray(new String[0]), 1002);
            }
        } else {
            String writePermission = "android.permission.WRITE_EXTERNAL_STORAGE";
            switch (WhenMappings.$EnumSwitchMapping$0[PermissionHelper.INSTANCE.checkPermission((Activity)this, writePermission).ordinal()]) {
                case 1: {
                    this.captureImage();
                    break;
                }
                case 2: {
                    String[] stringArray = new String[]{writePermission};
                    PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1001);
                    break;
                }
                case 3: {
                    String[] stringArray = new String[]{writePermission};
                    PermissionHelper.INSTANCE.requestAllPermissions((Activity)this, stringArray, 1001);
                    break;
                }
                default: {
                    ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
                    if (imagepickerActivityImagepickerBinding == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                        imagepickerActivityImagepickerBinding = null;
                    }
                    SnackBarView snackBarView = imagepickerActivityImagepickerBinding.snackbar;
                    ImagePickerConfig imagePickerConfig = this.config;
                    if (imagePickerConfig == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                        imagePickerConfig = null;
                    }
                    CustomMessage customMessage = imagePickerConfig.getCustomMessage();
                    snackBarView.show(customMessage != null ? customMessage.getNoPhotoAccessPermission() : null, arg_0 -> ImagePickerActivity.captureImageWithPermission$lambda$13(this, arg_0));
                }
            }
        }
    }

    private final void captureImage() {
        Intent intent;
        if (!DeviceHelper.INSTANCE.checkCameraAvailability((Context)this)) {
            return;
        }
        Context context = (Context)this;
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        if ((intent = this.cameraModule.getCameraIntent(context, imagePickerConfig)) == null) {
            Context context2 = (Context)this;
            String string2 = this.getString(R.string.imagepicker_error_camera);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.imagepicker_error_camera)");
            ToastHelper.Companion.show$default(ToastHelper.Companion, context2, string2, 0, 4, null);
            return;
        }
        this.resultLauncher.launch((Object)intent);
    }

    private final void finishPickImages(ArrayList<Image> images) {
        Intent data = new Intent();
        data.putParcelableArrayListExtra("ImagePickerImages", images);
        this.setResult(-1, data);
        this.finish();
    }

    @Override
    public void onFolderClick(@NotNull Folder folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        long l = folder.getBucketId();
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        fragmentTransaction.add(R.id.fragmentContainer, (Fragment)ImageFragment.Companion.newInstance(l, imagePickerConfig.getImageGridCount())).addToBackStack(null).commit();
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this.binding;
        if (imagepickerActivityImagepickerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding = null;
        }
        imagepickerActivityImagepickerBinding.toolbar.setTitle(folder.getName());
        Long l2 = folder.getBucketId();
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        Result result = (Result)imagePickerViewModel.getResult().getValue();
        ArrayList<Image> arrayList = result != null ? result.getImages() : null;
        ImagePickerViewModel imagePickerViewModel2 = this.viewModel;
        if (imagePickerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel2 = null;
        }
        this.configSelectAllButtons(l2, arrayList, (ArrayList)imagePickerViewModel2.getSelectedImages().getValue());
    }

    @Override
    public void onSelectedImagesChanged(@NotNull ArrayList<Image> selectedImages) {
        Intrinsics.checkNotNullParameter(selectedImages, (String)"selectedImages");
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        imagePickerViewModel.getSelectedImages().setValue(selectedImages);
    }

    @Override
    public void onSingleModeImageSelected(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.finishPickImages(ImageHelper.INSTANCE.singleListFromImage(image));
    }

    @Override
    public void onShowImagePreview(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        View previewLayout = this.getLayoutInflater().inflate(R.layout.imagepicker_image_preview, null);
        ShapeableImageView imageView = (ShapeableImageView)previewLayout.findViewById(R.id.image);
        PopupWindow popupWindow = this.popupWindow = new PopupWindow(previewLayout, -1, -1);
        if (popupWindow != null) {
            popupWindow.setAnimationStyle(R.style.imagepicker_ImagePreviewPopupWindow);
        }
        PopupWindow popupWindow2 = this.popupWindow;
        if (popupWindow2 != null) {
            popupWindow2.showAtLocation(previewLayout, 17, 0, 0);
        }
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imageView");
        GlideHelper.Companion.loadPreviewImage(imageView, image.getUri());
        new Handler(Looper.getMainLooper()).postDelayed(() -> ImagePickerActivity.onShowImagePreview$lambda$14(this), 100L);
    }

    @Override
    public void onHideImagePreview() {
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding;
        PopupWindow popupWindow = this.popupWindow;
        if (popupWindow != null) {
            popupWindow.dismiss();
        }
        if ((imagepickerActivityImagepickerBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding = null;
        }
        imagepickerActivityImagepickerBinding.overlay.setVisibility(8);
    }

    private static final void backClickListener$lambda$0(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleBackPress();
    }

    private static final void cameraClickListener$lambda$1(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.captureImageWithPermission();
    }

    private static final void selectAllClickListener$lambda$2(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleSelectAllImages();
    }

    private static final void unselectAllClickListener$lambda$3(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleUnselectAllImages();
    }

    private static final void doneClickListener$lambda$4(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onDone();
    }

    private static final void resultLauncher$lambda$5(ImagePickerActivity this$0, ActivityResult result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (result.getResultCode() == -1) {
            CameraModule cameraModule = this$0.cameraModule;
            Context context = (Context)this$0;
            ImagePickerConfig imagePickerConfig = this$0.config;
            if (imagePickerConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                imagePickerConfig = null;
            }
            cameraModule.saveImage(context, imagePickerConfig, new OnImageReadyListener(this$0){
                final /* synthetic */ ImagePickerActivity this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onImageReady(@NotNull ArrayList<Image> images) {
                    Intrinsics.checkNotNullParameter(images, (String)"images");
                    ImagePickerConfig imagePickerConfig = ImagePickerActivity.access$getConfig$p(this.this$0);
                    if (imagePickerConfig == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                        imagePickerConfig = null;
                    }
                    if (imagePickerConfig.isSingleSelectMode() || !((Collection)images).isEmpty()) {
                        this.this$0.onSingleModeImageSelected((Image)CollectionsKt.first((List)images));
                        return;
                    }
                    ImagePickerActivity.access$fetchDataWithPermission(this.this$0);
                }

                public void onImageNotReady() {
                    ImagePickerActivity.access$fetchDataWithPermission(this.this$0);
                }
            });
        }
    }

    private static final void fetchDataWithPermission$lambda$8(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
    }

    private static final void captureImageWithPermission$lambda$9(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
    }

    private static final void captureImageWithPermission$lambda$10(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
    }

    private static final void captureImageWithPermission$lambda$11(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
    }

    private static final void captureImageWithPermission$lambda$12(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
    }

    private static final void captureImageWithPermission$lambda$13(ImagePickerActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PermissionHelper.INSTANCE.openAppSettings((Activity)this$0);
    }

    private static final void onShowImagePreview$lambda$14(ImagePickerActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ImagepickerActivityImagepickerBinding imagepickerActivityImagepickerBinding = this$0.binding;
        if (imagepickerActivityImagepickerBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            imagepickerActivityImagepickerBinding = null;
        }
        imagepickerActivityImagepickerBinding.overlay.setVisibility(0);
    }

    public static final /* synthetic */ void access$handleBackPress(ImagePickerActivity $this) {
        $this.handleBackPress();
    }

    public static final /* synthetic */ ImagePickerConfig access$getConfig$p(ImagePickerActivity $this) {
        return $this.config;
    }

    public static final /* synthetic */ void access$fetchDataWithPermission(ImagePickerActivity $this) {
        $this.fetchDataWithPermission();
    }

    public static final /* synthetic */ Fragment access$getCurrentFragment(ImagePickerActivity $this) {
        return $this.getCurrentFragment();
    }

    public static final /* synthetic */ void access$configSelectAllButtons(ImagePickerActivity $this, Long bucketId, ArrayList images, ArrayList selectedImages) {
        $this.configSelectAllButtons(bucketId, images, selectedImages);
    }

    public static final /* synthetic */ ImagePickerViewModel access$getViewModel$p(ImagePickerActivity $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ ImagepickerActivityImagepickerBinding access$getBinding$p(ImagePickerActivity $this) {
        return $this.binding;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PermissionHelper.STATUS.values().length];
            try {
                nArray[PermissionHelper.STATUS.GRANTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionHelper.STATUS.NOT_GRANTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionHelper.STATUS.DENIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SelectionState.values().length];
            try {
                nArray[SelectionState.SELECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

