/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Application;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.model.CallbackStatus;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.model.Result;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\r\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R0\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00150\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "contextRef", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "job", "Lkotlinx/coroutines/Job;", "result", "Landroidx/lifecycle/MutableLiveData;", "Lcom/nguyenhoanglam/imagepicker/model/Result;", "getResult", "()Landroidx/lifecycle/MutableLiveData;", "selectedImages", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "getSelectedImages", "setSelectedImages", "(Landroidx/lifecycle/MutableLiveData;)V", "fetchImages", "", "fetchImagesFromExternalStorage", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConfig", "setConfig", "imagepicker_release"})
public final class ImagePickerViewModel
extends AndroidViewModel {
    @NotNull
    private final WeakReference<Context> contextRef;
    private ImagePickerConfig config;
    @Nullable
    private Job job;
    public MutableLiveData<ArrayList<Image>> selectedImages;
    @NotNull
    private final MutableLiveData<Result> result;

    public ImagePickerViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.contextRef = new WeakReference<Context>(application.getApplicationContext());
        this.result = new MutableLiveData((Object)new Result(CallbackStatus.IDLE.INSTANCE, new ArrayList<Image>()));
    }

    @NotNull
    public final MutableLiveData<ArrayList<Image>> getSelectedImages() {
        MutableLiveData<ArrayList<Image>> mutableLiveData = this.selectedImages;
        if (mutableLiveData != null) {
            return mutableLiveData;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"selectedImages");
        return null;
    }

    public final void setSelectedImages(@NotNull MutableLiveData<ArrayList<Image>> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.selectedImages = mutableLiveData;
    }

    @NotNull
    public final MutableLiveData<Result> getResult() {
        return this.result;
    }

    public final void setConfig(@NotNull ImagePickerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.setSelectedImages((MutableLiveData<ArrayList<Image>>)new MutableLiveData(config.getSelectedImages()));
    }

    @NotNull
    public final ImagePickerConfig getConfig() {
        ImagePickerConfig imagePickerConfig = this.config;
        if (imagePickerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        }
        return imagePickerConfig;
    }

    public final void fetchImages() {
        if (this.job != null) {
            return;
        }
        this.result.postValue((Object)new Result(CallbackStatus.FETCHING.INSTANCE, new ArrayList<Image>()));
        this.job = BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ImagePickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ImagePickerViewModel.access$fetchImagesFromExternalStorage(this.this$0, (Continuation)this);
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            images = (ArrayList)v0;
                            this.this$0.getResult().postValue((Object)new Result(CallbackStatus.SUCCESS.INSTANCE, images));
                        }
                        catch (Exception var2_4) {
                            this.this$0.getResult().postValue((Object)new Result(CallbackStatus.SUCCESS.INSTANCE, new ArrayList<Image>()));
                            ** GOTO lbl30
                        }
                        ImagePickerViewModel.access$setJob$p(this.this$0, null);
                        ** GOTO lbl30
                    }
                    {
                        finally {
                            ImagePickerViewModel.access$setJob$p(this.this$0, null);
                        }
                    }
lbl30:
                    // 2 sources

                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object fetchImagesFromExternalStorage(Continuation<? super ArrayList<Image>> $completion) {
        if (this.contextRef.get() == null) {
            return new ArrayList();
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ArrayList<Image>>, Object>(this, null){
            int label;
            final /* synthetic */ ImagePickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ArrayList<Image> arrayList;
                        void var2_3;
                        ResultKt.throwOnFailure((Object)object);
                        String[] stringArray = new String[]{"_id", "_display_name", "bucket_id", "bucket_display_name"};
                        String[] projection = stringArray;
                        Uri imageCollectionUri = ImageHelper.INSTANCE.getImageCollectionUri();
                        T t = ImagePickerViewModel.access$getContextRef$p(this.this$0).get();
                        Intrinsics.checkNotNull(t);
                        Cursor cursor = ((Context)t).getContentResolver().query(imageCollectionUri, (String[])var2_3, null, null, "date_added DESC");
                        if (cursor != null) {
                            Closeable closeable = (Closeable)cursor;
                            Throwable throwable = null;
                            try {
                                Cursor cursor2 = (Cursor)closeable;
                                boolean bl = false;
                                ArrayList<Image> images = new ArrayList<Image>();
                                int idColumn = cursor2.getColumnIndexOrThrow("_id");
                                int nameColumn = cursor2.getColumnIndexOrThrow("_display_name");
                                int bucketIdColumn = cursor2.getColumnIndexOrThrow("bucket_id");
                                int bucketNameColumn = cursor2.getColumnIndex("bucket_display_name");
                                while (cursor2.moveToNext()) {
                                    Uri uri;
                                    long id2 = cursor2.getLong(idColumn);
                                    String name = cursor2.getString(nameColumn);
                                    long bucketId = cursor2.getLong(bucketIdColumn);
                                    Cursor $this$getStringOrNull$iv = cursor2;
                                    boolean $i$f$getStringOrNull = false;
                                    String string2 = $this$getStringOrNull$iv.isNull(bucketNameColumn) ? null : $this$getStringOrNull$iv.getString(bucketNameColumn);
                                    if (string2 == null) {
                                        string2 = "";
                                    }
                                    String bucketName = string2;
                                    Intrinsics.checkNotNullExpressionValue((Object)ContentUris.withAppendedId((Uri)imageCollectionUri, (long)id2), (String)"withAppendedId(imageCollectionUri, id)");
                                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                                    Image image = new Image(uri, name, bucketId, bucketName);
                                    images.add(image);
                                }
                                cursor2.close();
                                arrayList = images;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        } else {
                            throw new IOException();
                        }
                        return arrayList;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ArrayList<Image>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ Object access$fetchImagesFromExternalStorage(ImagePickerViewModel $this, Continuation $completion) {
        return $this.fetchImagesFromExternalStorage((Continuation<? super ArrayList<Image>>)$completion);
    }

    public static final /* synthetic */ void access$setJob$p(ImagePickerViewModel $this, Job job) {
        $this.job = job;
    }

    public static final /* synthetic */ WeakReference access$getContextRef$p(ImagePickerViewModel $this) {
        return $this.contextRef;
    }
}

