/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.camera;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import androidx.core.content.FileProvider;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import com.nguyenhoanglam.imagepicker.helper.ExifUtil;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.model.RootDirectory;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u001e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraModule;", "Ljava/io/Serializable;", "()V", "currentFileName", "", "currentFilePath", "currentFileUri", "Landroid/net/Uri;", "createImageFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "rootDirectory", "subDirectory", "deleteFileFromUri", "", "uri", "getBitmapFromUri", "Landroid/graphics/Bitmap;", "contentResolver", "Landroid/content/ContentResolver;", "getCameraIntent", "Landroid/content/Intent;", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "grantAppPermission", "intent", "fileUri", "reset", "revokeAppPermission", "saveImage", "imageReadyListener", "Lcom/nguyenhoanglam/imagepicker/ui/camera/OnImageReadyListener;", "Companion", "imagepicker_release"})
public final class CameraModule
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Uri currentFileUri;
    @Nullable
    private String currentFilePath;
    @Nullable
    private String currentFileName;
    @NotNull
    public static final String SUFFIX = ".jpg";

    @Nullable
    public final Intent getCameraIntent(@NotNull Context context, @NotNull ImagePickerConfig config) {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        try {
            String string2 = config.getRootDirectory().getValue();
            String string3 = config.getSubDirectory();
            Intrinsics.checkNotNull((Object)string3);
            file = this.createImageFile(context, string2, string3);
        }
        catch (IOException e) {
            file = null;
        }
        File imageFile = file;
        if (imageFile != null) {
            String providerName = context.getPackageName() + ".fileprovider";
            Uri uri = FileProvider.getUriForFile((Context)context, (String)providerName, (File)imageFile);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getUriForFile(context, providerName, imageFile)");
            Uri imageUri = uri;
            intent.putExtra("output", (Parcelable)imageUri);
            intent.addFlags(3);
            this.grantAppPermission(context, intent, imageUri);
            this.currentFileUri = imageUri;
            this.currentFilePath = imageFile.getAbsolutePath();
            return intent;
        }
        return null;
    }

    private final File createImageFile(Context context, String rootDirectory, String subDirectory) {
        File rootDir;
        File file = rootDir = DeviceHelper.INSTANCE.isMinSdk29() ? context.getExternalFilesDir(rootDirectory) : Environment.getExternalStoragePublicDirectory((String)rootDirectory);
        if (rootDir == null) {
            return null;
        }
        File storageDir = new File(rootDir, subDirectory);
        boolean isDirExisted = storageDir.exists();
        if (!isDirExisted) {
            isDirExisted = storageDir.mkdirs();
        }
        if (isDirExisted) {
            String filePrefix;
            String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(\"yyyyMMdd_HHmmss\").format(Date())");
            String timeStamp = string2;
            this.currentFileName = filePrefix = "IMG_" + timeStamp;
            return File.createTempFile(filePrefix, SUFFIX, storageDir);
        }
        return null;
    }

    public final void saveImage(@NotNull Context context, @NotNull ImagePickerConfig config, @NotNull OnImageReadyListener imageReadyListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)imageReadyListener, (String)"imageReadyListener");
        if (this.currentFileUri == null) {
            imageReadyListener.onImageNotReady();
            this.reset(context);
        }
        ContentResolver contentResolver = context.getContentResolver();
        Uri newFileUri = null;
        try {
            if (DeviceHelper.INSTANCE.isMinSdk29()) {
                ContentValues contentValues;
                String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(\"yyyyMMdd_HHmmss\").format(Date())");
                String timeStamp = string2;
                String filePrefix = "IMG_" + timeStamp;
                String fileName = filePrefix + SUFFIX;
                String relativePath = config.getRootDirectory().getValue() + File.separator + config.getSubDirectory();
                this.currentFileName = filePrefix;
                ContentValues $this$saveImage_u24lambda_u240 = contentValues = new ContentValues();
                boolean bl = false;
                $this$saveImage_u24lambda_u240.put("_display_name", fileName);
                $this$saveImage_u24lambda_u240.put("mime_type", "image/jpeg");
                $this$saveImage_u24lambda_u240.put("relative_path", relativePath);
                ContentValues values = contentValues;
                Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"contentResolver");
                Uri uri = this.currentFileUri;
                Intrinsics.checkNotNull((Object)uri);
                Bitmap bitmap = this.getBitmapFromUri(contentResolver, uri);
                Bitmap orientedBitmap = ExifUtil.INSTANCE.rotateBitmap(this.currentFilePath, bitmap);
                ContentResolver $this$saveImage_u24lambda_u241 = contentResolver;
                boolean bl2 = false;
                Uri url = config.getRootDirectory() == RootDirectory.DOWNLOADS ? MediaStore.Downloads.EXTERNAL_CONTENT_URI : MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                newFileUri = contentResolver.insert(url, values);
                if (newFileUri != null) {
                    OutputStream imageOutputStream = $this$saveImage_u24lambda_u241.openOutputStream(newFileUri);
                    orientedBitmap.compress(Bitmap.CompressFormat.JPEG, 100, imageOutputStream);
                    Object[] objectArray = new Image[1];
                    String string3 = this.currentFileName;
                    Intrinsics.checkNotNull((Object)string3);
                    String string4 = config.getSubDirectory();
                    Intrinsics.checkNotNull((Object)string4);
                    objectArray[0] = new Image(newFileUri, string3, 0L, string4);
                    ArrayList images = CollectionsKt.arrayListOf((Object[])objectArray);
                    imageReadyListener.onImageReady(images);
                } else {
                    imageReadyListener.onImageNotReady();
                }
                this.reset(context);
            } else {
                String[] timeStamp = new String[]{this.currentFilePath};
                MediaScannerConnection.scanFile((Context)context, (String[])timeStamp, null, (arg_0, arg_1) -> CameraModule.saveImage$lambda$2(this, config, imageReadyListener, context, arg_0, arg_1));
            }
        }
        catch (Exception e) {
            Uri uri = newFileUri;
            if (uri != null) {
                Uri it = uri;
                boolean bl = false;
                contentResolver.delete(it, null, null);
            }
            imageReadyListener.onImageNotReady();
            this.reset(context);
        }
    }

    private final void reset(Context context) {
        if (this.currentFileUri != null) {
            if (DeviceHelper.INSTANCE.isMinSdk29()) {
                Uri uri = this.currentFileUri;
                Intrinsics.checkNotNull((Object)uri);
                this.deleteFileFromUri(context, uri);
            }
            Uri uri = this.currentFileUri;
            Intrinsics.checkNotNull((Object)uri);
            this.revokeAppPermission(context, uri);
        }
        this.currentFileUri = null;
        this.currentFilePath = null;
        this.currentFileName = null;
    }

    private final void deleteFileFromUri(Context context, Uri uri) {
        context.getContentResolver().delete(uri, null, null);
    }

    private final void grantAppPermission(Context context, Intent intent, Uri fileUri) {
        List list = context.getPackageManager().queryIntentActivities(intent, 65536);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.packageManager.q\u2026nager.MATCH_DEFAULT_ONLY)");
        List resolvedIntentActivities = list;
        for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
            String packageName = resolvedIntentInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, fileUri, 3);
        }
    }

    private final void revokeAppPermission(Context context, Uri fileUri) {
        context.revokeUriPermission(fileUri, 3);
    }

    private final Bitmap getBitmapFromUri(ContentResolver contentResolver, Uri uri) {
        InputStream inputStream = contentResolver.openInputStream(uri);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        InputStream inputStream2 = inputStream;
        if (inputStream2 != null) {
            inputStream2.close();
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private static final void saveImage$lambda$2(CameraModule this$0, ImagePickerConfig $config, OnImageReadyListener $imageReadyListener, Context $context, String string2, Uri uri) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$imageReadyListener, (String)"$imageReadyListener");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Object[] objectArray = new Image[1];
        Uri uri2 = this$0.currentFileUri;
        Intrinsics.checkNotNull((Object)uri2);
        String string3 = this$0.currentFileName;
        Intrinsics.checkNotNull((Object)string3);
        String string4 = $config.getSubDirectory();
        Intrinsics.checkNotNull((Object)string4);
        objectArray[0] = new Image(uri2, string3, 0L, string4);
        ArrayList images = CollectionsKt.arrayListOf((Object[])objectArray);
        $imageReadyListener.onImageReady(images);
        this$0.reset($context);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/camera/CameraModule$Companion;", "", "()V", "SUFFIX", "", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

