/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Application;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.databinding.ImagepickerFragmentBinding;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.LayoutManagerHelper;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.model.CallbackStatus;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.GridCount;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.model.Result;
import com.nguyenhoanglam.imagepicker.ui.adapter.FolderPickerAdapter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.BaseFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModel;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModelFactory;
import com.nguyenhoanglam.imagepicker.widget.GridSpacingItemDecoration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/FolderFragment;", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/BaseFragment;", "()V", "_binding", "Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerFragmentBinding;", "binding", "getBinding", "()Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerFragmentBinding;", "folderAdapter", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/FolderPickerAdapter;", "gridCount", "Lcom/nguyenhoanglam/imagepicker/model/GridCount;", "gridLayoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "itemDecoration", "Lcom/nguyenhoanglam/imagepicker/widget/GridSpacingItemDecoration;", "viewModel", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "handleOnConfigurationChanged", "", "handleResult", "result", "Lcom/nguyenhoanglam/imagepicker/model/Result;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroyView", "Companion", "imagepicker_release"})
public final class FolderFragment
extends BaseFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ImagepickerFragmentBinding _binding;
    private GridCount gridCount;
    @Nullable
    private ImagePickerViewModel viewModel;
    private FolderPickerAdapter folderAdapter;
    private GridLayoutManager gridLayoutManager;
    private GridSpacingItemDecoration itemDecoration;
    @NotNull
    public static final String GRID_COUNT = "GridCount";

    private final ImagepickerFragmentBinding getBinding() {
        ImagepickerFragmentBinding imagepickerFragmentBinding = this._binding;
        Intrinsics.checkNotNull((Object)imagepickerFragmentBinding);
        return imagepickerFragmentBinding;
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        ImagePickerViewModel imagePickerViewModel;
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        GridCount gridCount = bundle != null ? (GridCount)bundle.getParcelable(GRID_COUNT) : null;
        Intrinsics.checkNotNull((Object)gridCount);
        this.gridCount = gridCount;
        FolderFragment folderFragment = this;
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity != null) {
            void $this$onCreate_u24lambda_u2d0;
            FragmentActivity fragmentActivity2 = fragmentActivity;
            FolderFragment folderFragment2 = folderFragment;
            boolean bl = false;
            ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)$this$onCreate_u24lambda_u2d0;
            Application application = this.requireActivity().getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"requireActivity().application");
            imagePickerViewModel = (ImagePickerViewModel)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new ImagePickerViewModelFactory(application)).get(ImagePickerViewModel.class);
            folderFragment = folderFragment2;
        } else {
            imagePickerViewModel = null;
        }
        folderFragment.viewModel = imagePickerViewModel;
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        ImagepickerFragmentBinding imagepickerFragmentBinding;
        GridLayoutManager gridLayoutManager;
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        Intrinsics.checkNotNull((Object)((Object)imagePickerViewModel));
        ImagePickerConfig config = imagePickerViewModel.getConfig();
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        FragmentActivity fragmentActivity2 = this.getActivity();
        if (fragmentActivity2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener");
        }
        this.folderAdapter = new FolderPickerAdapter((Context)fragmentActivity, (OnFolderClickListener)fragmentActivity2);
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        GridCount gridCount = this.gridCount;
        if (gridCount == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridCount");
            gridCount = null;
        }
        if ((gridLayoutManager = (this.gridLayoutManager = LayoutManagerHelper.INSTANCE.newInstance(context, gridCount))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            gridLayoutManager = null;
        }
        this.itemDecoration = new GridSpacingItemDecoration(gridLayoutManager.getSpanCount(), (int)this.getResources().getDimension(R.dimen.imagepicker_grid_spacing));
        this._binding = ImagepickerFragmentBinding.inflate(inflater, container, false);
        ImagepickerFragmentBinding $this$onCreateView_u24lambda_u2d2 = imagepickerFragmentBinding = this.getBinding();
        boolean bl = false;
        $this$onCreateView_u24lambda_u2d2.getRoot().setBackgroundColor(Color.parseColor((String)config.getBackgroundColor()));
        Object object = new int[]{Color.parseColor((String)config.getProgressIndicatorColor())};
        $this$onCreateView_u24lambda_u2d2.progressIndicator.setIndicatorColor(object);
        Object $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1 = object = (Object)$this$onCreateView_u24lambda_u2d2.recyclerView;
        boolean bl2 = false;
        $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1.setHasFixedSize(true);
        GridLayoutManager gridLayoutManager2 = this.gridLayoutManager;
        if (gridLayoutManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            gridLayoutManager2 = null;
        }
        $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager2);
        GridSpacingItemDecoration gridSpacingItemDecoration = this.itemDecoration;
        if (gridSpacingItemDecoration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
            gridSpacingItemDecoration = null;
        }
        $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1.addItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration);
        FolderPickerAdapter folderPickerAdapter = this.folderAdapter;
        if (folderPickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"folderAdapter");
            folderPickerAdapter = null;
        }
        $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1.setAdapter((RecyclerView.Adapter)folderPickerAdapter);
        MutableLiveData<Result> mutableLiveData = this.viewModel;
        if (mutableLiveData != null && (mutableLiveData = mutableLiveData.getResult()) != null) {
            mutableLiveData.observe(this.getViewLifecycleOwner(), arg_0 -> FolderFragment.onCreateView$lambda-3(this, arg_0));
        }
        FrameLayout frameLayout = this.getBinding().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
        return (View)frameLayout;
    }

    private final void handleResult(Result result) {
        ImagepickerFragmentBinding imagepickerFragmentBinding;
        if (result.getStatus() instanceof CallbackStatus.SUCCESS && !((Collection)result.getImages()).isEmpty()) {
            List<Folder> folders = ImageHelper.INSTANCE.folderListFromImages((List<Image>)result.getImages());
            FolderPickerAdapter folderPickerAdapter = this.folderAdapter;
            if (folderPickerAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"folderAdapter");
                folderPickerAdapter = null;
            }
            folderPickerAdapter.setData(folders);
            this.getBinding().recyclerView.setVisibility(0);
        } else {
            this.getBinding().recyclerView.setVisibility(8);
        }
        ImagepickerFragmentBinding $this$handleResult_u24lambda_u2d4 = imagepickerFragmentBinding = this.getBinding();
        boolean bl = false;
        $this$handleResult_u24lambda_u2d4.emptyText.setVisibility(result.getStatus() instanceof CallbackStatus.SUCCESS && result.getImages().isEmpty() ? 0 : 8);
        $this$handleResult_u24lambda_u2d4.progressIndicator.setVisibility(result.getStatus() instanceof CallbackStatus.FETCHING ? 0 : 8);
    }

    @Override
    public void handleOnConfigurationChanged() {
        RecyclerView recyclerView = this.getBinding().recyclerView;
        GridSpacingItemDecoration gridSpacingItemDecoration = this.itemDecoration;
        if (gridSpacingItemDecoration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
            gridSpacingItemDecoration = null;
        }
        recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration);
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        GridCount gridCount = this.gridCount;
        if (gridCount == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridCount");
            gridCount = null;
        }
        int newSpanCount = LayoutManagerHelper.INSTANCE.getSpanCountForCurrentConfiguration(context, gridCount);
        GridLayoutManager gridLayoutManager = this.gridLayoutManager;
        if (gridLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            gridLayoutManager = null;
        }
        this.itemDecoration = new GridSpacingItemDecoration(gridLayoutManager.getSpanCount(), (int)this.getResources().getDimension(R.dimen.imagepicker_grid_spacing));
        GridLayoutManager gridLayoutManager2 = this.gridLayoutManager;
        if (gridLayoutManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            gridLayoutManager2 = null;
        }
        gridLayoutManager2.setSpanCount(newSpanCount);
        RecyclerView recyclerView2 = this.getBinding().recyclerView;
        GridSpacingItemDecoration gridSpacingItemDecoration2 = this.itemDecoration;
        if (gridSpacingItemDecoration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
            gridSpacingItemDecoration2 = null;
        }
        recyclerView2.addItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration2);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this._binding = null;
    }

    private static final void onCreateView$lambda-3(FolderFragment this$0, Result it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleResult(it);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/FolderFragment$Companion;", "", "()V", "GRID_COUNT", "", "newInstance", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/FolderFragment;", "gridCount", "Lcom/nguyenhoanglam/imagepicker/model/GridCount;", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FolderFragment newInstance(@NotNull GridCount gridCount) {
            Intrinsics.checkNotNullParameter((Object)gridCount, (String)"gridCount");
            FolderFragment fragment = new FolderFragment();
            Bundle args = new Bundle();
            args.putParcelable(FolderFragment.GRID_COUNT, (Parcelable)gridCount);
            fragment.setArguments(args);
            return fragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

