/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.helper.GlideHelper;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.adapter.BaseRecyclerViewAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0014\u0010\u0015\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/adapter/FolderPickerAdapter;", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/BaseRecyclerViewAdapter;", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/FolderPickerAdapter$FolderViewHolder;", "context", "Landroid/content/Context;", "itemClickListener", "Lcom/nguyenhoanglam/imagepicker/listener/OnFolderClickListener;", "(Landroid/content/Context;Lcom/nguyenhoanglam/imagepicker/listener/OnFolderClickListener;)V", "folders", "", "Lcom/nguyenhoanglam/imagepicker/model/Folder;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "", "FolderViewHolder", "imagepicker_release"})
public final class FolderPickerAdapter
extends BaseRecyclerViewAdapter<FolderViewHolder> {
    @NotNull
    private final OnFolderClickListener itemClickListener;
    @NotNull
    private final List<Folder> folders;

    public FolderPickerAdapter(@NotNull Context context, @NotNull OnFolderClickListener itemClickListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)itemClickListener, (String)"itemClickListener");
        super(context);
        this.itemClickListener = itemClickListener;
        boolean bl = false;
        this.folders = new ArrayList();
    }

    @NotNull
    public FolderViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View itemView = this.getInflater().inflate(R.layout.imagepicker_item_folder, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return new FolderViewHolder(itemView);
    }

    public void onBindViewHolder(@NotNull FolderViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Folder folder = this.folders.get(position);
        int count = folder.getImages().size();
        Image image = folder.getImages().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)image, (String)"folder.images[0]");
        Image previewImage = image;
        GlideHelper.Companion.loadImage(holder.getImage(), previewImage.getUri());
        holder.getName().setText((CharSequence)folder.getName());
        holder.getCount().setText((CharSequence)String.valueOf(count));
        holder.itemView.setOnClickListener(arg_0 -> FolderPickerAdapter.onBindViewHolder$lambda-0(this, folder, arg_0));
    }

    public final void setData(@NotNull List<Folder> folders) {
        Intrinsics.checkNotNullParameter(folders, (String)"folders");
        this.folders.clear();
        this.folders.addAll((Collection<Folder>)folders);
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.folders.size();
    }

    private static final void onBindViewHolder$lambda-0(FolderPickerAdapter this$0, Folder $folder, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$folder, (String)"$folder");
        this$0.itemClickListener.onFolderClick($folder);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/adapter/FolderPickerAdapter$FolderViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "count", "Landroid/widget/TextView;", "getCount", "()Landroid/widget/TextView;", "image", "Landroid/widget/ImageView;", "getImage", "()Landroid/widget/ImageView;", "name", "getName", "imagepicker_release"})
    public static final class FolderViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView image;
        @NotNull
        private final TextView name;
        @NotNull
        private final TextView count;

        public FolderViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.image_folder_thumbnail);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.image_folder_thumbnail)");
            this.image = (ImageView)view;
            view = itemView.findViewById(R.id.text_folder_name);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.text_folder_name)");
            this.name = (TextView)view;
            view = itemView.findViewById(R.id.text_photo_count);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.text_photo_count)");
            this.count = (TextView)view;
        }

        @NotNull
        public final ImageView getImage() {
            return this.image;
        }

        @NotNull
        public final TextView getName() {
            return this.name;
        }

        @NotNull
        public final TextView getCount() {
            return this.count;
        }
    }
}

