/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.core.view.ViewCompat;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import com.nguyenhoanglam.imagepicker.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\tH\u0002J\u0016\u0010\"\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/nguyenhoanglam/imagepicker/widget/SnackBarView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "actionButton", "Landroid/widget/Button;", "<set-?>", "", "isShowing", "()Z", "messageText", "Landroid/widget/TextView;", "convertDpToPixels", "dp", "", "hide", "", "runnable", "Ljava/lang/Runnable;", "init", "setOnActionClickListener", "actionText", "", "onClickListener", "Landroid/view/View$OnClickListener;", "setText", "textResId", "show", "Companion", "imagepicker_release"})
public final class SnackBarView
extends RelativeLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private TextView messageText;
    private Button actionButton;
    private boolean isShowing;
    private static final int ANIM_DURATION = 200;
    @NotNull
    private static final Interpolator INTERPOLATOR = (Interpolator)new FastOutLinearInInterpolator();

    public final boolean isShowing() {
        return this.isShowing;
    }

    public SnackBarView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.init(context);
    }

    public SnackBarView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.init(context);
    }

    public SnackBarView(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private final void init(Context context) {
        View.inflate((Context)context, (int)R.layout.imagepicker_snackbar, (ViewGroup)((ViewGroup)this));
        if (this.isInEditMode()) {
            return;
        }
        this.setBackgroundColor(Color.parseColor((String)"#323232"));
        this.setTranslationY(this.getHeight());
        this.setAlpha(0.0f);
        this.isShowing = false;
        int horizontalPadding = this.convertDpToPixels(context, 24.0f);
        int verticalPadding = this.convertDpToPixels(context, 14.0f);
        this.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        View view = this.findViewById(R.id.text_snackbar_message);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.text_snackbar_message)");
        this.messageText = (TextView)view;
        view = this.findViewById(R.id.button_snackbar_action);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.button_snackbar_action)");
        this.actionButton = (Button)view;
    }

    private final void setText(int textResId) {
        TextView textView;
        TextView textView2 = this.messageText;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageText");
            textView = null;
        } else {
            textView = textView2;
        }
        textView.setText(textResId);
    }

    private final void setOnActionClickListener(String actionText, View.OnClickListener onClickListener) {
        Button button;
        Button button2;
        Button button3 = this.actionButton;
        if (button3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actionButton");
            button2 = null;
        } else {
            button2 = button3;
        }
        button2.setText((CharSequence)actionText);
        button3 = this.actionButton;
        if (button3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"actionButton");
            button = null;
        } else {
            button = button3;
        }
        button.setOnClickListener(arg_0 -> SnackBarView.setOnActionClickListener$lambda-1(this, onClickListener, arg_0));
    }

    public final void show(int textResId, @NotNull View.OnClickListener onClickListener) {
        Intrinsics.checkNotNullParameter((Object)onClickListener, (String)"onClickListener");
        this.setText(textResId);
        String string2 = this.getContext().getString(R.string.imagepicker_action_ok);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.imagepicker_action_ok)");
        this.setOnActionClickListener(string2, onClickListener);
        ViewCompat.animate((View)((View)this)).translationY(0.0f).setDuration(200L).setInterpolator(INTERPOLATOR).alpha(1.0f);
        this.isShowing = true;
    }

    private final void hide(Runnable runnable) {
        ViewCompat.animate((View)((View)this)).translationY((float)this.getHeight()).setDuration(200L).alpha(0.5f).withEndAction(runnable);
        this.isShowing = false;
    }

    private final int convertDpToPixels(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private static final void setOnActionClickListener$lambda-1$lambda-0(View.OnClickListener $onClickListener, View $view) {
        Intrinsics.checkNotNullParameter((Object)$onClickListener, (String)"$onClickListener");
        $onClickListener.onClick($view);
    }

    private static final void setOnActionClickListener$lambda-1(SnackBarView this$0, View.OnClickListener $onClickListener, View view) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onClickListener, (String)"$onClickListener");
        this$0.hide(() -> SnackBarView.setOnActionClickListener$lambda-1$lambda-0($onClickListener, view));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/nguyenhoanglam/imagepicker/widget/SnackBarView$Companion;", "", "()V", "ANIM_DURATION", "", "INTERPOLATOR", "Landroid/view/animation/Interpolator;", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

