/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Application;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.model.CallbackStatus;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.model.Result;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\r\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R0\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00150\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "contextRef", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "job", "Lkotlinx/coroutines/Job;", "result", "Landroidx/lifecycle/MutableLiveData;", "Lcom/nguyenhoanglam/imagepicker/model/Result;", "getResult", "()Landroidx/lifecycle/MutableLiveData;", "selectedImages", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "getSelectedImages", "setSelectedImages", "(Landroidx/lifecycle/MutableLiveData;)V", "fetchImages", "", "fetchImagesFromExternalStorage", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConfig", "setConfig", "imagepicker_release"})
public final class ImagePickerViewModel
extends AndroidViewModel {
    @NotNull
    private final WeakReference<Context> contextRef;
    private ImagePickerConfig config;
    @Nullable
    private Job job;
    public MutableLiveData<ArrayList<Image>> selectedImages;
    @NotNull
    private final MutableLiveData<Result> result;

    public ImagePickerViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.contextRef = new WeakReference<Context>(application.getApplicationContext());
        boolean bl = false;
        this.result = new MutableLiveData((Object)new Result(CallbackStatus.IDLE.INSTANCE, new ArrayList<Image>()));
    }

    @NotNull
    public final MutableLiveData<ArrayList<Image>> getSelectedImages() {
        MutableLiveData<ArrayList<Image>> mutableLiveData = this.selectedImages;
        if (mutableLiveData != null) {
            return mutableLiveData;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"selectedImages");
        return null;
    }

    public final void setSelectedImages(@NotNull MutableLiveData<ArrayList<Image>> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.selectedImages = mutableLiveData;
    }

    @NotNull
    public final MutableLiveData<Result> getResult() {
        return this.result;
    }

    public final void setConfig(@NotNull ImagePickerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.setSelectedImages((MutableLiveData<ArrayList<Image>>)new MutableLiveData(config.getSelectedImages()));
    }

    @NotNull
    public final ImagePickerConfig getConfig() {
        ImagePickerConfig imagePickerConfig;
        ImagePickerConfig imagePickerConfig2 = this.config;
        if (imagePickerConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            imagePickerConfig = null;
        } else {
            imagePickerConfig = imagePickerConfig2;
        }
        return imagePickerConfig;
    }

    public final void fetchImages() {
        if (this.job != null) {
            return;
        }
        boolean bl = false;
        this.result.postValue((Object)new Result(CallbackStatus.FETCHING.INSTANCE, new ArrayList<Image>()));
        this.job = BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ImagePickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ImagePickerViewModel.access$fetchImagesFromExternalStorage(this.this$0, (Continuation)this);
                        ** if (v0 != var4_2) goto lbl11
lbl10:
                        // 1 sources

                        return var4_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            images = (ArrayList)v0;
                            this.this$0.getResult().postValue((Object)new Result(CallbackStatus.SUCCESS.INSTANCE, images));
                        }
                        catch (Exception var2_4) {
                            var3_6 = false;
                            this.this$0.getResult().postValue((Object)new Result(CallbackStatus.SUCCESS.INSTANCE, new ArrayList<Image>()));
                            ** GOTO lbl31
                        }
                        ImagePickerViewModel.access$setJob$p(this.this$0, null);
                        ** GOTO lbl31
                    }
                    {
                        finally {
                            ImagePickerViewModel.access$setJob$p(this.this$0, null);
                        }
                    }
lbl31:
                    // 2 sources

                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object fetchImagesFromExternalStorage(Continuation<? super ArrayList<Image>> $completion) {
        if (this.contextRef.get() == null) {
            boolean bl = false;
            return new ArrayList();
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ArrayList<Image>>, Object>(this, null){
            int label;
            final /* synthetic */ ImagePickerViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var24_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = new String[]{"_id", "_display_name", "bucket_id", "bucket_display_name"};
                        projection = var3_3;
                        imageCollectionUri = ImageHelper.INSTANCE.getImageCollectionUri();
                        v0 = ImagePickerViewModel.access$getContextRef$p(this.this$0).get();
                        Intrinsics.checkNotNull(v0);
                        var5_5 = ((Context)v0).getContentResolver().query(imageCollectionUri, (String[])var2_4, null, null, "date_added DESC");
                        if (var5_5 != null) ** GOTO lbl14
                        v1 = null;
                        ** GOTO lbl52
lbl14:
                        // 1 sources

                        var6_6 = (Closeable)var5_5;
                        var7_7 = false;
                        var8_8 = false;
                        var8_9 = null;
                        try {
                            cursor = (Cursor)var6_6;
                            $i$a$-use-ImagePickerViewModel$fetchImagesFromExternalStorage$2$1 = false;
                            var11_14 = false;
                            images = new ArrayList<Image>();
                            idColumn = cursor.getColumnIndexOrThrow("_id");
                            nameColumn = cursor.getColumnIndexOrThrow("_display_name");
                            bucketIdColumn = cursor.getColumnIndexOrThrow("bucket_id");
                            bucketNameColumn = cursor.getColumnIndex("bucket_display_name");
                            while (cursor.moveToNext()) {
                                id = cursor.getLong(idColumn);
                                name = cursor.getString(nameColumn);
                                bucketId = cursor.getLong(bucketIdColumn);
                                bucketName = cursor.getString(bucketNameColumn);
                                var22_23 = ContentUris.withAppendedId((Uri)imageCollectionUri, (long)id);
                                Intrinsics.checkNotNullExpressionValue((Object)var22_23, (String)"withAppendedId(imageCollectionUri, id)");
                                uri = var22_23;
                                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                                Intrinsics.checkNotNullExpressionValue((Object)bucketName, (String)"bucketName");
                                image = new Image(uri, name, bucketId, bucketName);
                                images.add(image);
                            }
                            cursor.close();
                            var9_10 = images;
                            v1 = var9_10;
                        }
                        catch (Throwable var9_11) {
                            var8_9 = var9_11;
                            throw var9_11;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var6_6, (Throwable)var8_9);
                        }
lbl52:
                        // 2 sources

                        var4_25 = v1;
                        if (var4_25 == null) {
                            throw new IOException();
                        }
                        return var4_25;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ArrayList<Image>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ Object access$fetchImagesFromExternalStorage(ImagePickerViewModel $this, Continuation $completion) {
        return $this.fetchImagesFromExternalStorage((Continuation<? super ArrayList<Image>>)$completion);
    }

    public static final /* synthetic */ void access$setJob$p(ImagePickerViewModel $this, Job job) {
        $this.job = job;
    }

    public static final /* synthetic */ WeakReference access$getContextRef$p(ImagePickerViewModel $this) {
        return $this.contextRef;
    }
}

