/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.helper.CameraHelper;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.LogHelper;
import com.nguyenhoanglam.imagepicker.helper.PermissionHelper;
import com.nguyenhoanglam.imagepicker.helper.ToastHelper;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.camera.DefaultCameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.BaseFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.FolderFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerActivity;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModel;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModelFactory;
import com.nguyenhoanglam.imagepicker.widget.ImagePickerToolbar;
import com.nguyenhoanglam.imagepicker.widget.SnackBarView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J \u0010\u0016\u001a\u00020\u00122\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aH\u0002J\"\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\b\u0010!\u001a\u00020\u0012H\u0016J\u0012\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010$H\u0014J\b\u0010%\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0016J+\u0010)\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u0012H\u0014J \u00101\u001a\u00020\u00122\u0016\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aH\u0016J\u0010\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0019H\u0016J\b\u00105\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/nguyenhoanglam/imagepicker/listener/OnFolderClickListener;", "Lcom/nguyenhoanglam/imagepicker/listener/OnImageSelectListener;", "()V", "backClickListener", "Landroid/view/View$OnClickListener;", "cameraClickListener", "cameraModule", "Lcom/nguyenhoanglam/imagepicker/ui/camera/DefaultCameraModule;", "config", "Lcom/nguyenhoanglam/imagepicker/model/Config;", "doneClickListener", "logger", "Lcom/nguyenhoanglam/imagepicker/helper/LogHelper;", "viewModel", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "captureImage", "", "captureImageWithPermission", "fetchData", "fetchDataWithPermission", "finishPickImages", "images", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDone", "onFolderClick", "folder", "Lcom/nguyenhoanglam/imagepicker/model/Folder;", "onRequestPermissionsResult", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "onSelectedImagesChanged", "selectedImages", "onSingleModeImageSelected", "image", "setupViews", "imagepicker_release"})
public final class ImagePickerActivity
extends AppCompatActivity
implements OnFolderClickListener,
OnImageSelectListener {
    private Config config;
    private ImagePickerViewModel viewModel;
    private final DefaultCameraModule cameraModule = new DefaultCameraModule();
    private final LogHelper logger = LogHelper.Companion.getInstance();
    private final View.OnClickListener backClickListener = new View.OnClickListener(this){
        final /* synthetic */ ImagePickerActivity this$0;

        public final void onClick(View it) {
            this.this$0.onBackPressed();
        }
        {
            this.this$0 = imagePickerActivity;
        }
    };
    private final View.OnClickListener cameraClickListener = new View.OnClickListener(this){
        final /* synthetic */ ImagePickerActivity this$0;

        public final void onClick(View it) {
            ImagePickerActivity.access$captureImageWithPermission(this.this$0);
        }
        {
            this.this$0 = imagePickerActivity;
        }
    };
    private final View.OnClickListener doneClickListener = new View.OnClickListener(this){
        final /* synthetic */ ImagePickerActivity this$0;

        public final void onClick(View it) {
            ImagePickerActivity.access$onDone(this.this$0);
        }
        {
            this.this$0 = imagePickerActivity;
        }
    };
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null) {
            this.finish();
            return;
        }
        this.config = (Config)this.getIntent().getParcelableExtra("ImagePickerConfig");
        this.setContentView(R.layout.imagepicker_activity_imagepicker);
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)this;
        Application application = this.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"this.application");
        ViewModel viewModel = new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new ImagePickerViewModelFactory(application)).get(ImagePickerViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"ViewModelProvider(this, \u2026kerViewModel::class.java)");
        ImagePickerViewModel imagePickerViewModel = this.viewModel = (ImagePickerViewModel)viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        Config config = this.config;
        if (config == null) {
            Intrinsics.throwNpe();
        }
        imagePickerViewModel.setConfig(config);
        ImagePickerViewModel imagePickerViewModel2 = this.viewModel;
        if (imagePickerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        imagePickerViewModel2.getSelectedImages().observe((LifecycleOwner)this, (Observer)new Observer<ArrayList<Image>>(this){
            final /* synthetic */ ImagePickerActivity this$0;

            /*
             * Unable to fully structure code
             */
            public final void onChanged(ArrayList<Image> it) {
                v0 = (ImagePickerToolbar)this.this$0._$_findCachedViewById(R.id.toolbar);
                v1 = ImagePickerActivity.access$getConfig$p(this.this$0);
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                if (v1.isAlwaysShowDoneButton()) ** GOTO lbl-1000
                v2 = it;
                Intrinsics.checkExpressionValueIsNotNull(v2, (String)"it");
                var2_2 = v2;
                var4_3 = v0;
                var3_4 = false;
                var5_5 = var2_2.isEmpty() == false;
                v0 = var4_3;
                if (var5_5) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                v0.showDoneButton(v3);
            }
            {
                this.this$0 = imagePickerActivity;
            }
        });
        this.setupViews();
    }

    protected void onResume() {
        super.onResume();
        this.fetchDataWithPermission();
    }

    private final void setupViews() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
            Config config = this.config;
            if (config == null) {
                Intrinsics.throwNpe();
            }
            window.setStatusBarColor(config.getStatusBarColor());
        }
        ImagePickerToolbar imagePickerToolbar = (ImagePickerToolbar)this._$_findCachedViewById(R.id.toolbar);
        Config config = this.config;
        if (config == null) {
            Intrinsics.throwNpe();
        }
        imagePickerToolbar.config(config);
        ((ImagePickerToolbar)this._$_findCachedViewById(R.id.toolbar)).setOnBackClickListener(this.backClickListener);
        ((ImagePickerToolbar)this._$_findCachedViewById(R.id.toolbar)).setOnCameraClickListener(this.cameraClickListener);
        ((ImagePickerToolbar)this._$_findCachedViewById(R.id.toolbar)).setOnDoneClickListener(this.doneClickListener);
        Config config2 = this.config;
        if (config2 == null) {
            Intrinsics.throwNpe();
        }
        BaseFragment initialFragment = config2.isFolderMode() ? (BaseFragment)FolderFragment.Companion.newInstance() : (BaseFragment)ImageFragment.Companion.newInstance();
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragmentContainer, (Fragment)initialFragment).commit();
    }

    private final void fetchDataWithPermission() {
        String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        PermissionHelper.INSTANCE.checkPermission((Activity)this, "android.permission.WRITE_EXTERNAL_STORAGE", new PermissionHelper.PermissionAskListener(this, permissions){
            final /* synthetic */ ImagePickerActivity this$0;
            final /* synthetic */ String[] $permissions;

            public void onNeedPermission() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 102);
            }

            public void onPermissionPreviouslyDenied() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 102);
            }

            public void onPermissionDisabled() {
                ((SnackBarView)this.this$0._$_findCachedViewById(R.id.snackbar)).show(R.string.imagepicker_msg_no_write_external_storage_permission, new View.OnClickListener(this){
                    final /* synthetic */ fetchDataWithPermission.1 this$0;

                    public final void onClick(View it) {
                        PermissionHelper.INSTANCE.openAppSettings((Activity)this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }

            public void onPermissionGranted() {
                ImagePickerActivity.access$fetchData(this.this$0);
            }
            {
                this.this$0 = $outer;
                this.$permissions = $captured_local_variable$1;
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        switch (requestCode) {
            case 102: {
                if (PermissionHelper.INSTANCE.hasGranted(grantResults)) {
                    LogHelper logHelper = this.logger;
                    if (logHelper != null) {
                        logHelper.d("Write External permission granted");
                    }
                    this.fetchData();
                    break;
                }
                LogHelper logHelper = this.logger;
                if (logHelper != null) {
                    logHelper.e("Permission not granted: results len = " + grantResults.length);
                }
                LogHelper logHelper2 = this.logger;
                if (logHelper2 != null) {
                    int[] nArray = grantResults;
                    StringBuilder stringBuilder = new StringBuilder().append("Result code = ");
                    LogHelper logHelper3 = logHelper2;
                    boolean bl = false;
                    int[] nArray2 = nArray;
                    boolean bl2 = false;
                    boolean bl3 = !(nArray2.length == 0);
                    logHelper3.e(stringBuilder.append(bl3 ? Integer.valueOf(grantResults[0]) : "(empty)").toString());
                }
                this.finish();
                break;
            }
            case 103: {
                if (PermissionHelper.INSTANCE.hasGranted(grantResults)) {
                    LogHelper logHelper = this.logger;
                    if (logHelper != null) {
                        logHelper.d("Camera permission granted");
                    }
                    this.captureImage();
                    break;
                }
                LogHelper logHelper = this.logger;
                if (logHelper != null) {
                    int[] nArray = grantResults;
                    StringBuilder stringBuilder = new StringBuilder().append("Permission not granted: results len = ").append(grantResults.length).append(" Result code = ");
                    LogHelper logHelper4 = logHelper;
                    boolean bl = false;
                    int[] nArray3 = nArray;
                    boolean bl4 = false;
                    boolean bl5 = !(nArray3.length == 0);
                    logHelper4.e(stringBuilder.append(bl5 ? Integer.valueOf(grantResults[0]) : "(empty)").toString());
                }
                break;
            }
            default: {
                LogHelper logHelper = this.logger;
                if (logHelper != null) {
                    logHelper.d("Got unexpected permission result: " + requestCode);
                }
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    private final void fetchData() {
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        imagePickerViewModel.fetchImages();
    }

    public void onBackPressed() {
        super.onBackPressed();
        Fragment fragment = this.getSupportFragmentManager().findFragmentById(R.id.fragmentContainer);
        if (fragment != null && fragment instanceof FolderFragment) {
            ImagePickerToolbar imagePickerToolbar = (ImagePickerToolbar)this._$_findCachedViewById(R.id.toolbar);
            Config config = this.config;
            if (config == null) {
                Intrinsics.throwNpe();
            }
            imagePickerToolbar.setTitle(config.getFolderTitle());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onDone() {
        ArrayList selectedImages;
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        if ((selectedImages = (ArrayList)imagePickerViewModel.getSelectedImages().getValue()) != null) {
            Collection collection = selectedImages;
            boolean bl = false;
            if (!collection.isEmpty()) {
                int i = 0;
                while (true) {
                    if (i >= selectedImages.size()) {
                        this.finishPickImages(selectedImages);
                        return;
                    }
                    Image image = (Image)selectedImages.get(i);
                    String path = image.component3();
                    File file = new File(path);
                    if (!file.exists()) {
                        selectedImages.remove(i);
                        --i;
                    }
                    ++i;
                }
            }
        }
        ImagePickerActivity imagePickerActivity = this;
        boolean bl = false;
        ArrayList<Image> arrayList = new ArrayList<Image>();
        imagePickerActivity.finishPickImages(arrayList);
    }

    private final void captureImageWithPermission() {
        String[] permissions = new String[]{"android.permission.CAMERA"};
        PermissionHelper.INSTANCE.checkPermission((Activity)this, "android.permission.CAMERA", new PermissionHelper.PermissionAskListener(this, permissions){
            final /* synthetic */ ImagePickerActivity this$0;
            final /* synthetic */ String[] $permissions;

            public void onNeedPermission() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 103);
            }

            public void onPermissionPreviouslyDenied() {
                PermissionHelper.INSTANCE.requestAllPermissions((Activity)this.this$0, this.$permissions, 103);
            }

            public void onPermissionDisabled() {
                ((SnackBarView)this.this$0._$_findCachedViewById(R.id.snackbar)).show(R.string.imagepicker_msg_no_camera_permission, new View.OnClickListener(this){
                    final /* synthetic */ captureImageWithPermission.1 this$0;

                    public final void onClick(View it) {
                        PermissionHelper.INSTANCE.openAppSettings((Activity)this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }

            public void onPermissionGranted() {
                this.this$0.captureImage();
            }
            {
                this.this$0 = $outer;
                this.$permissions = $captured_local_variable$1;
            }
        });
    }

    public final void captureImage() {
        Intent intent;
        if (!CameraHelper.INSTANCE.checkCameraAvailability((Context)this)) {
            return;
        }
        Context context = (Context)this;
        Config config = this.config;
        if (config == null) {
            Intrinsics.throwNpe();
        }
        if ((intent = this.cameraModule.getCameraIntent(context, config)) == null) {
            Context context2 = (Context)this;
            String string2 = this.getString(R.string.imagepicker_error_create_image_file);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.image\u2026_error_create_image_file)");
            ToastHelper.Companion.show$default(ToastHelper.Companion, context2, string2, 0, 4, null);
            return;
        }
        this.startActivityForResult(intent, 101);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 101 && resultCode == -1) {
            Context context = (Context)this;
            Config config = this.config;
            if (config == null) {
                Intrinsics.throwNpe();
            }
            this.cameraModule.getImage(context, config.isCameraOnly(), new OnImageReadyListener(this){
                final /* synthetic */ ImagePickerActivity this$0;

                public void onImageReady(@NotNull ArrayList<Image> images) {
                    Intrinsics.checkParameterIsNotNull(images, (String)"images");
                    ImagePickerActivity.access$fetchDataWithPermission(this.this$0);
                }

                public void onImageNotReady() {
                    LogHelper logHelper = ImagePickerActivity.access$getLogger$p(this.this$0);
                    if (logHelper != null) {
                        logHelper.e("Could not get captured image's path");
                    }
                    ImagePickerActivity.access$fetchDataWithPermission(this.this$0);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void finishPickImages(ArrayList<Image> images) {
        Intent data = new Intent();
        data.putParcelableArrayListExtra("ImagePickerImages", images);
        this.setResult(-1, data);
        this.finish();
    }

    @Override
    public void onFolderClick(@NotNull Folder folder) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        this.getSupportFragmentManager().beginTransaction().add(R.id.fragmentContainer, (Fragment)ImageFragment.Companion.newInstance(folder.getBucketId())).addToBackStack(null).commit();
        ((ImagePickerToolbar)this._$_findCachedViewById(R.id.toolbar)).setTitle(folder.getName());
    }

    @Override
    public void onSelectedImagesChanged(@NotNull ArrayList<Image> selectedImages) {
        Intrinsics.checkParameterIsNotNull(selectedImages, (String)"selectedImages");
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        imagePickerViewModel.getSelectedImages().setValue(selectedImages);
    }

    @Override
    public void onSingleModeImageSelected(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        this.finishPickImages(ImageHelper.INSTANCE.singleListFromImage(image));
    }

    public static final /* synthetic */ Config access$getConfig$p(ImagePickerActivity $this) {
        return $this.config;
    }

    public static final /* synthetic */ void access$setConfig$p(ImagePickerActivity $this, Config config) {
        $this.config = config;
    }

    public static final /* synthetic */ void access$fetchData(ImagePickerActivity $this) {
        $this.fetchData();
    }

    public static final /* synthetic */ void access$fetchDataWithPermission(ImagePickerActivity $this) {
        $this.fetchDataWithPermission();
    }

    public static final /* synthetic */ LogHelper access$getLogger$p(ImagePickerActivity $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$captureImageWithPermission(ImagePickerActivity $this) {
        $this.captureImageWithPermission();
    }

    public static final /* synthetic */ void access$onDone(ImagePickerActivity $this) {
        $this.onDone();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

