/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.adapter.BaseRecyclerViewAdapter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.GlideLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0014\u0010\u0017\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0018R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/adapter/FolderPickerAdapter;", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/BaseRecyclerViewAdapter;", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/FolderPickerAdapter$FolderViewHolder;", "context", "Landroid/content/Context;", "itemClickListener", "Lcom/nguyenhoanglam/imagepicker/listener/OnFolderClickListener;", "(Landroid/content/Context;Lcom/nguyenhoanglam/imagepicker/listener/OnFolderClickListener;)V", "folders", "", "Lcom/nguyenhoanglam/imagepicker/model/Folder;", "imageLoader", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/GlideLoader;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "", "FolderViewHolder", "imagepicker_release"})
public final class FolderPickerAdapter
extends BaseRecyclerViewAdapter<FolderViewHolder> {
    private final GlideLoader imageLoader;
    private final List<Folder> folders;
    private final OnFolderClickListener itemClickListener;

    @NotNull
    public FolderViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View itemView;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        View view = itemView = this.getInflater().inflate(R.layout.imagepicker_item_folder, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        return new FolderViewHolder(view);
    }

    public void onBindViewHolder(@NotNull FolderViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Folder folder = this.folders.get(position);
        int count = folder.getImages().size();
        Image image = folder.getImages().get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"folder.images[0]");
        Image previewImage = image;
        this.imageLoader.loadImage(previewImage.getId(), previewImage.getPath(), holder.getImage());
        holder.getName().setText((CharSequence)folder.getName());
        holder.getCount().setText((CharSequence)("" + count));
        holder.itemView.setOnClickListener(new View.OnClickListener(this, folder){
            final /* synthetic */ FolderPickerAdapter this$0;
            final /* synthetic */ Folder $folder;

            public final void onClick(View it) {
                FolderPickerAdapter.access$getItemClickListener$p(this.this$0).onFolderClick(this.$folder);
            }
            {
                this.this$0 = folderPickerAdapter;
                this.$folder = folder;
            }
        });
    }

    public final void setData(@NotNull List<Folder> folders) {
        Intrinsics.checkParameterIsNotNull(folders, (String)"folders");
        this.folders.clear();
        this.folders.addAll((Collection<Folder>)folders);
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.folders.size();
    }

    public FolderPickerAdapter(@NotNull Context context, @NotNull OnFolderClickListener itemClickListener) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)itemClickListener, (String)"itemClickListener");
        super(context);
        this.itemClickListener = itemClickListener;
        this.imageLoader = new GlideLoader();
        FolderPickerAdapter folderPickerAdapter = this;
        boolean bl = false;
        folderPickerAdapter.folders = list = (List)new ArrayList();
    }

    public static final /* synthetic */ OnFolderClickListener access$getItemClickListener$p(FolderPickerAdapter $this) {
        return $this.itemClickListener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/adapter/FolderPickerAdapter$FolderViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "count", "Landroid/widget/TextView;", "getCount", "()Landroid/widget/TextView;", "image", "Landroid/widget/ImageView;", "getImage", "()Landroid/widget/ImageView;", "name", "getName", "imagepicker_release"})
    public static final class FolderViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView image;
        @NotNull
        private final TextView name;
        @NotNull
        private final TextView count;

        @NotNull
        public final ImageView getImage() {
            return this.image;
        }

        @NotNull
        public final TextView getName() {
            return this.name;
        }

        @NotNull
        public final TextView getCount() {
            return this.count;
        }

        public FolderViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.image_folder_thumbnail);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.image_folder_thumbnail)");
            this.image = (ImageView)view;
            View view2 = itemView.findViewById(R.id.text_folder_name);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView.findViewById(R.id.text_folder_name)");
            this.name = (TextView)view2;
            View view3 = itemView.findViewById(R.id.text_photo_count);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView.findViewById(R.id.text_photo_count)");
            this.count = (TextView)view3;
        }
    }
}

