/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.model.Config;

public class ImagePickerToolbar
extends RelativeLayout {
    private TextView titleText;
    private TextView doneText;
    private AppCompatImageView backImage;
    private AppCompatImageView cameraImage;

    public ImagePickerToolbar(Context context) {
        super(context);
        this.init(context);
    }

    public ImagePickerToolbar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ImagePickerToolbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View.inflate((Context)context, (int)R.layout.imagepicker_toolbar, (ViewGroup)this);
        if (this.isInEditMode()) {
            return;
        }
        this.titleText = (TextView)this.findViewById(R.id.text_toolbar_title);
        this.doneText = (TextView)this.findViewById(R.id.text_toolbar_done);
        this.backImage = (AppCompatImageView)this.findViewById(R.id.image_toolbar_back);
        this.cameraImage = (AppCompatImageView)this.findViewById(R.id.image_toolbar_camera);
    }

    public void config(Config config) {
        this.setBackgroundColor(config.getToolbarColor());
        this.titleText.setText((CharSequence)(config.isFolderMode() ? config.getFolderTitle() : config.getImageTitle()));
        this.titleText.setTextColor(config.getToolbarTextColor());
        this.doneText.setText((CharSequence)config.getDoneTitle());
        this.doneText.setTextColor(config.getToolbarTextColor());
        this.backImage.setColorFilter(config.getToolbarIconColor());
        this.cameraImage.setColorFilter(config.getToolbarIconColor());
        this.cameraImage.setVisibility(config.isShowCamera() ? 0 : 8);
        this.doneText.setVisibility(8);
    }

    public void setTitle(String title) {
        this.titleText.setText((CharSequence)title);
    }

    public void showDoneButton(boolean isShow) {
        this.doneText.setVisibility(isShow ? 0 : 8);
    }

    public void setOnBackClickListener(View.OnClickListener clickListener) {
        this.backImage.setOnClickListener(clickListener);
    }

    public void setOnCameraClickListener(View.OnClickListener clickListener) {
        this.cameraImage.setOnClickListener(clickListener);
    }

    public void setOnDoneClickListener(View.OnClickListener clickListener) {
        this.doneText.setOnClickListener(clickListener);
    }
}

