/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraView;
import com.nguyenhoanglam.imagepicker.ui.camera.DefaultCameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import com.nguyenhoanglam.imagepicker.ui.common.BasePresenter;
import java.util.List;

public class CameraPresenter
extends BasePresenter<CameraView> {
    private CameraModule cameraModule = new DefaultCameraModule();

    void captureImage(Activity activity, Config config, int requestCode) {
        Context context = activity.getApplicationContext();
        Intent intent = this.cameraModule.getCameraIntent((Context)activity, config);
        if (intent == null) {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.imagepicker_error_create_image_file), (int)1).show();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public void finishCaptureImage(Context context, Intent data, Config config) {
        this.cameraModule.getImage(context, data, new OnImageReadyListener(){

            @Override
            public void onImageReady(List<Image> images) {
                ((CameraView)CameraPresenter.this.getView()).finishPickImages(images);
            }
        });
    }
}

