/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import com.nguyenhoanglam.imagepicker.helper.PreferenceHelper;

public class PermissionHelper {
    public static void checkPermission(Activity activity, String permission, PermissionAskListener listener) {
        if (!PermissionHelper.hasSelfPermission((Context)activity, permission)) {
            if (PermissionHelper.shouldShowRequestPermissionRationale(activity, permission)) {
                listener.onPermissionPreviouslyDenied();
            } else if (PreferenceHelper.isFirstTimeAskingPermission((Context)activity, permission)) {
                PreferenceHelper.firstTimeAskingPermission((Context)activity, permission, false);
                listener.onNeedPermission();
            } else {
                listener.onPermissionDisabled();
            }
        } else {
            listener.onPermissionGranted();
        }
    }

    public static void openAppSettings(Activity activity) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        intent.addFlags(0x40000000);
        intent.addFlags(0x800000);
        activity.startActivity(intent);
    }

    public static String[] asArray(String ... permissions) {
        if (permissions.length == 0) {
            throw new IllegalArgumentException("There is no given permission");
        }
        String[] dest = new String[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            dest[i] = permissions[i];
        }
        return dest;
    }

    public static boolean hasGranted(int grantResult) {
        return grantResult == 0;
    }

    public static boolean hasGranted(int[] grantResults) {
        for (int result : grantResults) {
            if (PermissionHelper.hasGranted(result)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSelfPermission(Context context, String permission) {
        if (PermissionHelper.shouldAskPermission()) {
            return PermissionHelper.permissionHasGranted(context, permission);
        }
        return true;
    }

    public static boolean hasSelfPermissions(Context context, String[] permissions) {
        if (PermissionHelper.shouldAskPermission()) {
            for (String permission : permissions) {
                if (PermissionHelper.permissionHasGranted(context, permission)) continue;
                return false;
            }
        }
        return true;
    }

    public static void requestAllPermissions(@NonNull Activity activity, @NonNull String[] permissions, int requestCode) {
        if (PermissionHelper.shouldAskPermission()) {
            PermissionHelper.internalRequestPermissions(activity, permissions, requestCode);
        }
    }

    @TargetApi(value=23)
    private static void internalRequestPermissions(Activity activity, String[] permissions, int requestCode) {
        if (activity == null) {
            throw new IllegalArgumentException("Given activity is null.");
        }
        activity.requestPermissions(permissions, requestCode);
    }

    @TargetApi(value=23)
    private static boolean permissionHasGranted(Context context, String permission) {
        return PermissionHelper.hasGranted(context.checkSelfPermission(permission));
    }

    private static boolean shouldAskPermission() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permission) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission);
    }

    public static interface PermissionAskListener {
        public void onNeedPermission();

        public void onPermissionPreviouslyDenied();

        public void onPermissionDisabled();

        public void onPermissionGranted();
    }
}

