/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.helper.CameraHelper;
import com.nguyenhoanglam.imagepicker.helper.LogHelper;
import com.nguyenhoanglam.imagepicker.helper.PermissionHelper;
import com.nguyenhoanglam.imagepicker.helper.PreferenceHelper;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraPresenter;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraView;
import com.nguyenhoanglam.imagepicker.widget.SnackBarView;
import java.util.ArrayList;
import java.util.List;

public class CameraActivty
extends AppCompatActivity
implements CameraView {
    private final String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
    private SnackBarView snackBar;
    private Config config;
    private CameraPresenter presenter;
    private LogHelper logger = LogHelper.getInstance();
    private boolean isOpeningCamera = false;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent == null) {
            this.finish();
            return;
        }
        this.config = (Config)intent.getParcelableExtra("ImagePickerConfig");
        if (this.config.isKeepScreenOn()) {
            this.getWindow().addFlags(128);
        }
        this.setContentView(R.layout.imagepicker_activity_camera);
        this.snackBar = (SnackBarView)this.findViewById(R.id.snackbar);
        this.presenter = new CameraPresenter();
        this.presenter.attachView(this);
    }

    protected void onResume() {
        super.onResume();
        if (PermissionHelper.hasSelfPermissions((Context)this, this.permissions) && this.isOpeningCamera) {
            this.isOpeningCamera = false;
        } else if (!this.snackBar.isShowing()) {
            this.captureImageWithPermission();
        }
    }

    private void captureImageWithPermission() {
        if (PermissionHelper.hasSelfPermissions((Context)this, this.permissions)) {
            this.captureImage();
        } else {
            this.logger.w("Camera permission is not granted. Requesting permission");
            this.requestCameraPermission();
        }
    }

    private void captureImage() {
        if (!CameraHelper.checkCameraAvailability((Context)this)) {
            this.finish();
            return;
        }
        this.presenter.captureImage((Activity)this, this.config, 101);
        this.isOpeningCamera = true;
    }

    private void requestCameraPermission() {
        this.logger.w("Write External permission is not granted. Requesting permission");
        boolean hasPermissionDisbled = false;
        boolean wesGranted = PermissionHelper.hasSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE");
        boolean cameraGranted = PermissionHelper.hasSelfPermission((Context)this, "android.permission.CAMERA");
        if (!(wesGranted || PermissionHelper.shouldShowRequestPermissionRationale((Activity)this, "android.permission.WRITE_EXTERNAL_STORAGE") || PreferenceHelper.isFirstTimeAskingPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE"))) {
            hasPermissionDisbled = true;
        }
        if (!(cameraGranted || PermissionHelper.shouldShowRequestPermissionRationale((Activity)this, "android.permission.CAMERA") || PreferenceHelper.isFirstTimeAskingPermission((Context)this, "android.permission.CAMERA"))) {
            hasPermissionDisbled = true;
        }
        ArrayList<String> permissions = new ArrayList<String>();
        if (!hasPermissionDisbled) {
            if (!wesGranted) {
                permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
                PreferenceHelper.firstTimeAskingPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE", false);
            }
            if (!cameraGranted) {
                permissions.add("android.permission.CAMERA");
                PreferenceHelper.firstTimeAskingPermission((Context)this, "android.permission.CAMERA", false);
            }
            PermissionHelper.requestAllPermissions((Activity)this, permissions.toArray(new String[permissions.size()]), 103);
        } else {
            this.snackBar.show(R.string.imagepicker_msg_no_write_external_storage_camera_permission, new View.OnClickListener(){

                public void onClick(View view) {
                    PermissionHelper.openAppSettings((Activity)CameraActivty.this);
                }
            });
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 103: {
                if (PermissionHelper.hasGranted(grantResults)) {
                    this.logger.d("Camera permission granted");
                    this.captureImage();
                    return;
                }
                this.logger.e("Permission not granted: results len = " + grantResults.length + " Result code = " + (grantResults.length > 0 ? Integer.valueOf(grantResults[0]) : "(empty)"));
                boolean shouldShowSnackBar = false;
                for (int grantResult : grantResults) {
                    if (!PermissionHelper.hasGranted(grantResult)) continue;
                    shouldShowSnackBar = true;
                    break;
                }
                if (shouldShowSnackBar) {
                    this.snackBar.show(R.string.imagepicker_msg_no_write_external_storage_camera_permission, new View.OnClickListener(){

                        public void onClick(View view) {
                            PermissionHelper.openAppSettings((Activity)CameraActivty.this);
                        }
                    });
                    break;
                }
                this.finish();
                break;
            }
            default: {
                this.logger.d("Got unexpected permission result: " + requestCode);
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
                this.finish();
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 101 && resultCode == -1) {
            this.presenter.finishCaptureImage((Context)this, data, this.config);
        } else {
            this.setResult(0, new Intent());
            this.finish();
        }
    }

    public void onBackPressed() {
        this.setResult(0);
        this.finish();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.detachView();
        }
    }

    @Override
    public void finishPickImages(List<Image> images) {
        Intent data = new Intent();
        data.putParcelableArrayListExtra("ImagePickerImages", (ArrayList)images);
        this.setResult(-1, data);
        this.finish();
    }
}

