/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.ui.common.BaseRecyclerViewAdapter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageLoader;
import java.util.ArrayList;
import java.util.List;

public class FolderPickerAdapter
extends BaseRecyclerViewAdapter<FolderViewHolder> {
    private List<Folder> folders = new ArrayList<Folder>();
    private OnFolderClickListener itemClickListener;

    public FolderPickerAdapter(Context context, ImageLoader imageLoader, OnFolderClickListener itemClickListener) {
        super(context, imageLoader);
        this.itemClickListener = itemClickListener;
    }

    public FolderViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.getInflater().inflate(R.layout.imagepicker_item_folder, parent, false);
        return new FolderViewHolder(itemView);
    }

    public void onBindViewHolder(FolderViewHolder holder, int position) {
        final Folder folder = this.folders.get(position);
        this.getImageLoader().loadImage(folder.getImages().get(0).getPath(), holder.image);
        holder.name.setText((CharSequence)folder.getFolderName());
        int count = folder.getImages().size();
        holder.count.setText((CharSequence)("" + count));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FolderPickerAdapter.this.itemClickListener.onFolderClick(folder);
            }
        });
    }

    public void setData(List<Folder> folders) {
        if (folders != null) {
            this.folders.clear();
            this.folders.addAll(folders);
        }
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.folders.size();
    }

    static class FolderViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView image;
        private TextView name;
        private TextView count;

        public FolderViewHolder(View itemView) {
            super(itemView);
            this.image = (ImageView)itemView.findViewById(R.id.image_folder_thumbnail);
            this.name = (TextView)itemView.findViewById(R.id.text_folder_name);
            this.count = (TextView)itemView.findViewById(R.id.text_photo_count);
        }
    }
}

