/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.Window;
import android.widget.Toast;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.helper.CameraHelper;
import com.nguyenhoanglam.imagepicker.helper.LogHelper;
import com.nguyenhoanglam.imagepicker.helper.PermissionHelper;
import com.nguyenhoanglam.imagepicker.listener.OnBackAction;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageClickListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectionListener;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFileLoader;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerPresenter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerView;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.RecyclerViewManager;
import com.nguyenhoanglam.imagepicker.widget.ImagePickerToolbar;
import com.nguyenhoanglam.imagepicker.widget.ProgressWheel;
import com.nguyenhoanglam.imagepicker.widget.SnackBarView;
import java.util.ArrayList;
import java.util.List;

public class ImagePickerActivity
extends AppCompatActivity
implements ImagePickerView {
    private ImagePickerToolbar toolbar;
    private RecyclerViewManager recyclerViewManager;
    private RecyclerView recyclerView;
    private ProgressWheel progressWheel;
    private View emptyLayout;
    private SnackBarView snackBar;
    private Config config;
    private Handler handler;
    private ContentObserver observer;
    private ImagePickerPresenter presenter;
    private LogHelper logger = LogHelper.getInstance();
    private OnImageClickListener imageClickListener = new OnImageClickListener(){

        @Override
        public boolean onImageClick(View view, int position, boolean isSelected) {
            return ImagePickerActivity.this.recyclerViewManager.selectImage();
        }
    };
    private OnFolderClickListener folderClickListener = new OnFolderClickListener(){

        @Override
        public void onFolderClick(Folder folder) {
            ImagePickerActivity.this.setImageAdapter(folder.getImages(), folder.getFolderName());
        }
    };
    private View.OnClickListener backClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            ImagePickerActivity.this.onBackPressed();
        }
    };
    private View.OnClickListener cameraClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            ImagePickerActivity.this.captureImageWithPermission();
        }
    };
    private View.OnClickListener doneClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            ImagePickerActivity.this.onDone();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent == null) {
            this.finish();
            return;
        }
        this.config = (Config)intent.getParcelableExtra("ImagePickerConfig");
        this.setContentView(R.layout.imagepicker_activity_picker);
        this.setupView();
        this.setupComponents();
        this.setupToolbar();
    }

    private void setupView() {
        this.toolbar = (ImagePickerToolbar)this.findViewById(R.id.toolbar);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.progressWheel = (ProgressWheel)this.findViewById(R.id.progressWheel);
        this.emptyLayout = this.findViewById(R.id.layout_empty);
        this.snackBar = (SnackBarView)this.findViewById(R.id.snackbar);
        Window window = this.getWindow();
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(this.config.getStatusBarColor());
        }
        this.progressWheel.setBarColor(this.config.getProgressBarColor());
        this.findViewById(R.id.container).setBackgroundColor(this.config.getBackgroundColor());
    }

    private void setupComponents() {
        this.recyclerViewManager = new RecyclerViewManager(this.recyclerView, this.config, this.getResources().getConfiguration().orientation);
        this.recyclerViewManager.setupAdapters(this.imageClickListener, this.folderClickListener);
        this.recyclerViewManager.setOnImageSelectionListener(new OnImageSelectionListener(){

            @Override
            public void onSelectionUpdate(List<Image> images) {
                ImagePickerActivity.this.invalidateToolbar();
                if (!ImagePickerActivity.this.config.isMultipleMode() && !images.isEmpty()) {
                    ImagePickerActivity.this.onDone();
                }
            }
        });
        this.presenter = new ImagePickerPresenter(new ImageFileLoader((Context)this));
        this.presenter.attachView(this);
    }

    private void setupToolbar() {
        this.toolbar.config(this.config);
        this.toolbar.setOnBackClickListener(this.backClickListener);
        this.toolbar.setOnCameraClickListener(this.cameraClickListener);
        this.toolbar.setOnDoneClickListener(this.doneClickListener);
    }

    protected void onResume() {
        super.onResume();
        this.getDataWithPermission();
    }

    private void setImageAdapter(List<Image> images, String title) {
        this.recyclerViewManager.setImageAdapter(images, title);
        this.invalidateToolbar();
    }

    private void setFolderAdapter(List<Folder> folders) {
        this.recyclerViewManager.setFolderAdapter(folders);
        this.invalidateToolbar();
    }

    private void invalidateToolbar() {
        this.toolbar.setTitle(this.recyclerViewManager.getTitle());
        this.toolbar.showDoneButton(this.recyclerViewManager.isShowDoneButton());
    }

    private void onDone() {
        this.presenter.onDoneSelectImages(this.recyclerViewManager.getSelectedImages());
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.recyclerViewManager.changeOrientation(newConfig.orientation);
    }

    private void getDataWithPermission() {
        final String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        PermissionHelper.checkPermission((Activity)this, "android.permission.WRITE_EXTERNAL_STORAGE", new PermissionHelper.PermissionAskListener(){

            @Override
            public void onNeedPermission() {
                PermissionHelper.requestAllPermissions((Activity)ImagePickerActivity.this, permissions, 102);
            }

            @Override
            public void onPermissionPreviouslyDenied() {
                PermissionHelper.requestAllPermissions((Activity)ImagePickerActivity.this, permissions, 102);
            }

            @Override
            public void onPermissionDisabled() {
                ImagePickerActivity.this.snackBar.show(R.string.imagepicker_msg_no_write_external_storage_permission, new View.OnClickListener(){

                    public void onClick(View view) {
                        PermissionHelper.openAppSettings((Activity)ImagePickerActivity.this);
                    }
                });
            }

            @Override
            public void onPermissionGranted() {
                ImagePickerActivity.this.getData();
            }
        });
    }

    private void getData() {
        this.presenter.abortLoading();
        this.presenter.loadImages(this.config.isFolderMode());
    }

    private void captureImageWithPermission() {
        final String[] permissions = new String[]{"android.permission.CAMERA"};
        PermissionHelper.checkPermission((Activity)this, "android.permission.CAMERA", new PermissionHelper.PermissionAskListener(){

            @Override
            public void onNeedPermission() {
                PermissionHelper.requestAllPermissions((Activity)ImagePickerActivity.this, permissions, 103);
            }

            @Override
            public void onPermissionPreviouslyDenied() {
                PermissionHelper.requestAllPermissions((Activity)ImagePickerActivity.this, permissions, 103);
            }

            @Override
            public void onPermissionDisabled() {
                ImagePickerActivity.this.snackBar.show(R.string.imagepicker_msg_no_camera_permission, new View.OnClickListener(){

                    public void onClick(View view) {
                        PermissionHelper.openAppSettings((Activity)ImagePickerActivity.this);
                    }
                });
            }

            @Override
            public void onPermissionGranted() {
                ImagePickerActivity.this.captureImage();
            }
        });
    }

    private void captureImage() {
        if (!CameraHelper.checkCameraAvailability((Context)this)) {
            return;
        }
        this.presenter.captureImage((Activity)this, this.config, 101);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 101 && resultCode == -1) {
            this.presenter.finishCaptureImage((Context)this, data, this.config);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 102: {
                if (PermissionHelper.hasGranted(grantResults)) {
                    this.logger.d("Write External permission granted");
                    this.getData();
                    return;
                }
                this.logger.e("Permission not granted: results len = " + grantResults.length + " Result code = " + (grantResults.length > 0 ? Integer.valueOf(grantResults[0]) : "(empty)"));
                this.finish();
            }
            case 103: {
                if (PermissionHelper.hasGranted(grantResults)) {
                    this.logger.d("Camera permission granted");
                    this.captureImage();
                    return;
                }
                this.logger.e("Permission not granted: results len = " + grantResults.length + " Result code = " + (grantResults.length > 0 ? Integer.valueOf(grantResults[0]) : "(empty)"));
                break;
            }
            default: {
                this.logger.d("Got unexpected permission result: " + requestCode);
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.handler == null) {
            this.handler = new Handler();
        }
        this.observer = new ContentObserver(this.handler){

            public void onChange(boolean selfChange) {
                ImagePickerActivity.this.getData();
            }
        };
        this.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, false, this.observer);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.abortLoading();
            this.presenter.detachView();
        }
        if (this.observer != null) {
            this.getContentResolver().unregisterContentObserver(this.observer);
            this.observer = null;
        }
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
    }

    public void onBackPressed() {
        this.recyclerViewManager.handleBack(new OnBackAction(){

            @Override
            public void onBackToFolder() {
                ImagePickerActivity.this.invalidateToolbar();
            }

            @Override
            public void onFinishImagePicker() {
                ImagePickerActivity.this.setResult(0);
                ImagePickerActivity.this.finish();
            }
        });
    }

    @Override
    public void showLoading(boolean isLoading) {
        this.progressWheel.setVisibility(isLoading ? 0 : 8);
        this.recyclerView.setVisibility(isLoading ? 8 : 0);
        this.emptyLayout.setVisibility(8);
    }

    @Override
    public void showFetchCompleted(List<Image> images, List<Folder> folders) {
        if (this.config.isFolderMode()) {
            this.setFolderAdapter(folders);
        } else {
            this.setImageAdapter(images, this.config.getImageTitle());
        }
    }

    @Override
    public void showError(Throwable throwable) {
        String message = this.getString(R.string.imagepicker_error_unknown);
        if (throwable != null && throwable instanceof NullPointerException) {
            message = this.getString(R.string.imagepicker_error_images_not_exist);
        }
        Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
    }

    @Override
    public void showEmpty() {
        this.progressWheel.setVisibility(8);
        this.recyclerView.setVisibility(8);
        this.emptyLayout.setVisibility(0);
    }

    @Override
    public void showCapturedImage() {
        this.getDataWithPermission();
    }

    @Override
    public void finishPickImages(List<Image> images) {
        Intent data = new Intent();
        data.putParcelableArrayListExtra("ImagePickerImages", (ArrayList)images);
        this.setResult(-1, data);
        this.finish();
    }
}

