/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.os.Build;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.domain.DeviceType;
import com.herewhite.sdk.domain.LoggerOptions;
import com.herewhite.sdk.domain.WhiteObject;
import java.util.HashMap;

public class WhiteSdkConfiguration
extends WhiteObject {
    private DeviceType deviceType = DeviceType.touch;
    private boolean log = false;
    private RenderEngineType renderEngine = RenderEngineType.canvas;
    private boolean enableInterrupterAPI = false;
    private boolean preloadDynamicPPT = false;
    private boolean routeBackup = false;
    private boolean userCursor = false;
    private boolean onlyCallbackRemoteStateModify = false;
    private boolean disableDeviceInputs = false;
    private LoggerOptions loggerOptions;
    private String appIdentifier;
    private HashMap<String, String> __nativeTags = new HashMap();
    private PptParams pptParams;
    private HashMap<String, String> fonts;

    public boolean isDisableDeviceInputs() {
        return this.disableDeviceInputs;
    }

    public void setDisableDeviceInputs(boolean disableDeviceInputs) {
        this.disableDeviceInputs = disableDeviceInputs;
    }

    public void setRenderEngine(RenderEngineType renderEngine) {
        this.renderEngine = renderEngine;
    }

    public RenderEngineType getRenderEngine() {
        return this.renderEngine;
    }

    public PptParams getPptParams() {
        return this.pptParams;
    }

    public void setPptParams(PptParams pptParams) {
        this.pptParams = pptParams;
    }

    public HashMap<String, String> getFonts() {
        return this.fonts;
    }

    public void setFonts(HashMap<String, String> fonts) {
        this.fonts = fonts;
    }

    public boolean isPreloadDynamicPPT() {
        return this.preloadDynamicPPT;
    }

    public void setPreloadDynamicPPT(boolean preloadDynamicPPT) {
        this.preloadDynamicPPT = preloadDynamicPPT;
    }

    private void setupNativeTags() {
        this.__nativeTags.put("nativeVersion", WhiteSdk.Version());
        this.__nativeTags.put("platform", "android API " + Build.VERSION.SDK_INT);
    }

    public WhiteSdkConfiguration(String appIdentifier, boolean log) {
        this(appIdentifier);
        this.log = log;
    }

    public WhiteSdkConfiguration(String appIdentifier) {
        this.appIdentifier = appIdentifier;
        if (Build.VERSION.SDK_INT >= 24 && Build.VERSION.SDK_INT < 28) {
            this.renderEngine = RenderEngineType.svg;
        }
        this.setupNativeTags();
    }

    public LoggerOptions getLoggerOptions() {
        return this.loggerOptions;
    }

    public void setLoggerOptions(LoggerOptions loggerOptions) {
        this.loggerOptions = loggerOptions;
    }

    public boolean isRouteBackup() {
        return this.routeBackup;
    }

    public void setRouteBackup(boolean routeBackup) {
        this.routeBackup = routeBackup;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setUserCursor(boolean userCursor) {
        this.userCursor = userCursor;
    }

    public boolean isUserCursor() {
        return this.userCursor;
    }

    public boolean isOnlyCallbackRemoteStateModify() {
        return this.onlyCallbackRemoteStateModify;
    }

    public void setOnlyCallbackRemoteStateModify(boolean onlyCallbackRemoteStateModify) {
        this.onlyCallbackRemoteStateModify = onlyCallbackRemoteStateModify;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean isEnableInterrupterAPI() {
        return this.enableInterrupterAPI;
    }

    public void setEnableInterrupterAPI(boolean enableInterrupterAPI) {
        this.enableInterrupterAPI = enableInterrupterAPI;
    }

    public static class PptParams
    extends WhiteObject {
        private String scheme;

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public PptParams(String scheme) {
            this.scheme = scheme;
        }
    }

    public static enum RenderEngineType {
        svg,
        canvas;

    }
}

