/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import androidx.annotation.ColorInt;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.WhiteboardView;
import com.herewhite.sdk.domain.AnimationMode;
import com.herewhite.sdk.domain.CameraBound;
import com.herewhite.sdk.domain.CameraConfig;
import com.herewhite.sdk.domain.EventListener;
import com.herewhite.sdk.domain.FrequencyEventListener;
import com.herewhite.sdk.domain.Point;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.RectangleConfig;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.Scene;
import com.herewhite.sdk.domain.WhiteScenePathType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;
import wendu.dsbridge.OnReturnValue;

public class Displayer {
    @ColorInt
    private int backgroundColor = -1;
    protected final WhiteboardView bridge;
    protected String uuid;
    protected final Context context;
    protected WhiteSdk sdk;
    protected static final Gson gson = new Gson();
    protected ConcurrentHashMap<String, EventListener> eventListenerConcurrentHashMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, FrequencyEventListener> frequencyEventListenerConcurrentHashMap = new ConcurrentHashMap();

    public Displayer(String uuid, WhiteboardView bridge, Context context, WhiteSdk sdk) {
        this.uuid = uuid;
        this.bridge = bridge;
        this.context = context;
        this.sdk = sdk;
    }

    public void getScenePathType(String path, final Promise<WhiteScenePathType> promise) {
        this.bridge.callHandler("displayer.scenePathType", new Object[]{path}, new OnReturnValue<String>(){

            public void onValue(String retValue) {
                WhiteScenePathType type = (WhiteScenePathType)((Object)gson.fromJson(retValue, WhiteScenePathType.class));
                promise.then(type);
            }
        });
    }

    public void getEntireScenes(final Promise<Map<String, Scene[]>> promise) {
        this.bridge.callHandler("displayer.entireScenes", new OnReturnValue<JSONObject>(){

            public void onValue(JSONObject retValue) {
                Type type = new TypeToken<Map<String, Scene[]>>(){}.getType();
                Map map = (Map)gson.fromJson(String.valueOf(retValue), type);
                promise.then(map);
            }
        });
    }

    public void refreshViewSize() {
        this.bridge.callHandler("displayer.refreshViewSize", new Object[0]);
    }

    public void scalePptToFit() {
        this.bridge.callHandler("displayer.scalePptToFit", new Object[0]);
    }

    public void scalePptToFit(AnimationMode mode) {
        String modeString = (String)gson.fromJson(gson.toJson((Object)mode), String.class);
        this.bridge.callHandler("displayer.scalePptToFit", new Object[]{modeString});
    }

    public void addMagixEventListener(String eventName, EventListener eventListener) {
        this.eventListenerConcurrentHashMap.put(eventName, eventListener);
        this.bridge.callHandler("displayer.addMagixEventListener", new Object[]{eventName});
    }

    public void addHighFrequencyEventListener(String eventName, FrequencyEventListener eventListener, Integer fireInterval) {
        if (fireInterval < 500) {
            fireInterval = 500;
        }
        this.frequencyEventListenerConcurrentHashMap.put(eventName, eventListener);
        this.bridge.callHandler("displayer.addHighFrequencyEventListener", new Object[]{eventName, fireInterval});
    }

    public void removeMagixEventListener(String eventName) {
        this.eventListenerConcurrentHashMap.remove(eventName);
        this.frequencyEventListenerConcurrentHashMap.remove(eventName);
        this.bridge.callHandler("displayer.removeMagixEventListener", new Object[]{eventName});
    }

    public void convertToPointInWorld(double x, double y, final Promise<Point> promise) {
        this.bridge.callHandler("displayer.convertToPointInWorld", new Object[]{x, y}, new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(gson.fromJson(String.valueOf(o), Point.class));
                }
                catch (AssertionError a) {
                    throw a;
                }
                catch (JsonSyntaxException e) {
                    Logger.error("An JsonSyntaxException occurred while parse json from convertToPointInWorld", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred in convertToPointInWorld promise then method", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void setCameraBound(CameraBound bound) {
        this.bridge.callHandler("displayer.setCameraBound", new Object[]{bound});
    }

    @Deprecated
    public void setBackgroundColor(@ColorInt int intColor) {
        Object[] rgba = Displayer.hexSplit(intColor);
        this.bridge.callHandler("displayer.setBackgroundColor", rgba);
        this.backgroundColor = intColor;
    }

    private static Float[] hexSplit(@ColorInt int color) {
        Float r = Float.valueOf(color >> 16 & 0xFF);
        Float g = Float.valueOf(color >> 8 & 0xFF);
        Float b = Float.valueOf(color & 0xFF);
        Float a = Float.valueOf((float)(color >> 24 & 0xFF) / 255.0f);
        return new Float[]{r, g, b, a};
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void getScenePreviewImage(String scenePath, final Promise<Bitmap> promise) {
        this.bridge.callHandler("displayerAsync.scenePreview", new Object[]{scenePath}, new OnReturnValue<String>(){

            public void onValue(String retValue) {
                Bitmap bitmap = null;
                try {
                    bitmap = Displayer.this.transformBase64toBitmap(retValue);
                }
                catch (Exception e) {
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                if (bitmap != null) {
                    promise.then(bitmap);
                }
            }
        });
    }

    public void getSceneSnapshotImage(String scenePath, final Promise<Bitmap> promise) {
        this.bridge.callHandler("displayerAsync.sceneSnapshot", new Object[]{scenePath}, new OnReturnValue<String>(){

            public void onValue(String retValue) {
                Bitmap bitmap = null;
                try {
                    bitmap = Displayer.this.transformBase64toBitmap(retValue);
                }
                catch (Exception e) {
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                if (bitmap != null) {
                    promise.then(bitmap);
                }
            }
        });
    }

    private Bitmap transformBase64toBitmap(String base64String) {
        String pureBase64Encoded = base64String.substring(base64String.indexOf(",") + 1);
        byte[] decodedBytes = Base64.decode((String)pureBase64Encoded, (int)0);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inDensity = this.context.getResources().getDisplayMetrics().densityDpi;
        return BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length, (BitmapFactory.Options)opts);
    }

    public void moveCamera(CameraConfig camera) {
        this.bridge.callHandler("displayer.moveCamera", new Object[]{camera});
    }

    public void moveCameraToContainer(RectangleConfig rectangle) {
        this.bridge.callHandler("displayer.moveCameraToContain", new Object[]{rectangle});
    }
}

