/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.util.DisplayMetrics;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.herewhite.sdk.domain.WhiteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

class Utils {
    private static final Gson gson = new Gson();
    private static final Class[] PRIMITIVE_TYPES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class};
    private static List<Class> PRIMITIVE_LIST = Arrays.asList(PRIMITIVE_TYPES);

    Utils() {
    }

    public static <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        return (T)gson.fromJson(json, classOfT);
    }

    public static <T> T fromJson(JsonElement jsonElement, Class<T> classOfT) throws JsonSyntaxException {
        return (T)gson.fromJson(jsonElement, classOfT);
    }

    public static <T> T deepCopy(T object, Class<T> classOfT) {
        Gson gson = new Gson();
        return (T)gson.fromJson(gson.toJson(object), classOfT);
    }

    public static int getDensityDpi(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.densityDpi;
    }

    public static Object[] toBridgeMaps(Object[] objects) {
        if (objects != null) {
            Object[] maps = new Object[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                maps[i] = Utils.toBridgeJSON(objects[i]);
            }
            return maps;
        }
        return new Object[0];
    }

    private static boolean isPrimitiveOrStringOrNull(Object target) {
        if (target instanceof String) {
            return true;
        }
        if (target == null) {
            return true;
        }
        return PRIMITIVE_LIST.contains(target.getClass());
    }

    private static Object toBridgeJSON(Object object) {
        if (object instanceof JSONObject) {
            return object;
        }
        if (object instanceof String[]) {
            return object;
        }
        if (Utils.isPrimitiveOrStringOrNull(object)) {
            return object;
        }
        if (object instanceof WhiteObject) {
            return ((WhiteObject)object).toJSON();
        }
        if (object instanceof WhiteObject[]) {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            for (int i = 0; i < ((WhiteObject[])object).length; ++i) {
                list.add(((WhiteObject[])object)[i].toJSON());
            }
            return list;
        }
        return gson.toJson(object);
    }

    public static JSONObject asJSONObject(String json) {
        JSONObject object;
        try {
            object = new JSONObject(json);
        }
        catch (JSONException e) {
            object = new JSONObject();
        }
        return object;
    }
}

