/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.herewhite.sdk.AudioEffectBridge;
import com.herewhite.sdk.AudioEffectImplement;
import com.herewhite.sdk.AudioMixerBridge;
import com.herewhite.sdk.AudioMixerImplement;
import com.herewhite.sdk.CommonCallback;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.Player;
import com.herewhite.sdk.PlayerListener;
import com.herewhite.sdk.Room;
import com.herewhite.sdk.RoomListener;
import com.herewhite.sdk.RoomParams;
import com.herewhite.sdk.Utils;
import com.herewhite.sdk.WhiteSdkConfiguration;
import com.herewhite.sdk.WhiteboardView;
import com.herewhite.sdk.domain.FontFace;
import com.herewhite.sdk.domain.PlayerConfiguration;
import com.herewhite.sdk.domain.PlayerTimeInfo;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.UrlInterrupter;
import com.herewhite.sdk.domain.WindowRegisterAppParams;
import com.herewhite.sdk.internal.PlayerJsInterfaceImpl;
import com.herewhite.sdk.internal.PostMessageCallback;
import com.herewhite.sdk.internal.RoomJsInterfaceImpl;
import com.herewhite.sdk.internal.RtcJsInterfaceImpl;
import com.herewhite.sdk.internal.SdkJsInterfaceImpl;
import com.herewhite.sdk.internal.StoreDelegate;
import com.herewhite.sdk.internal.StoreJsInterfaceImpl;
import com.herewhite.sdk.window.SlideListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;
import wendu.dsbridge.OnReturnValue;

public class WhiteSdk {
    private static final String SDK_VERSION = "2.16.79";
    private static final Gson gson = new Gson();
    private static AudioMixerBridge sAudioMixerBridge;
    private static AudioEffectBridge sAudioEffectBridge;
    private final JsBridgeInterface bridge;
    private final RoomJsInterfaceImpl roomJsInterface;
    private final PlayerJsInterfaceImpl playerJsInterface;
    private final SdkJsInterfaceImpl sdkJsInterface;
    private final StoreJsInterfaceImpl storeJsInterface;
    private final int densityDpi;
    private final boolean onlyCallbackRemoteStateModify;
    private RtcJsInterfaceImpl rtcJsInterface;
    @Nullable
    private AudioMixerImplement audioMixerImplement;
    private AudioEffectImplement audioEffectImplement;
    private SlideListener slideListener;
    private static final AtomicInteger sSessionId;

    public WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration) {
        this(bridge, context, whiteSdkConfiguration, (CommonCallback)null);
    }

    public WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, @Nullable CommonCallback commonCallback) {
        this(bridge, context, whiteSdkConfiguration, commonCallback, null);
    }

    public WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, UrlInterrupter urlInterrupter) {
        this(bridge, context, whiteSdkConfiguration);
        this.sdkJsInterface.setUrlInterrupter(urlInterrupter);
    }

    WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, CommonCallback commonCallback, AudioMixerBridge audioMixerBridge) {
        this(bridge, context, whiteSdkConfiguration, commonCallback, audioMixerBridge, null);
    }

    public WhiteSdk(JsBridgeInterface bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, @Nullable CommonCallback commonCallback, @Nullable AudioMixerBridge audioMixerBridge, @Nullable AudioEffectBridge audioEffectBridge) {
        this.bridge = bridge;
        this.densityDpi = Utils.getDensityDpi(context);
        this.roomJsInterface = new RoomJsInterfaceImpl();
        this.playerJsInterface = new PlayerJsInterfaceImpl();
        this.sdkJsInterface = new SdkJsInterfaceImpl(commonCallback);
        this.storeJsInterface = new StoreJsInterfaceImpl();
        this.onlyCallbackRemoteStateModify = whiteSdkConfiguration.isOnlyCallbackRemoteStateModify();
        if (audioMixerBridge == null) {
            audioMixerBridge = sAudioMixerBridge;
        }
        if (audioEffectBridge == null) {
            audioEffectBridge = sAudioEffectBridge;
        }
        if (audioMixerBridge != null) {
            this.audioMixerImplement = new AudioMixerImplement(bridge);
            whiteSdkConfiguration.setEnableRtcIntercept(true);
        }
        if (audioEffectBridge != null) {
            this.audioEffectImplement = new AudioEffectImplement(bridge);
            whiteSdkConfiguration.setEnableRtcAudioEffectIntercept(true);
        }
        if (audioMixerBridge != null || audioEffectBridge != null) {
            this.rtcJsInterface = new RtcJsInterfaceImpl(audioMixerBridge, audioEffectBridge);
            bridge.addJavascriptObject(this.rtcJsInterface, "rtc");
        }
        bridge.addJavascriptObject(this.sdkJsInterface, "sdk");
        bridge.addJavascriptObject(this.roomJsInterface, "room");
        bridge.addJavascriptObject(this.playerJsInterface, "player");
        bridge.addJavascriptObject(this.storeJsInterface, "store");
        WhiteSdkConfiguration copyConfig = Utils.deepCopy(whiteSdkConfiguration, WhiteSdkConfiguration.class);
        copyConfig.setOnlyCallbackRemoteStateModify(false);
        bridge.callHandler("sdk.newWhiteSdk", new Object[]{copyConfig});
    }

    public static String Version() {
        return SDK_VERSION;
    }

    public static void setAudioMixerBridge(AudioMixerBridge audioMixerBridge) {
        sAudioMixerBridge = audioMixerBridge;
    }

    public static void setAudioEffectBridge(AudioEffectBridge audioEffectBridge) {
        sAudioEffectBridge = audioEffectBridge;
    }

    public void setCommonCallbacks(CommonCallback commonCallback) {
        this.sdkJsInterface.setCommonCallbacks(commonCallback);
    }

    public AudioMixerImplement getAudioMixerImplement() {
        return this.audioMixerImplement;
    }

    public AudioEffectImplement getAudioEffectImplement() {
        return this.audioEffectImplement;
    }

    public void joinRoom(RoomParams roomParams, Promise<Room> roomPromise) {
        this.joinRoom(roomParams, null, roomPromise);
    }

    public void joinRoom(RoomParams roomParams, RoomListener roomListener, Promise<Room> roomPromise) {
        final Room room = new Room(roomParams.getUuid(), this.bridge, this.densityDpi, this.onlyCallbackRemoteStateModify);
        room.setRoomListener(roomListener);
        this.roomJsInterface.setRoom(room.getRoomDelegate());
        this.storeJsInterface.setStore(new StoreDelegate(){

            @Override
            public void fireSyncedStoreUpdate(String value) {
                room.getSyncedStore().fireStorageStateUpdate(value);
            }
        });
        try {
            this.bridge.callHandler("sdk.joinRoom", new Object[]{roomParams}, roomString -> {
                JsonObject jsonObject = (JsonObject)gson.fromJson(roomString, JsonObject.class);
                SDKError promiseError = SDKError.promiseError(jsonObject);
                if (promiseError != null) {
                    roomPromise.catchEx(promiseError);
                } else {
                    JsonObject jsonState = jsonObject.getAsJsonObject("state");
                    Long observerId = jsonObject.get("observerId").getAsLong();
                    Boolean isWritable = jsonObject.get("isWritable").getAsBoolean();
                    room.setSyncRoomState(jsonState.toString(), !roomParams.isDisableInitialStateCallback());
                    room.setObserverId(observerId);
                    room.setWritable(isWritable);
                    roomPromise.then(room);
                }
            });
        }
        catch (AssertionError a) {
            throw a;
        }
        catch (Exception e) {
            roomPromise.catchEx(new SDKError(e.getMessage()));
        }
    }

    public void createPlayer(PlayerConfiguration playerConfiguration, Promise<Player> playerPromise) {
        this.createPlayer(playerConfiguration, null, playerPromise);
    }

    public void createPlayer(PlayerConfiguration playerConfiguration, PlayerListener listener, Promise<Player> playerPromise) {
        final Player player = new Player(playerConfiguration.getRoom(), this.bridge, this.densityDpi);
        if (listener != null) {
            player.addPlayerListener(listener);
        }
        this.playerJsInterface.setPlayer(player.getDelegate());
        this.storeJsInterface.setStore(new StoreDelegate(){

            @Override
            public void fireSyncedStoreUpdate(String value) {
                player.getSyncedStore().fireStorageStateUpdate(value);
            }
        });
        try {
            this.bridge.callHandler("sdk.replayRoom", new Object[]{playerConfiguration}, playString -> {
                JsonObject jsonObject = (JsonObject)gson.fromJson(playString, JsonObject.class);
                SDKError promiseError = SDKError.promiseError(jsonObject);
                if (promiseError != null) {
                    playerPromise.catchEx(promiseError);
                } else {
                    JsonObject timeInfo = jsonObject.getAsJsonObject("timeInfo");
                    PlayerTimeInfo playerTimeInfo = (PlayerTimeInfo)gson.fromJson(timeInfo.toString(), PlayerTimeInfo.class);
                    player.setPlayerTimeInfo(playerTimeInfo);
                    playerPromise.then(player);
                }
            });
        }
        catch (AssertionError a) {
            throw a;
        }
        catch (Exception e) {
            playerPromise.catchEx(new SDKError(e.getMessage()));
        }
    }

    public void isPlayable(PlayerConfiguration playerConfiguration, final Promise<Boolean> playablePromise) {
        this.bridge.callHandler("sdk.isPlayable", new Object[]{playerConfiguration}, new OnReturnValue<Boolean>(){

            public void onValue(Boolean retValue) {
                playablePromise.then(retValue);
            }
        });
    }

    public void setupFontFaces(FontFace[] fontFaces) {
        this.bridge.callHandler("sdk.updateNativeFontFaceCSS", new Object[]{fontFaces});
    }

    public void loadFontFaces(FontFace[] fontFaces, final Promise<JSONObject> loadPromise) {
        this.bridge.callHandler("sdk.asyncInsertFontFaces", new Object[]{fontFaces}, new OnReturnValue<JSONObject>(){

            public void onValue(JSONObject retValue) {
                loadPromise.then(retValue);
            }
        });
    }

    public void registerApp(WindowRegisterAppParams params, Promise<Boolean> registerPromise) {
        this.bridge.callHandler("sdk.registerApp", new Object[]{params}, retValue -> {
            if (registerPromise == null) {
                return;
            }
            if (retValue == null) {
                registerPromise.then(true);
            } else {
                registerPromise.catchEx(SDKError.promiseError(retValue));
            }
        });
    }

    public void updateTextFont(String[] names) {
        this.bridge.callHandler("sdk.updateNativeTextareaFont", new Object[]{names});
    }

    public void releaseRoom() {
        this.roomJsInterface.setRoom(null);
        this.storeJsInterface.setStore(null);
    }

    @Deprecated
    public void releaseRoom(String uuid) {
        this.releaseRoom();
    }

    public void releasePlayer() {
        this.playerJsInterface.setPlayer(null);
        this.storeJsInterface.setStore(null);
    }

    @Deprecated
    public void releasePlayer(String uuid) {
        this.releasePlayer();
    }

    public void requestSlideLog(File logFile, Promise<Boolean> promise) {
        try {
            RequestSlideLogHandler handler = new RequestSlideLogHandler(logFile, promise);
            handler.request();
        }
        catch (Exception e) {
            promise.catchEx(new SDKError(e.getMessage()));
        }
    }

    public void updateSlideVolume(float volume) {
        this.bridge.evaluateJavascript("window.postMessage({'type': \"@slide/_update_volume_\",'volume': " + volume + "});");
    }

    public void getSlideVolume(Promise<Double> promise) {
        this.sdkJsInterface.setPostMessageCallback(jsonObject -> {
            try {
                String type = jsonObject.optString("type");
                if ("@slide/_report_volume_".equals(type)) {
                    this.sdkJsInterface.setPostMessageCallback(null);
                    promise.then(jsonObject.getDouble("volume"));
                }
            }
            catch (Exception e) {
                this.sdkJsInterface.setPostMessageCallback(null);
                promise.catchEx(SDKError.parseError(jsonObject));
            }
        });
        this.bridge.evaluateJavascript("window.postMessage({'type': \"@slide/_get_volume_\"});");
    }

    public void setSlideListener(SlideListener slideListener) {
        this.sdkJsInterface.setSlideListener(slideListener);
    }

    static {
        sSessionId = new AtomicInteger(1);
    }

    public static class Builder {
        private JsBridgeInterface bridge;
        private Context context;
        private WhiteSdkConfiguration whiteSdkConfiguration;
        private CommonCallback commonCallback;
        private AudioMixerBridge audioMixerBridge;
        private AudioEffectBridge audioEffectBridge;

        public Builder(WhiteboardView whiteboardView, WhiteSdkConfiguration whiteSdkConfiguration) {
            this.bridge = whiteboardView;
            this.context = whiteboardView.getContext();
            this.whiteSdkConfiguration = whiteSdkConfiguration;
        }

        public Builder setCommonCallback(CommonCallback commonCallback) {
            this.commonCallback = commonCallback;
            return this;
        }

        public Builder setAudioMixerBridge(AudioMixerBridge audioMixerBridge) {
            this.audioMixerBridge = audioMixerBridge;
            return this;
        }

        public Builder setAudioEffectBridge(AudioEffectBridge audioEffectBridge) {
            this.audioEffectBridge = audioEffectBridge;
            return this;
        }

        public WhiteSdk build() {
            return new WhiteSdk(this.bridge, this.context, this.whiteSdkConfiguration, this.commonCallback, this.audioMixerBridge, this.audioEffectBridge);
        }
    }

    class RequestSlideLogHandler
    implements PostMessageCallback {
        private static final String SLIDE_REPORT_LOG_KEY = "@slide/_report_log_";
        private final Promise<Boolean> promise;
        private final PrintWriter writer;
        private final int sessionId;

        public RequestSlideLogHandler(File logFile, Promise<Boolean> promise) throws Exception {
            this.promise = promise;
            this.writer = new PrintWriter(new FileWriter(logFile, true));
            this.sessionId = sSessionId.getAndIncrement();
        }

        @Override
        public void onMessage(JSONObject jsonObject) {
            try {
                String type = jsonObject.optString("type");
                int id = jsonObject.optInt("sessionId");
                if (SLIDE_REPORT_LOG_KEY.equals(type) && id == this.sessionId) {
                    String log = jsonObject.getString("log");
                    this.writer.write(log);
                    int total = jsonObject.getInt("total");
                    int index = jsonObject.getInt("index");
                    if (index == total) {
                        this.success();
                    }
                }
            }
            catch (Exception e) {
                this.failure(e);
            }
        }

        private void success() {
            this.writer.close();
            WhiteSdk.this.sdkJsInterface.setPostMessageCallback(null);
            this.promise.then(true);
        }

        private void failure(Exception e) {
            this.writer.close();
            WhiteSdk.this.sdkJsInterface.setPostMessageCallback(null);
            this.promise.catchEx(new SDKError(e.getMessage()));
        }

        public void request() {
            WhiteSdk.this.sdkJsInterface.setPostMessageCallback(this);
            WhiteboardView whiteboardView = (WhiteboardView)WhiteSdk.this.bridge;
            whiteboardView.evaluateJavascript("window.postMessage({'type': \"@slide/_request_log_\",'sessionId': " + this.sessionId + "});");
        }
    }
}

