/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.domain;

import com.google.gson.annotations.SerializedName;
import com.herewhite.sdk.domain.Scene;
import com.herewhite.sdk.domain.WhiteObject;
import java.util.UUID;

public class WindowAppParam {
    public static final String KIND_DOCSVIEWER = "DocsViewer";
    public static final String KIND_MEDIAPLAYER = "MediaPlayer";
    public static final String KIND_SLIDE = "Slide";
    private String kind;
    private Options options;
    private Attributes attributes;

    public WindowAppParam(String kind, Options options, Attributes attributes) {
        this.kind = kind;
        this.options = options;
        this.attributes = attributes;
    }

    public String getKind() {
        return this.kind;
    }

    public Options getOptions() {
        return this.options;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public static WindowAppParam createDocsViewerApp(String scenePath, Scene[] scenes, String title) {
        DocOptions options = new DocOptions(scenePath, scenes, title);
        return new WindowAppParam(KIND_DOCSVIEWER, options, null);
    }

    public static WindowAppParam createMediaPlayerApp(String src, String title) {
        PlayerOptions options = new PlayerOptions(title);
        PlayerAttributes attributes = new PlayerAttributes(src);
        return new WindowAppParam(KIND_MEDIAPLAYER, options, attributes);
    }

    public static WindowAppParam createSlideApp(String scenePath, Scene[] scenes, String title) {
        SlideOptions options = new SlideOptions(scenePath, scenes, title);
        return new WindowAppParam(KIND_SLIDE, options, null);
    }

    public static WindowAppParam createSlideApp(String taskUuid, String prefixUrl, String title) {
        if (!prefixUrl.startsWith("http")) {
            throw new IllegalArgumentException("params error, check taskUuid and prefixUrl");
        }
        return new WindowAppParam(KIND_SLIDE, new ProjectorOptions(String.format("/%s/%s", taskUuid, UUID.randomUUID()), title), new ProjectorAttributes(taskUuid, prefixUrl));
    }

    public static class Attributes
    extends WhiteObject {
    }

    public static class Options
    extends WhiteObject {
        private String title;

        public Options(String title) {
            this.title = title;
        }
    }

    private static class ProjectorAttributes
    extends Attributes {
        @SerializedName(value="taskId")
        private final String taskUuid;
        @SerializedName(value="url")
        private final String prefixUrl;

        public ProjectorAttributes(String taskUuid, String prefixUrl) {
            this.taskUuid = taskUuid;
            this.prefixUrl = prefixUrl;
        }
    }

    private static class ProjectorOptions
    extends Options {
        private final String scenePath;

        public ProjectorOptions(String scenePath, String title) {
            super(title);
            this.scenePath = scenePath;
        }
    }

    private static class PlayerAttributes
    extends Attributes {
        private final String src;

        public PlayerAttributes(String src) {
            this.src = src;
        }
    }

    private static class PlayerOptions
    extends Options {
        public PlayerOptions(String title) {
            super(title);
        }
    }

    private static class SlideOptions
    extends Options {
        private final String scenePath;
        private final Scene[] scenes;

        public SlideOptions(String scenePath, Scene[] scenes, String title) {
            super(title);
            this.scenePath = scenePath;
            this.scenes = scenes;
        }

        public SlideOptions(String scenePath, String title) {
            super(title);
            this.scenePath = scenePath;
            this.scenes = null;
        }
    }

    private static class DocOptions
    extends Options {
        private final String scenePath;
        private final Scene[] scenes;

        public DocOptions(String scenePath, Scene[] scenes, String title) {
            super(title);
            this.scenePath = scenePath;
            this.scenes = scenes;
        }
    }
}

