/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.converter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.herewhite.sdk.ConverterCallbacks;
import com.herewhite.sdk.converter.ConvertType;
import com.herewhite.sdk.converter.ImageFormat;
import com.herewhite.sdk.domain.ConversionInfo;
import com.herewhite.sdk.domain.ConvertErrorCode;
import com.herewhite.sdk.domain.ConvertException;
import com.herewhite.sdk.domain.ConvertedFiles;
import com.herewhite.sdk.domain.ConverterStatus;
import com.herewhite.sdk.domain.PptPage;
import com.herewhite.sdk.domain.Region;
import com.herewhite.sdk.domain.Scene;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ConverterV5 {
    private String resource;
    private ConvertType type;
    private boolean preview;
    private double scale;
    private ImageFormat outputFormat;
    private boolean pack;
    private Region region;
    private String sdkToken;
    private String taskUuid;
    private String taskToken;
    private long interval;
    private long timeout;
    private long startTime;
    private ConverterCallbacks outCallbacks;
    private volatile ConverterStatus status = ConverterStatus.Created;
    static ThreadPoolExecutor executorService = new ThreadPoolExecutor(4, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ConverterThreadFactory());
    private static MediaType JSON;
    private static String PPT_BASE_URL;
    private static String PROGRESS_URL_FORMAT;
    private final Gson gson = new Gson();
    private final OkHttpClient client = new OkHttpClient();
    static Map<ImageFormat, String> outputFormatMap;

    private ConverterV5(String resource, ConvertType type, boolean preview, double scale, ImageFormat outputFormat, boolean pack, Region region, String sdkToken, String taskUuid, String taskToken, long interval, long timeout, ConverterCallbacks callbacks) {
        this.resource = resource;
        this.type = type;
        this.preview = preview;
        this.scale = scale;
        this.outputFormat = outputFormat;
        this.pack = pack;
        this.region = region;
        this.sdkToken = sdkToken;
        this.taskUuid = taskUuid;
        this.taskToken = taskToken;
        this.interval = interval;
        this.timeout = timeout;
        this.outCallbacks = callbacks;
    }

    public void startConvertTask() {
        if (this.startTime != 0L && this.isNotFinish()) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        executorService.execute(() -> {
            if (this.taskUuid == null) {
                this.requestConvert();
            } else {
                this.status = ConverterStatus.Created;
            }
            if (this.status == ConverterStatus.Created) {
                this.startProgressLoop(this.taskToken != null ? this.taskToken : this.sdkToken);
            }
        });
    }

    private boolean isNotFinish() {
        return this.status != ConverterStatus.Success && this.status != ConverterStatus.Fail;
    }

    public ConverterStatus getStatus() {
        return this.status;
    }

    public String getTaskUuid() {
        return this.taskUuid;
    }

    public String getTaskToken() {
        return this.taskToken != null ? this.taskToken : this.sdkToken;
    }

    private void requestConvert() {
        HashMap<String, Object> roomSpec = new HashMap<String, Object>();
        roomSpec.put("resource", this.resource);
        roomSpec.put("type", this.convertType(this.type));
        roomSpec.put("preview", this.preview);
        if (this.type == ConvertType.Static) {
            roomSpec.put("scale", this.scale);
            roomSpec.put("outputFormat", this.convertOutputFormat(this.outputFormat));
            roomSpec.put("pack", this.pack);
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson(roomSpec));
        Request request = new Request.Builder().url(PPT_BASE_URL).header("token", this.sdkToken).header("region", this.convertRegion(this.region)).header("Content-Type", "application/json").header("Accept", "application/json").post(body).build();
        Call call = this.client.newCall(request);
        try {
            Response response = call.execute();
            if (response.code() >= 200 && response.code() <= 204) {
                JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)response.body().string());
                this.taskUuid = jsonObject.get("uuid").getAsString();
                this.type = this.parseType(jsonObject.get("type").getAsString());
                this.status = ConverterStatus.Created;
            } else {
                this.onFailure(new ConvertException(ConvertErrorCode.ConvertFail, response.body().string()));
                this.status = ConverterStatus.CreateFail;
            }
        }
        catch (IOException e) {
            this.onFailure(new ConvertException(ConvertErrorCode.CreatedFail, e));
            this.status = ConverterStatus.CreateFail;
        }
    }

    private ConvertType parseType(String type) {
        if ("static".equals(type)) {
            return ConvertType.Static;
        }
        return ConvertType.Dynamic;
    }

    private String convertType(ConvertType type) {
        if (type == ConvertType.Dynamic) {
            return "dynamic";
        }
        return "static";
    }

    private String convertRegion(Region region) {
        JsonElement regionElement = this.gson.toJsonTree((Object)region);
        return regionElement.getAsString();
    }

    private String convertOutputFormat(ImageFormat outputFormat) {
        return outputFormatMap.get((Object)outputFormat);
    }

    private void startProgressLoop(String token) {
        long timeLimit = this.startTime + this.timeout;
        try {
            this.status = ConverterStatus.Checking;
            while (System.currentTimeMillis() < timeLimit) {
                if (this.status != ConverterStatus.Checking) {
                    return;
                }
                this.checkProgress(token);
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.onFailure(new ConvertException(ConvertErrorCode.CheckTimeout));
            this.status = ConverterStatus.Timeout;
        }
        catch (ConvertException e) {
            this.onFailure(e);
            this.status = ConverterStatus.Fail;
        }
    }

    private void checkProgress(String token) throws ConvertException {
        block7: {
            Request request = new Request.Builder().url(String.format(PROGRESS_URL_FORMAT, this.taskUuid, this.convertType(this.type))).header("token", token).header("region", this.convertRegion(this.region)).header("Content-Type", "application/json").header("Accept", "application/json").build();
            Call call = this.client.newCall(request);
            try {
                Response response = call.execute();
                String body = response.body().string();
                System.out.println(body);
                if (response.code() == 200) {
                    QueryInfo queryInfo = (QueryInfo)this.gson.fromJson(body, QueryInfo.class);
                    ConversionInfo info = queryInfo.progress;
                    ConversionInfo.ServerConversionStatus status = queryInfo.status;
                    if (status == ConversionInfo.ServerConversionStatus.Fail || status == ConversionInfo.ServerConversionStatus.NotFound) {
                        ConvertErrorCode code = status == ConversionInfo.ServerConversionStatus.Fail ? ConvertErrorCode.ConvertFail : ConvertErrorCode.NotFound;
                        this.onFailure(new ConvertException(code, queryInfo.failedReason));
                        this.status = ConverterStatus.Fail;
                    } else if (status == ConversionInfo.ServerConversionStatus.Finished) {
                        this.onFinish(this.getPpt(info, this.type), info);
                        this.status = ConverterStatus.Success;
                    } else {
                        this.onProgress(info.getConvertedPercentage(), queryInfo.progress);
                    }
                    break block7;
                }
                throw new ConvertException(ConvertErrorCode.ConvertFail, body);
            }
            catch (IOException e) {
                throw new ConvertException(ConvertErrorCode.CheckFail, e);
            }
        }
    }

    private void onFinish(ConvertedFiles convertedFiles, ConversionInfo info) {
        if (this.outCallbacks != null) {
            this.outCallbacks.onFinish(convertedFiles, info);
        }
    }

    private void onFailure(ConvertException e) {
        if (this.outCallbacks != null) {
            this.outCallbacks.onFailure(e);
        }
    }

    private void onProgress(Double convertedPercentage, ConversionInfo info) {
        if (this.outCallbacks != null) {
            this.outCallbacks.onProgress(convertedPercentage, info);
        }
    }

    private ConvertedFiles getPpt(ConversionInfo info, ConvertType type) {
        int length = info.getConvertedFileList().length;
        String[] sliderURLs = new String[length];
        Scene[] scenes = new Scene[length];
        for (int i = 0; i < length; ++i) {
            PptPage pptPage = info.getConvertedFileList()[i];
            sliderURLs[i] = pptPage.getSrc();
            scenes[i] = new Scene(String.valueOf(i + 1), pptPage);
        }
        ConvertedFiles files = new ConvertedFiles();
        files.setTaskId(this.taskUuid);
        files.setType(type);
        files.setSlideURLs(sliderURLs);
        files.setScenes(scenes);
        return files;
    }

    static {
        executorService.allowCoreThreadTimeOut(true);
        JSON = MediaType.parse((String)"application/json; charset=utf-8");
        PPT_BASE_URL = "https://api.netless.link/v5/services/conversion/tasks";
        PROGRESS_URL_FORMAT = PPT_BASE_URL + "/%s?type=%s";
        outputFormatMap = new HashMap<ImageFormat, String>();
        outputFormatMap.put(ImageFormat.PNG, "png");
        outputFormatMap.put(ImageFormat.JPG, "jpg");
        outputFormatMap.put(ImageFormat.JPEG, "jpeg");
        outputFormatMap.put(ImageFormat.WEBP, "webp");
    }

    class QueryInfo {
        String uuid;
        ConvertType type;
        ConversionInfo.ServerConversionStatus status;
        String failedReason;
        ConversionInfo progress;

        QueryInfo() {
        }
    }

    public static class Builder {
        private String resource;
        private ConvertType type;
        private boolean preview = false;
        private double scale = 1.2;
        private ImageFormat outputFormat;
        private boolean pack = false;
        private Region region;
        private String sdkToken;
        private String taskUuid;
        private String taskToken;
        private long interval;
        private long timeout;
        private ConverterCallbacks callback;

        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder setType(ConvertType type) {
            this.type = type;
            return this;
        }

        public Builder setPreview(boolean preview) {
            this.preview = preview;
            return this;
        }

        public Builder setScale(double scale) {
            this.scale = scale;
            return this;
        }

        public Builder setOutputFormat(ImageFormat outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public Builder setPack(boolean pack) {
            this.pack = pack;
            return this;
        }

        public Builder setRegion(Region region) {
            this.region = region;
            return this;
        }

        public Builder setSdkToken(String sdkToken) {
            this.sdkToken = sdkToken;
            return this;
        }

        public Builder setTaskUuid(String taskUuid) {
            this.taskUuid = taskUuid;
            return this;
        }

        public Builder setTaskToken(String taskToken) {
            this.taskToken = taskToken;
            return this;
        }

        public Builder setPoolInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setCallback(ConverterCallbacks callback) {
            this.callback = callback;
            return this;
        }

        public ConverterV5 build() {
            if (this.region == null) {
                this.region = Region.cn;
            }
            if (this.sdkToken == null && (this.taskToken == null || this.taskUuid == null)) {
                throw new RuntimeException("taskToken and taskUuid should not be null");
            }
            if (this.outputFormat == null) {
                this.outputFormat = ImageFormat.PNG;
            }
            if (this.timeout == 0L) {
                this.timeout = 180000L;
            }
            if (this.interval == 0L) {
                this.interval = 15000L;
            }
            return new ConverterV5(this.resource, this.type, this.preview, this.scale, this.outputFormat, this.pack, this.region, this.sdkToken, this.taskUuid, this.taskToken, this.interval, this.timeout, this.callback);
        }
    }

    private static final class ConverterThreadFactory
    implements ThreadFactory {
        private ConverterThreadFactory() {
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable, "white-sdk-converter");
            result.setPriority(1);
            return result;
        }
    }
}

