/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import androidx.annotation.NonNull;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.Utils;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.SDKError;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class SyncedStore {
    private final JsBridgeInterface bridge;
    private final HashMap<String, JsonObject> storages = new HashMap();
    private final HashMap<String, CopyOnWriteArraySet<OnStateChangedListener>> listenersByName = new HashMap();

    public SyncedStore(JsBridgeInterface bridge) {
        this.bridge = bridge;
    }

    public void connectStorage(String name, String defaultJson, Promise<String> promise) {
        this.bridge.callHandler("store.connectStorage", new Object[]{name, Utils.asJSONObject(defaultJson)}, retValue -> {
            SDKError sdkError = SDKError.promiseError(retValue);
            if (sdkError == null) {
                JsonObject state = Utils.fromJson(retValue, JsonObject.class);
                this.storages.put(name, state);
                promise.then((String)retValue);
            } else {
                promise.catchEx(sdkError);
            }
        });
    }

    public String getStorageState(String name) {
        return Utils.toJson(this.storages.get(name));
    }

    public void getStorageState(String name, Promise<String> promise) {
        this.bridge.callHandler("store.getStorageState", new Object[]{name}, retValue -> {
            try {
                promise.then((String)retValue);
            }
            catch (Exception e) {
                promise.catchEx(SDKError.promiseError(e.getMessage()));
            }
        });
    }

    public void setStorageState(String name, String json) {
        this.bridge.callHandler("store.setStorageState", new Object[]{name, Utils.asJSONObject(json)});
    }

    public void disconnectStorage(String name) {
        this.bridge.callHandler("store.disconnectStorage", new Object[]{name});
        this.listenersByName.remove(name);
    }

    public void deleteStorage(String name) {
        this.bridge.callHandler("store.deleteStorage", new Object[]{name});
    }

    public void resetState(String name) {
        this.bridge.callHandler("store.resetState", new Object[]{name});
    }

    void fireStorageStateUpdate(String valueOf) {
        StorageStateUpdate stateUpdate = Utils.fromJson(valueOf, StorageStateUpdate.class);
        String name = stateUpdate.name;
        JsonObject data = stateUpdate.data;
        if (this.storages.containsKey(name)) {
            JsonObject merged = SyncedStore.mergeUpdate(this.storages.get(name).deepCopy(), SyncedStore.getNewValueObject(data));
            this.storages.put(stateUpdate.name, merged);
            String value = Utils.toJson(merged);
            String diff = Utils.toJsonWithNull(data);
            this.notifyStateChanged(stateUpdate.name, value, diff);
        }
    }

    private void notifyStateChanged(String name, String value, String diff) {
        CopyOnWriteArraySet<OnStateChangedListener> listeners = this.listenersByName.get(name);
        if (listeners == null) {
            return;
        }
        for (OnStateChangedListener listener : listeners) {
            listener.onStateChanged(value, diff);
        }
    }

    private static JsonObject getNewValueObject(JsonObject update) {
        JsonObject result = new JsonObject();
        for (String key : update.keySet()) {
            JsonObject updateItem = update.get(key).getAsJsonObject();
            if (updateItem.has("newValue")) {
                result.add(key, updateItem.get("newValue"));
                continue;
            }
            result.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return result;
    }

    private static JsonObject mergeUpdate(JsonObject object, JsonObject update) {
        for (String key : update.keySet()) {
            object.add(key, update.get(key));
        }
        return object;
    }

    public void addOnStateChangedListener(String name, @NonNull OnStateChangedListener listener) {
        CopyOnWriteArraySet<OnStateChangedListener> listeners = this.listenersByName.get(name);
        if (listeners == null) {
            listeners = new CopyOnWriteArraySet();
            this.listenersByName.put(name, listeners);
        }
        listeners.add(listener);
    }

    public void removeOnStateChangedListener(String name, OnStateChangedListener listener) {
        CopyOnWriteArraySet<OnStateChangedListener> listeners = this.listenersByName.get(name);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    static class StorageStateUpdate {
        public String name;
        public JsonObject data;

        StorageStateUpdate() {
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(String var1, String var2);
    }
}

