/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.domain;

import androidx.annotation.NonNull;

public final class AssetsHttpsOptions {
    private static final String DEFAULT_PROTOCOL = "https";
    private static final String DEFAULT_DOMAIN = "sdk.herewhite.com";
    private static final String DEFAULT_ASSETS_PATH = "/assets/";
    private static final String DEFAULT_ENTRY_PATH = "whiteboard/index.html";
    private String protocol = "https";
    private String domain = "sdk.herewhite.com";
    private String assetsPath = "/assets/";
    private String entryPath = "whiteboard/index.html";

    @NonNull
    public String getDomain() {
        return this.domain;
    }

    public AssetsHttpsOptions setDomain(@NonNull String domain) {
        this.domain = AssetsHttpsOptions.trimSlashes(domain);
        return this;
    }

    public AssetsHttpsOptions setProtocol(@NonNull String protocol) {
        this.protocol = protocol.replace("://", "");
        return this;
    }

    @NonNull
    public String getAssetsPath() {
        return this.assetsPath;
    }

    @NonNull
    public String getEntryPath() {
        return this.entryPath;
    }

    @NonNull
    public String buildEntryUrl() {
        return this.protocol + "://" + this.domain + this.assetsPath + AssetsHttpsOptions.trimLeadingSlash(this.entryPath);
    }

    public AssetsHttpsOptions setAssetsPath(@NonNull String assetsPath) {
        this.assetsPath = AssetsHttpsOptions.normalizePath(assetsPath);
        return this;
    }

    public AssetsHttpsOptions setEntryPath(@NonNull String entryPath) {
        this.entryPath = AssetsHttpsOptions.trimLeadingSlash(entryPath);
        return this;
    }

    private static String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private static String trimLeadingSlash(String value) {
        while (value.startsWith("/")) {
            value = value.substring(1);
        }
        return value;
    }

    private static String trimSlashes(String value) {
        int start;
        int end = value.length();
        for (start = 0; start < end && value.charAt(start) == '/'; ++start) {
        }
        while (end > start && value.charAt(end - 1) == '/') {
            --end;
        }
        return value.substring(start, end);
    }
}

