/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.webkit.JavascriptInterface;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.herewhite.sdk.RoomDelegate;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.FrameError;
import com.herewhite.sdk.domain.RoomPhase;
import com.herewhite.sdk.internal.JsCallWrapper;

class RoomJsInterfaceImpl {
    private static final Gson gson = new Gson();
    @Nullable
    private RoomDelegate room;

    RoomJsInterfaceImpl() {
    }

    void setRoom(RoomDelegate room) {
        this.room = room;
    }

    @JavascriptInterface
    public void fireCanUndoStepsUpdate(Object args) {
        if (this.room != null) {
            this.room.fireCanUndoStepsUpdate(Long.valueOf(String.valueOf(args)));
        }
    }

    @JavascriptInterface
    public void fireCanRedoStepsUpdate(Object args) {
        if (this.room != null) {
            this.room.onCanRedoStepsUpdate(Long.valueOf(String.valueOf(args)));
        }
    }

    @JavascriptInterface
    public void fireMagixEvent(Object args) {
        if (this.room != null) {
            new JsCallWrapper(() -> {
                EventEntry eventEntry = (EventEntry)gson.fromJson(String.valueOf(args), EventEntry.class);
                this.room.fireMagixEvent(eventEntry);
            }, "An exception occurred while sending the event").run();
        }
    }

    @JavascriptInterface
    public void fireHighFrequencyEvent(Object args) {
        if (this.room != null) {
            new JsCallWrapper(() -> {
                EventEntry[] events = (EventEntry[])gson.fromJson(String.valueOf(args), EventEntry[].class);
                this.room.fireHighFrequencyEvent(events);
            }, "An exception occurred while sending the event").run();
        }
    }

    @JavascriptInterface
    public void firePhaseChanged(Object args) {
        if (this.room != null) {
            new JsCallWrapper(() -> this.room.firePhaseChanged(RoomPhase.valueOf(String.valueOf(args))), "An exception occurred while invoke onPhaseChanged method").run();
        }
    }

    @JavascriptInterface
    public void fireKickedWithReason(Object args) {
        if (this.room != null) {
            new JsCallWrapper(() -> this.room.fireKickedWithReason(String.valueOf(args)), "An exception occurred while invoke onKickedWithReason method").run();
        }
    }

    @JavascriptInterface
    public void fireDisconnectWithError(Object args) {
        if (this.room != null) {
            new JsCallWrapper(() -> this.room.fireDisconnectWithError(new Exception(String.valueOf(args))), "An exception occurred while invoke onDisconnectWithError method").run();
        }
    }

    @JavascriptInterface
    public void fireRoomStateChanged(Object args) {
        if (this.room != null) {
            this.room.fireRoomStateChanged(String.valueOf(args));
        }
    }

    @JavascriptInterface
    public void fireCatchErrorWhenAppendFrame(Object args) {
        if (this.room != null) {
            new JsCallWrapper(() -> {
                FrameError frameError = (FrameError)gson.fromJson(String.valueOf(args), FrameError.class);
                this.room.fireCatchErrorWhenAppendFrame(frameError.getUserId(), new Exception(frameError.getError()));
            }, "An exception occurred while invoke onCatchErrorWhenAppendFrame method").run();
        }
    }
}

