/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import com.google.gson.Gson;
import com.herewhite.sdk.domain.WhiteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import wendu.dsbridge.DWebView;
import wendu.dsbridge.OnReturnValue;

public class WhiteboardView
extends DWebView {
    private static final Gson gson = new Gson();
    private static final Class[] PRIMITIVE_TYPES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class};
    private static List<Class> PRIMITIVE_LIST = new ArrayList<Class>(Arrays.asList(PRIMITIVE_TYPES));

    public WhiteboardView(Context context) {
        super(WhiteboardView.getFixedContext(context));
        this.init();
    }

    public WhiteboardView(Context context, AttributeSet attrs) {
        super(WhiteboardView.getFixedContext(context), attrs);
        this.init();
    }

    public static Context getFixedContext(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return context.createConfigurationContext(new Configuration());
        }
        return context;
    }

    private void init() {
        this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        this.loadUrl("file:///android_asset/whiteboard/index.html");
        this.setWebChromeClient(new FixWebChromeClient());
    }

    private int getWebViewVersion() {
        String userAgent = this.getSettings().getUserAgentString();
        Pattern pattern = Pattern.compile("Chrome/([\\d]+)", 2);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            String group = matcher.group(1);
            return Integer.valueOf(group);
        }
        return 0;
    }

    public <T> void callHandler(String method, Object[] args, OnReturnValue<T> handler) {
        super.callHandler(method, this.toMaps(args), handler);
    }

    public void callHandler(String method, Object[] args) {
        this.callHandler(method, args, null);
    }

    public <T> void callHandler(String method, OnReturnValue<T> handler) {
        this.callHandler(method, null, handler);
    }

    private Object[] toMaps(Object[] objects) {
        if (objects != null) {
            Object[] maps = new Object[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                maps[i] = this.toJSON(objects[i]);
            }
            return maps;
        }
        return new Object[0];
    }

    private static boolean isPrimitiveOrStringOrNull(Object target) {
        if (target instanceof String) {
            return true;
        }
        if (target == null) {
            return true;
        }
        return PRIMITIVE_LIST.contains(target.getClass());
    }

    private Object toJSON(Object object) {
        if (object instanceof String[]) {
            return object;
        }
        if (WhiteboardView.isPrimitiveOrStringOrNull(object)) {
            return object;
        }
        if (object instanceof WhiteObject) {
            return ((WhiteObject)object).toJSON();
        }
        if (object instanceof WhiteObject[]) {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            for (int i = 0; i < ((WhiteObject[])object).length; ++i) {
                list.add(((WhiteObject[])object)[i].toJSON());
            }
            return list;
        }
        return gson.toJson(object);
    }

    class FixWebChromeClient
    extends WebChromeClient {
        FixWebChromeClient() {
        }

        public Bitmap getDefaultVideoPoster() {
            try {
                int width = 100;
                int height = 50;
                return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (Exception e) {
                return super.getDefaultVideoPoster();
            }
        }
    }
}

