/*
 * Decompiled with CFR 0.152.
 */
package com.jeremyliao.liveeventbus.core;

import android.app.Application;
import android.arch.lifecycle.ExternalLiveData;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jeremyliao.liveeventbus.core.Config;
import com.jeremyliao.liveeventbus.core.Observable;
import com.jeremyliao.liveeventbus.core.ObservableConfig;
import com.jeremyliao.liveeventbus.ipc.core.ProcessorManager;
import com.jeremyliao.liveeventbus.ipc.receiver.LebIpcReceiver;
import com.jeremyliao.liveeventbus.logger.DefaultLogger;
import com.jeremyliao.liveeventbus.logger.Logger;
import com.jeremyliao.liveeventbus.logger.LoggerManager;
import com.jeremyliao.liveeventbus.utils.AppUtils;
import com.jeremyliao.liveeventbus.utils.ThreadUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public final class LiveEventBusCore {
    private final Map<String, LiveEvent<Object>> bus;
    private final Config config = new Config();
    private boolean lifecycleObserverAlwaysActive = true;
    private boolean autoClear = false;
    private LoggerManager logger;
    private final Map<String, ObservableConfig> observableConfigs;
    private LebIpcReceiver receiver;
    private boolean isRegisterReceiver = false;
    final InnerConsole console = new InnerConsole();

    public static LiveEventBusCore get() {
        return SingletonHolder.DEFAULT_BUS;
    }

    private LiveEventBusCore() {
        this.bus = new HashMap<String, LiveEvent<Object>>();
        this.observableConfigs = new HashMap<String, ObservableConfig>();
        this.logger = new LoggerManager(new DefaultLogger());
        this.receiver = new LebIpcReceiver();
        this.registerReceiver();
    }

    public synchronized <T> Observable<T> with(String key, Class<T> type) {
        if (!this.bus.containsKey(key)) {
            this.bus.put(key, new LiveEvent(key));
        }
        return this.bus.get(key);
    }

    public Config config() {
        return this.config;
    }

    public ObservableConfig config(String key) {
        if (!this.observableConfigs.containsKey(key)) {
            this.observableConfigs.put(key, new ObservableConfig());
        }
        return this.observableConfigs.get(key);
    }

    void setLogger(@NonNull Logger logger) {
        this.logger.setLogger(logger);
    }

    void enableLogger(boolean enable) {
        this.logger.setEnable(enable);
    }

    void registerReceiver() {
        if (this.isRegisterReceiver) {
            return;
        }
        Application application = AppUtils.getApp();
        if (application != null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("intent.action.ACTION_LEB_IPC");
            if (Build.VERSION.SDK_INT >= 34) {
                application.registerReceiver((BroadcastReceiver)this.receiver, intentFilter, 2);
            } else {
                application.registerReceiver((BroadcastReceiver)this.receiver, intentFilter);
            }
            this.isRegisterReceiver = true;
        }
    }

    void setLifecycleObserverAlwaysActive(boolean lifecycleObserverAlwaysActive) {
        this.lifecycleObserverAlwaysActive = lifecycleObserverAlwaysActive;
    }

    void setAutoClear(boolean autoClear) {
        this.autoClear = autoClear;
    }

    class InnerConsole {
        InnerConsole() {
        }

        String getConsoleInfo() {
            StringBuilder sb = new StringBuilder();
            sb.append("*********Base info*********").append("\n");
            sb.append(this.getBaseInfo());
            sb.append("*********Event info*********").append("\n");
            sb.append(this.getBusInfo());
            return sb.toString();
        }

        String getBaseInfo() {
            StringBuilder sb = new StringBuilder();
            sb.append("lifecycleObserverAlwaysActive: ").append(LiveEventBusCore.this.lifecycleObserverAlwaysActive).append("\n").append("autoClear: ").append(LiveEventBusCore.this.autoClear).append("\n").append("logger enable: ").append(LiveEventBusCore.this.logger.isEnable()).append("\n").append("logger: ").append(LiveEventBusCore.this.logger.getLogger()).append("\n").append("Receiver register: ").append(LiveEventBusCore.this.isRegisterReceiver).append("\n").append("Application: ").append(AppUtils.getApp()).append("\n");
            return sb.toString();
        }

        String getBusInfo() {
            StringBuilder sb = new StringBuilder();
            for (String key : LiveEventBusCore.this.bus.keySet()) {
                sb.append("Event name: " + key).append("\n");
                LiveEvent.LifecycleLiveData liveData = ((LiveEvent)LiveEventBusCore.this.bus.get(key)).liveData;
                sb.append("\tversion: " + liveData.getVersion()).append("\n");
                sb.append("\thasActiveObservers: " + liveData.hasActiveObservers()).append("\n");
                sb.append("\thasObservers: " + liveData.hasObservers()).append("\n");
                sb.append("\tActiveCount: " + this.getActiveCount((LiveData)liveData)).append("\n");
                sb.append("\tObserverCount: " + this.getObserverCount((LiveData)liveData)).append("\n");
                sb.append("\tObservers: ").append("\n");
                sb.append("\t\t" + this.getObserverInfo((LiveData)liveData)).append("\n");
            }
            return sb.toString();
        }

        private int getActiveCount(LiveData liveData) {
            try {
                Field field = LiveData.class.getDeclaredField("mActiveCount");
                field.setAccessible(true);
                return (Integer)field.get(liveData);
            }
            catch (Exception e) {
                return -1;
            }
        }

        private int getObserverCount(LiveData liveData) {
            try {
                Field field = LiveData.class.getDeclaredField("mObservers");
                field.setAccessible(true);
                Object mObservers = field.get(liveData);
                Class<?> classOfSafeIterableMap = mObservers.getClass();
                Method size = classOfSafeIterableMap.getDeclaredMethod("size", new Class[0]);
                size.setAccessible(true);
                return (Integer)size.invoke(mObservers, new Object[0]);
            }
            catch (Exception e) {
                return -1;
            }
        }

        private String getObserverInfo(LiveData liveData) {
            try {
                Field field = LiveData.class.getDeclaredField("mObservers");
                field.setAccessible(true);
                Object mObservers = field.get(liveData);
                return mObservers.toString();
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    private class ObserverWrapper<T>
    implements Observer<T> {
        @NonNull
        private final Observer<T> observer;
        private boolean preventNextEvent = false;

        ObserverWrapper(Observer<T> observer) {
            this.observer = observer;
        }

        public void onChanged(@Nullable T t) {
            if (this.preventNextEvent) {
                this.preventNextEvent = false;
                return;
            }
            LiveEventBusCore.this.logger.log(Level.INFO, "message received: " + t);
            try {
                this.observer.onChanged(t);
            }
            catch (ClassCastException e) {
                LiveEventBusCore.this.logger.log(Level.WARNING, "class cast error on message received: " + t, e);
            }
            catch (Exception e) {
                LiveEventBusCore.this.logger.log(Level.WARNING, "error on message received: " + t, e);
            }
        }
    }

    private class LiveEvent<T>
    implements Observable<T> {
        @NonNull
        private final String key;
        private final LifecycleLiveData<T> liveData;
        private final Map<Observer, ObserverWrapper<T>> observerMap = new HashMap<Observer, ObserverWrapper<T>>();
        private final Handler mainHandler = new Handler(Looper.getMainLooper());

        LiveEvent(String key) {
            this.key = key;
            this.liveData = new LifecycleLiveData(key);
        }

        @Override
        public void post(T value) {
            if (ThreadUtils.isMainThread()) {
                this.postInternal(value);
            } else {
                this.mainHandler.post((Runnable)new PostValueTask(value));
            }
        }

        @Override
        public void postAcrossProcess(T value) {
            this.broadcast(value, false, true);
        }

        @Override
        public void postAcrossApp(T value) {
            this.broadcast(value, false, false);
        }

        @Override
        public void postDelay(T value, long delay) {
            this.mainHandler.postDelayed((Runnable)new PostValueTask(value), delay);
        }

        @Override
        public void postDelay(LifecycleOwner owner, T value, long delay) {
            this.mainHandler.postDelayed((Runnable)new PostLifeValueTask(value, owner), delay);
        }

        @Override
        public void postOrderly(T value) {
            this.mainHandler.post((Runnable)new PostValueTask(value));
        }

        @Override
        @Deprecated
        public void broadcast(T value) {
            this.broadcast(value, false, false);
        }

        @Override
        public void broadcast(final T value, final boolean foreground, final boolean onlyInApp) {
            if (AppUtils.getApp() != null) {
                if (ThreadUtils.isMainThread()) {
                    this.broadcastInternal(value, foreground, onlyInApp);
                } else {
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            LiveEvent.this.broadcastInternal(value, foreground, onlyInApp);
                        }
                    });
                }
            } else {
                this.post(value);
            }
        }

        @Override
        public void observe(final @NonNull LifecycleOwner owner, final @NonNull Observer<T> observer) {
            if (ThreadUtils.isMainThread()) {
                this.observeInternal(owner, observer);
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        LiveEvent.this.observeInternal(owner, observer);
                    }
                });
            }
        }

        @Override
        public void observeSticky(final @NonNull LifecycleOwner owner, final @NonNull Observer<T> observer) {
            if (ThreadUtils.isMainThread()) {
                this.observeStickyInternal(owner, observer);
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        LiveEvent.this.observeStickyInternal(owner, observer);
                    }
                });
            }
        }

        @Override
        public void observeForever(final @NonNull Observer<T> observer) {
            if (ThreadUtils.isMainThread()) {
                this.observeForeverInternal(observer);
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        LiveEvent.this.observeForeverInternal(observer);
                    }
                });
            }
        }

        @Override
        public void observeStickyForever(final @NonNull Observer<T> observer) {
            if (ThreadUtils.isMainThread()) {
                this.observeStickyForeverInternal(observer);
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        LiveEvent.this.observeStickyForeverInternal(observer);
                    }
                });
            }
        }

        @Override
        public void removeObserver(final @NonNull Observer<T> observer) {
            if (ThreadUtils.isMainThread()) {
                this.removeObserverInternal(observer);
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        LiveEvent.this.removeObserverInternal(observer);
                    }
                });
            }
        }

        @MainThread
        private void postInternal(T value) {
            LiveEventBusCore.this.logger.log(Level.INFO, "post: " + value + " with key: " + this.key);
            this.liveData.setValue(value);
        }

        @MainThread
        private void broadcastInternal(T value, boolean foreground, boolean onlyInApp) {
            LiveEventBusCore.this.logger.log(Level.INFO, "broadcast: " + value + " foreground: " + foreground + " with key: " + this.key);
            Application application = AppUtils.getApp();
            if (application == null) {
                LiveEventBusCore.this.logger.log(Level.WARNING, "application is null, you can try setContext() when config");
                return;
            }
            Intent intent = new Intent("intent.action.ACTION_LEB_IPC");
            if (foreground && Build.VERSION.SDK_INT >= 16) {
                intent.addFlags(0x10000000);
            }
            if (onlyInApp) {
                intent.setPackage(application.getPackageName());
            }
            intent.putExtra("leb_ipc_key", this.key);
            boolean handle = ProcessorManager.getManager().writeTo(intent, value);
            try {
                if (handle) {
                    application.sendBroadcast(intent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @MainThread
        private void observeInternal(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
            ObserverWrapper<T> observerWrapper = new ObserverWrapper<T>(observer);
            ((ObserverWrapper)observerWrapper).preventNextEvent = this.liveData.getVersion() > -1;
            this.liveData.observe(owner, observerWrapper);
            LiveEventBusCore.this.logger.log(Level.INFO, "observe observer: " + observerWrapper + "(" + observer + ") on owner: " + owner + " with key: " + this.key);
        }

        @MainThread
        private void observeStickyInternal(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
            ObserverWrapper<T> observerWrapper = new ObserverWrapper<T>(observer);
            this.liveData.observe(owner, observerWrapper);
            LiveEventBusCore.this.logger.log(Level.INFO, "observe sticky observer: " + observerWrapper + "(" + observer + ") on owner: " + owner + " with key: " + this.key);
        }

        @MainThread
        private void observeForeverInternal(@NonNull Observer<T> observer) {
            ObserverWrapper<T> observerWrapper = new ObserverWrapper<T>(observer);
            ((ObserverWrapper)observerWrapper).preventNextEvent = this.liveData.getVersion() > -1;
            this.observerMap.put(observer, observerWrapper);
            this.liveData.observeForever(observerWrapper);
            LiveEventBusCore.this.logger.log(Level.INFO, "observe forever observer: " + observerWrapper + "(" + observer + ") with key: " + this.key);
        }

        @MainThread
        private void observeStickyForeverInternal(@NonNull Observer<T> observer) {
            ObserverWrapper<T> observerWrapper = new ObserverWrapper<T>(observer);
            this.observerMap.put(observer, observerWrapper);
            this.liveData.observeForever(observerWrapper);
            LiveEventBusCore.this.logger.log(Level.INFO, "observe sticky forever observer: " + observerWrapper + "(" + observer + ") with key: " + this.key);
        }

        @MainThread
        private void removeObserverInternal(@NonNull Observer<T> observer) {
            Observer realObserver = this.observerMap.containsKey(observer) ? (Observer)this.observerMap.remove(observer) : observer;
            this.liveData.removeObserver(realObserver);
        }

        private class PostLifeValueTask
        implements Runnable {
            private Object newValue;
            private LifecycleOwner owner;

            public PostLifeValueTask(@Nullable Object newValue, LifecycleOwner owner) {
                this.newValue = newValue;
                this.owner = owner;
            }

            @Override
            public void run() {
                if (this.owner != null && this.owner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                    LiveEvent.this.postInternal(this.newValue);
                }
            }
        }

        private class PostValueTask
        implements Runnable {
            private Object newValue;

            public PostValueTask(Object newValue) {
                this.newValue = newValue;
            }

            @Override
            public void run() {
                LiveEvent.this.postInternal(this.newValue);
            }
        }

        private class LifecycleLiveData<T>
        extends ExternalLiveData<T> {
            private final String key;

            public LifecycleLiveData(String key) {
                this.key = key;
            }

            @Override
            protected Lifecycle.State observerActiveLevel() {
                return this.lifecycleObserverAlwaysActive() ? Lifecycle.State.CREATED : Lifecycle.State.STARTED;
            }

            public void removeObserver(@NonNull Observer<T> observer) {
                super.removeObserver(observer);
                if (this.autoClear() && !LiveEvent.this.liveData.hasObservers()) {
                    LiveEventBusCore.get().bus.remove(this.key);
                }
                LiveEventBusCore.this.logger.log(Level.INFO, "observer removed: " + observer);
            }

            private boolean lifecycleObserverAlwaysActive() {
                if (LiveEventBusCore.this.observableConfigs.containsKey(this.key)) {
                    ObservableConfig config = (ObservableConfig)LiveEventBusCore.this.observableConfigs.get(this.key);
                    if (config.lifecycleObserverAlwaysActive != null) {
                        return config.lifecycleObserverAlwaysActive;
                    }
                }
                return LiveEventBusCore.this.lifecycleObserverAlwaysActive;
            }

            private boolean autoClear() {
                if (LiveEventBusCore.this.observableConfigs.containsKey(this.key)) {
                    ObservableConfig config = (ObservableConfig)LiveEventBusCore.this.observableConfigs.get(this.key);
                    if (config.autoClear != null) {
                        return config.autoClear;
                    }
                }
                return LiveEventBusCore.this.autoClear;
            }
        }
    }

    private static class SingletonHolder {
        private static final LiveEventBusCore DEFAULT_BUS = new LiveEventBusCore();

        private SingletonHolder() {
        }
    }
}

