/*
 * Decompiled with CFR 0.152.
 */
package cn.nekocode.rxlifecycle.compact;

import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import cn.nekocode.rxlifecycle.compact.BindingV4Fragment;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleCompletableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleFlowableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleMaybeTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleObservableTransformer;
import cn.nekocode.rxlifecycle.transformer.BindLifecycleSingleTransformer;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.SingleTransformer;

public class RxLifecycleCompact {
    private static final String FRAGMENT_TAG = "_BINDING_V4_FRAGMENT_";
    private final BindingV4Fragment bindingV4Fragment;

    public static RxLifecycleCompact bind(@NonNull AppCompatActivity targetActivity) {
        return RxLifecycleCompact.bind(targetActivity.getSupportFragmentManager());
    }

    public static RxLifecycleCompact bind(@NonNull Fragment targetFragment) {
        return RxLifecycleCompact.bind(targetFragment.getChildFragmentManager());
    }

    public static RxLifecycleCompact bind(@NonNull FragmentManager fragmentManager) {
        BindingV4Fragment fragment = (BindingV4Fragment)fragmentManager.findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            fragment = new BindingV4Fragment();
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.add((Fragment)fragment, FRAGMENT_TAG);
            transaction.commit();
        } else if (fragment.isDetached()) {
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.attach((Fragment)fragment);
            transaction.commit();
        }
        return new RxLifecycleCompact(fragment);
    }

    private RxLifecycleCompact() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    private RxLifecycleCompact(@NonNull BindingV4Fragment fragment) {
        this.bindingV4Fragment = fragment;
    }

    public Observable<Integer> asObservable() {
        return this.bindingV4Fragment.getLifecycleBehavior().toObservable();
    }

    public Flowable<Integer> asFlowable() {
        return this.bindingV4Fragment.getLifecycleBehavior();
    }

    public <T> FlowableTransformer<T, T> withFlowable() {
        return new BindLifecycleFlowableTransformer(this.bindingV4Fragment.getLifecycleBehavior());
    }

    public <T> ObservableTransformer<T, T> withObservable() {
        return new BindLifecycleObservableTransformer(this.bindingV4Fragment.getLifecycleBehavior());
    }

    public CompletableTransformer withCompletable() {
        return new BindLifecycleCompletableTransformer(this.bindingV4Fragment.getLifecycleBehavior());
    }

    public <T> SingleTransformer<T, T> withSingle() {
        return new BindLifecycleSingleTransformer(this.bindingV4Fragment.getLifecycleBehavior());
    }

    public <T> MaybeTransformer<T, T> withMaybe() {
        return new BindLifecycleMaybeTransformer(this.bindingV4Fragment.getLifecycleBehavior());
    }
}

